/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.sftp.transformers;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class InputStreamToByteArray
extends AbstractTransformer {
    private static final long serialVersionUID = -7444711427779720031L;

    public InputStreamToByteArray() {
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
    }

    public Object doTransform(Object msg, String outputEncoding) throws TransformerException {
        if (msg instanceof InputStream) {
            InputStream inputStream = null;
            try {
                int len;
                inputStream = (InputStream)msg;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = inputStream.read(buffer)) > 0) {
                    baos.write(buffer, 0, len);
                }
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
            catch (Exception e) {
                throw new TransformerException((Transformer)this, (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        throw new TransformerException(MessageFactory.createStaticMessage((String)"Message is not an instance of java.io.InputStream"), (Transformer)this);
    }
}

