/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBBeanInfo;
import org.apache.cxf.jaxb.JAXBContextProxy;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.jaxb.Utils;
import org.apache.cxf.service.ServiceModelVisitor;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JAXBSchemaInitializer
extends ServiceModelVisitor {
    private static final Logger LOG = LogUtils.getLogger(JAXBSchemaInitializer.class);
    private SchemaCollection schemas;
    private JAXBContextProxy context;
    private final boolean qualifiedSchemas;

    public JAXBSchemaInitializer(ServiceInfo serviceInfo, SchemaCollection col, JAXBContext context, boolean q) {
        super(serviceInfo);
        this.schemas = col;
        this.context = (JAXBContextProxy)ReflectionInvokationHandler.createProxyWrapper((Object)context, JAXBContextProxy.class);
        this.qualifiedSchemas = q;
    }

    static Class<?> getArrayComponentType(Type cls) {
        if (cls instanceof Class) {
            if (((Class)cls).isArray()) {
                return ((Class)cls).getComponentType();
            }
            return (Class)cls;
        }
        if (cls instanceof ParameterizedType) {
            int i$ = 0;
            Type[] arr$ = ((ParameterizedType)cls).getActualTypeArguments();
            int len$ = arr$.length;
            if (i$ < len$) {
                Type t2 = arr$[i$];
                return JAXBSchemaInitializer.getArrayComponentType(t2);
            }
        } else if (cls instanceof GenericArrayType) {
            GenericArrayType gt = (GenericArrayType)cls;
            Class ct = (Class)gt.getGenericComponentType();
            return Array.newInstance(ct, 0).getClass();
        }
        return null;
    }

    public JAXBBeanInfo getBeanInfo(Type cls) {
        if (cls instanceof Class) {
            if (((Class)cls).isArray()) {
                return this.getBeanInfo(((Class)cls).getComponentType());
            }
            return this.getBeanInfo((Class)cls);
        }
        if (cls instanceof ParameterizedType) {
            int i$ = 0;
            Type[] arr$ = ((ParameterizedType)cls).getActualTypeArguments();
            int len$ = arr$.length;
            if (i$ < len$) {
                Type t2 = arr$[i$];
                return this.getBeanInfo(t2);
            }
        } else if (cls instanceof GenericArrayType) {
            GenericArrayType gt = (GenericArrayType)cls;
            Class<?> ct = (Class<?>)gt.getGenericComponentType();
            ct = Array.newInstance(ct, 0).getClass();
            return this.getBeanInfo(ct);
        }
        return null;
    }

    public JAXBBeanInfo getBeanInfo(Class<?> cls) {
        return JAXBSchemaInitializer.getBeanInfo(this.context, cls);
    }

    public static JAXBBeanInfo getBeanInfo(JAXBContextProxy context, Class<?> cls) {
        return JAXBUtils.getBeanInfo((JAXBContextProxy)context, cls);
    }

    public void begin(MessagePartInfo part) {
        boolean hasType;
        Annotation[] anns;
        XmlJavaTypeAdapter jta;
        JAXBBeanInfo beanInfo;
        if (part.getTypeQName() != null || part.getElementQName() != null) {
            this.checkForExistence(part);
            return;
        }
        Class<?> clazz = part.getTypeClass();
        if (clazz == null) {
            return;
        }
        boolean isFromWrapper = part.getMessageInfo().getOperation().isUnwrapped();
        boolean isList = false;
        if (clazz.isArray()) {
            if (isFromWrapper && !Byte.TYPE.equals(clazz.getComponentType())) {
                clazz = clazz.getComponentType();
            } else if (!isFromWrapper) {
                Annotation[] anns2;
                for (Annotation a : anns2 = (Annotation[])part.getProperty("parameter.annotations")) {
                    if (!(a instanceof XmlList)) continue;
                    part.setProperty("honor.jaxb.annotations", (Object)Boolean.TRUE);
                    clazz = clazz.getComponentType();
                    isList = true;
                }
            }
        }
        if ((beanInfo = this.getBeanInfo(clazz)) == null && (jta = this.findFromTypeAdapter(clazz, anns = (Annotation[])part.getProperty("parameter.annotations"))) != null) {
            beanInfo = this.findFromTypeAdapter(jta.value());
            if (anns == null) {
                anns = new Annotation[]{jta};
            } else {
                boolean found = false;
                for (Annotation t : anns) {
                    if (t != jta) continue;
                    found = true;
                }
                if (!found) {
                    Annotation[] tmp = new Annotation[anns.length + 1];
                    System.arraycopy(anns, 0, tmp, 0, anns.length);
                    tmp[anns.length] = jta;
                    anns = tmp;
                }
            }
            part.setProperty("parameter.annotations", (Object)anns);
            part.setProperty("honor.jaxb.annotations", (Object)Boolean.TRUE);
        }
        if (beanInfo == null) {
            if (Exception.class.isAssignableFrom(clazz)) {
                QName name = (QName)part.getMessageInfo().getProperty("elementName");
                part.setElementQName(name);
                this.buildExceptionType(part, clazz);
            }
            return;
        }
        boolean isElement = beanInfo.isElement() && !Boolean.TRUE.equals(part.getMessageInfo().getOperation().getProperty("operation.force.types"));
        boolean bl = hasType = !beanInfo.getTypeNames().isEmpty();
        if (isElement && isFromWrapper && hasType) {
            isElement = false;
        }
        part.setElement(isElement);
        if (isElement) {
            QName name = new QName(beanInfo.getElementNamespaceURI(null), beanInfo.getElementLocalName(null));
            XmlSchemaElement el = this.schemas.getElementByQName(name);
            if (el != null && el.getRef().getTarget() != null) {
                part.setTypeQName(el.getRef().getTargetQName());
            } else {
                part.setElementQName(name);
            }
            part.setXmlSchema((XmlSchemaAnnotated)el);
        } else {
            QName typeName = this.getTypeName(beanInfo);
            if (typeName != null) {
                XmlSchemaType type = this.schemas.getTypeByQName(typeName);
                if (isList && type instanceof XmlSchemaSimpleType) {
                    XmlSchemaSimpleType simpleType = new XmlSchemaSimpleType(type.getParent(), false);
                    XmlSchemaSimpleTypeList list = new XmlSchemaSimpleTypeList();
                    XmlSchemaSimpleType stype = (XmlSchemaSimpleType)type;
                    list.setItemTypeName(stype.getQName());
                    simpleType.setContent((XmlSchemaSimpleTypeContent)list);
                    part.setXmlSchema((XmlSchemaAnnotated)simpleType);
                    if (part.getConcreteName() == null) {
                        part.setConcreteName(new QName(null, part.getName().getLocalPart()));
                    }
                } else {
                    part.setTypeQName(typeName);
                    part.setXmlSchema((XmlSchemaAnnotated)type);
                }
            }
        }
    }

    private XmlJavaTypeAdapter findFromTypeAdapter(Class<?> clazz, Annotation[] anns) {
        XmlJavaTypeAdapter xjta;
        JAXBBeanInfo ret = null;
        if (anns != null) {
            for (Annotation a : anns) {
                if (!XmlJavaTypeAdapter.class.isAssignableFrom(a.annotationType()) || (ret = this.findFromTypeAdapter(((XmlJavaTypeAdapter)a).value())) == null) continue;
                return (XmlJavaTypeAdapter)a;
            }
        }
        if ((xjta = clazz.getAnnotation(XmlJavaTypeAdapter.class)) != null && (ret = this.findFromTypeAdapter(xjta.value())) != null) {
            return xjta;
        }
        return null;
    }

    private JAXBBeanInfo findFromTypeAdapter(Class<? extends XmlAdapter> aclass) {
        Type tp;
        Class<? extends XmlAdapter> c2;
        Type sp = c2.getGenericSuperclass();
        for (c2 = aclass; !XmlAdapter.class.equals(c2) && c2 != null; c2 = c2.getSuperclass()) {
            sp = c2.getGenericSuperclass();
        }
        if (sp instanceof ParameterizedType && (tp = ((ParameterizedType)sp).getActualTypeArguments()[0]) instanceof Class) {
            return this.getBeanInfo((Class)tp);
        }
        return null;
    }

    private QName getTypeName(JAXBBeanInfo beanInfo) {
        Iterator itr = beanInfo.getTypeNames().iterator();
        if (!itr.hasNext()) {
            return null;
        }
        return (QName)itr.next();
    }

    public void checkForExistence(MessagePartInfo part) {
        QName qn = part.getElementQName();
        if (qn != null) {
            XmlSchemaElement el = this.schemas.getElementByQName(qn);
            if (el == null) {
                JAXBBeanInfo beanInfo;
                Class<?> clazz = part.getTypeClass();
                if (clazz == null) {
                    return;
                }
                boolean isFromWrapper = part.getMessageInfo().getOperation().isUnwrapped();
                if (isFromWrapper && clazz.isArray() && !Byte.TYPE.equals(clazz.getComponentType())) {
                    clazz = clazz.getComponentType();
                }
                if ((beanInfo = this.getBeanInfo(clazz)) == null) {
                    if (Exception.class.isAssignableFrom(clazz)) {
                        QName name = (QName)part.getMessageInfo().getProperty("elementName");
                        part.setElementQName(name);
                        this.buildExceptionType(part, clazz);
                    }
                    return;
                }
                QName typeName = this.getTypeName(beanInfo);
                this.createBridgeXsElement(part, qn, typeName);
            } else if (part.getXmlSchema() == null) {
                part.setXmlSchema((XmlSchemaAnnotated)el);
            }
        }
    }

    private void createBridgeXsElement(MessagePartInfo part, QName qn, QName typeName) {
        XmlSchemaElement el = null;
        SchemaInfo schemaInfo = this.serviceInfo.getSchema(qn.getNamespaceURI());
        if (schemaInfo != null) {
            el = schemaInfo.getElementByQName(qn);
            if (el == null) {
                el = this.createXsElement(schemaInfo.getSchema(), part, typeName, schemaInfo);
            } else if (!typeName.equals(el.getSchemaTypeName())) {
                throw new Fault(new Message("CANNOT_CREATE_ELEMENT", LOG, new Object[]{qn, typeName, el.getSchemaTypeName()}));
            }
            return;
        }
        XmlSchema schema = this.schemas.newXmlSchemaInCollection(qn.getNamespaceURI());
        if (this.qualifiedSchemas) {
            schema.setElementFormDefault(XmlSchemaForm.QUALIFIED);
        }
        schemaInfo = new SchemaInfo(qn.getNamespaceURI(), this.qualifiedSchemas, false);
        schemaInfo.setSchema(schema);
        el = this.createXsElement(schema, part, typeName, schemaInfo);
        NamespaceMap nsMap = new NamespaceMap();
        nsMap.add("tns", schema.getTargetNamespace());
        nsMap.add("xsd", "http://www.w3.org/2001/XMLSchema");
        schema.setNamespaceContext((NamespacePrefixList)nsMap);
        this.serviceInfo.addSchema(schemaInfo);
    }

    private XmlSchemaElement createXsElement(XmlSchema schema, MessagePartInfo part, QName typeName, SchemaInfo schemaInfo) {
        XmlSchemaElement el = new XmlSchemaElement(schema, true);
        el.setName(part.getElementQName().getLocalPart());
        el.setNillable(true);
        el.setSchemaTypeName(typeName);
        part.setXmlSchema((XmlSchemaAnnotated)el);
        schemaInfo.setElement(null);
        return el;
    }

    public void end(FaultInfo fault) {
        Class cl2;
        MessagePartInfo part = (MessagePartInfo)fault.getMessageParts().get(0);
        Class cls = part.getTypeClass();
        if (cls != (cl2 = (Class)fault.getProperty(Class.class.getName()))) {
            QName name = (QName)fault.getProperty("elementName");
            part.setElementQName(name);
            JAXBBeanInfo beanInfo = this.getBeanInfo(cls);
            if (beanInfo == null) {
                throw new Fault(new Message("NO_BEAN_INFO", LOG, new Object[]{cls.getName()}));
            }
            SchemaInfo schemaInfo = this.serviceInfo.getSchema(part.getElementQName().getNamespaceURI());
            if (schemaInfo != null && !this.isExistSchemaElement(schemaInfo.getSchema(), part.getElementQName())) {
                XmlSchemaElement el = new XmlSchemaElement(schemaInfo.getSchema(), true);
                el.setName(part.getElementQName().getLocalPart());
                el.setNillable(true);
                schemaInfo.setElement(null);
                Iterator itr = beanInfo.getTypeNames().iterator();
                if (!itr.hasNext()) {
                    return;
                }
                QName typeName = (QName)itr.next();
                el.setSchemaTypeName(typeName);
            }
        } else if (part.getXmlSchema() == null) {
            Method[] methods;
            try {
                cls.getConstructor(String.class);
            }
            catch (Exception e) {
                try {
                    cls.getConstructor(new Class[0]);
                }
                catch (Exception e2) {
                    return;
                }
            }
            SchemaInfo schemaInfo = this.serviceInfo.getSchema(part.getElementQName().getNamespaceURI());
            if (schemaInfo == null || this.isExistSchemaElement(schemaInfo.getSchema(), part.getElementQName())) {
                return;
            }
            XmlSchemaElement el = new XmlSchemaElement(schemaInfo.getSchema(), true);
            el.setName(part.getElementQName().getLocalPart());
            schemaInfo.setElement(null);
            part.setXmlSchema((XmlSchemaAnnotated)el);
            XmlSchemaComplexType ct = new XmlSchemaComplexType(schemaInfo.getSchema(), false);
            el.setSchemaType((XmlSchemaType)ct);
            XmlSchemaSequence seq = new XmlSchemaSequence();
            ct.setParticle((XmlSchemaParticle)seq);
            for (Method m : methods = cls.getMethods()) {
                if (!m.getName().startsWith("get") && !m.getName().startsWith("is")) continue;
                int beginIdx = m.getName().startsWith("get") ? 3 : 2;
                try {
                    m.getDeclaringClass().getMethod("set" + m.getName().substring(beginIdx), m.getReturnType());
                    JAXBBeanInfo beanInfo = this.getBeanInfo(m.getReturnType());
                    if (beanInfo != null) {
                        el = new XmlSchemaElement(schemaInfo.getSchema(), false);
                        el.setName(m.getName().substring(beginIdx));
                        Iterator itr = beanInfo.getTypeNames().iterator();
                        if (!itr.hasNext()) {
                            return;
                        }
                        QName typeName = (QName)itr.next();
                        el.setSchemaTypeName(typeName);
                    }
                    seq.getItems().add(el);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private void buildExceptionType(MessagePartInfo part, Class<?> cls) {
        JAXBBeanInfo beanInfo;
        Class<?> type;
        String faultTypeName;
        XmlSchemaType existingType;
        SchemaInfo schemaInfo = null;
        for (SchemaInfo s : this.serviceInfo.getSchemas()) {
            if (!s.getNamespaceURI().equals(part.getElementQName().getNamespaceURI())) continue;
            schemaInfo = s;
            break;
        }
        XmlAccessorOrder xmlAccessorOrder = cls.getAnnotation(XmlAccessorOrder.class);
        XmlType xmlTypeAnno = cls.getAnnotation(XmlType.class);
        Object[] propertyOrder = null;
        boolean respectXmlTypeNS = false;
        XmlSchema faultBeanSchema = null;
        if (xmlTypeAnno != null && !StringUtils.isEmpty((String)xmlTypeAnno.namespace()) && !xmlTypeAnno.namespace().equals(part.getElementQName().getNamespaceURI())) {
            respectXmlTypeNS = true;
            NamespaceMap nsMap = new NamespaceMap();
            nsMap.add("tns", xmlTypeAnno.namespace());
            nsMap.add("xsd", "http://www.w3.org/2001/XMLSchema");
            SchemaInfo faultBeanSchemaInfo = this.createSchemaIfNeeded(xmlTypeAnno.namespace(), nsMap);
            faultBeanSchema = faultBeanSchemaInfo.getSchema();
        }
        if (xmlTypeAnno != null && xmlTypeAnno.propOrder().length > 0) {
            propertyOrder = xmlTypeAnno.propOrder();
        }
        XmlSchema schema = null;
        if (schemaInfo == null) {
            NamespaceMap nsMap = new NamespaceMap();
            nsMap.add("tns", part.getElementQName().getNamespaceURI());
            nsMap.add("xsd", "http://www.w3.org/2001/XMLSchema");
            schemaInfo = this.createSchemaIfNeeded(part.getElementQName().getNamespaceURI(), nsMap);
        }
        if ((existingType = (schema = schemaInfo.getSchema()).getTypeByName(faultTypeName = xmlTypeAnno != null && !StringUtils.isEmpty((String)xmlTypeAnno.name()) ? xmlTypeAnno.name() : part.getElementQName().getLocalPart())) != null) {
            return;
        }
        XmlSchemaElement el = new XmlSchemaElement(schema, true);
        el.setName(part.getElementQName().getLocalPart());
        part.setXmlSchema((XmlSchemaAnnotated)el);
        schemaInfo.setElement(null);
        if (respectXmlTypeNS) {
            schema = faultBeanSchema;
        }
        XmlSchemaComplexType ct = new XmlSchemaComplexType(schema, true);
        ct.setName(faultTypeName);
        el.setSchemaTypeName(ct.getQName());
        XmlSchemaSequence seq = new XmlSchemaSequence();
        ct.setParticle((XmlSchemaParticle)seq);
        String namespace = part.getElementQName().getNamespaceURI();
        XmlAccessType accessType = Utils.getXmlAccessType(cls);
        for (Field f : Utils.getFields(cls, accessType)) {
            type = Utils.getFieldType(f);
            beanInfo = this.getBeanInfo((Type)type);
            if (beanInfo == null) continue;
            this.addElement(schema, seq, beanInfo, new QName(namespace, f.getName()), JAXBSchemaInitializer.isArray(type));
        }
        for (Method m : Utils.getGetters(cls, accessType)) {
            type = Utils.getMethodReturnType(m);
            beanInfo = this.getBeanInfo((Type)type);
            if (beanInfo == null) continue;
            int idx = m.getName().startsWith("get") ? 3 : 2;
            String name = m.getName().substring(idx);
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            this.addElement(schema, seq, beanInfo, new QName(namespace, name), JAXBSchemaInitializer.isArray(type));
        }
        if (cls.equals(Exception.class)) {
            JAXBBeanInfo beanInfo2 = this.getBeanInfo(String.class);
            XmlSchemaElement exEle = new XmlSchemaElement(schema, false);
            exEle.setName("message");
            exEle.setSchemaTypeName(this.getTypeName(beanInfo2));
            exEle.setMinOccurs(0L);
            seq.getItems().add(exEle);
        }
        if (propertyOrder != null && propertyOrder.length == seq.getItems().size()) {
            this.sortItems(seq, (String[])propertyOrder);
        } else if (propertyOrder != null && propertyOrder.length != seq.getItems().size()) {
            LOG.log(Level.WARNING, "propOrder in @XmlType doesn't define all schema elements :" + Arrays.toString(propertyOrder));
        }
        if (xmlAccessorOrder != null && xmlAccessorOrder.value().equals((Object)XmlAccessOrder.ALPHABETICAL) && propertyOrder == null) {
            this.sort(seq);
        }
        this.schemas.addCrossImports();
        part.setProperty(JAXBDataBinding.class.getName() + ".CUSTOM_EXCEPTION", (Object)Boolean.TRUE);
    }

    static boolean isArray(Type cls) {
        if (cls instanceof Class) {
            return ((Class)cls).isArray();
        }
        if (cls instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)cls;
            return pt.getActualTypeArguments().length == 1 && pt.getRawType() instanceof Class && Collection.class.isAssignableFrom((Class)pt.getRawType());
        }
        return cls instanceof GenericArrayType;
    }

    protected void addElement(XmlSchema schema, XmlSchemaSequence seq, JAXBBeanInfo beanInfo, QName name, boolean isArray) {
        XmlSchemaElement el = new XmlSchemaElement(schema, false);
        if (isArray) {
            el.setMinOccurs(0L);
            el.setMaxOccurs(Long.MAX_VALUE);
        } else {
            el.setMinOccurs(1L);
            el.setMaxOccurs(1L);
            el.setNillable(true);
        }
        if (beanInfo.isElement()) {
            QName ename = new QName(beanInfo.getElementNamespaceURI(null), beanInfo.getElementLocalName(null));
            XmlSchemaElement el2 = this.schemas.getElementByQName(ename);
            el.getRef().setTargetQName(el2.getQName());
        } else {
            el.setName(name.getLocalPart());
            Iterator itr = beanInfo.getTypeNames().iterator();
            if (!itr.hasNext()) {
                return;
            }
            QName typeName = (QName)itr.next();
            el.setSchemaTypeName(typeName);
        }
        seq.getItems().add(el);
    }

    private SchemaInfo createSchemaIfNeeded(String namespace, NamespaceMap nsMap) {
        SchemaInfo schemaInfo = this.serviceInfo.getSchema(namespace);
        if (schemaInfo == null) {
            XmlSchema xmlSchema = this.schemas.newXmlSchemaInCollection(namespace);
            if (this.qualifiedSchemas) {
                xmlSchema.setElementFormDefault(XmlSchemaForm.QUALIFIED);
            }
            xmlSchema.setNamespaceContext((NamespacePrefixList)nsMap);
            schemaInfo = new SchemaInfo(namespace);
            schemaInfo.setSchema(xmlSchema);
            this.serviceInfo.addSchema(schemaInfo);
        }
        return schemaInfo;
    }

    private boolean isExistSchemaElement(XmlSchema schema, QName qn) {
        return schema.getElementByName(qn) != null;
    }

    private void sortItems(XmlSchemaSequence seq, String[] propertyOrder) {
        final List<String> propList = Arrays.asList(propertyOrder);
        Collections.sort(seq.getItems(), new Comparator<XmlSchemaSequenceMember>(){

            @Override
            public int compare(XmlSchemaSequenceMember o1, XmlSchemaSequenceMember o2) {
                XmlSchemaElement element1 = (XmlSchemaElement)o1;
                XmlSchemaElement element2 = (XmlSchemaElement)o2;
                int index1 = propList.indexOf(element1.getName());
                int index2 = propList.indexOf(element2.getName());
                return index1 - index2;
            }
        });
    }

    private void sort(XmlSchemaSequence seq) {
        Collections.sort(seq.getItems(), new Comparator<XmlSchemaSequenceMember>(){

            @Override
            public int compare(XmlSchemaSequenceMember o1, XmlSchemaSequenceMember o2) {
                XmlSchemaElement element1 = (XmlSchemaElement)o1;
                XmlSchemaElement element2 = (XmlSchemaElement)o2;
                return element1.getName().compareTo(element2.getName());
            }
        });
    }
}

