/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.session;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.session.SessionDestroyedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSessionDestroyedEvent
extends SessionDestroyedEvent {
    public HttpSessionDestroyedEvent(HttpSession session) {
        super((Object)session);
    }

    public HttpSession getSession() {
        return (HttpSession)this.getSource();
    }

    public List<SecurityContext> getSecurityContexts() {
        HttpSession session = (HttpSession)this.getSource();
        Enumeration attributes = session.getAttributeNames();
        ArrayList<SecurityContext> contexts = new ArrayList<SecurityContext>();
        while (attributes.hasMoreElements()) {
            Object attribute = attributes.nextElement();
            if (!(attribute instanceof SecurityContext)) continue;
            contexts.add((SecurityContext)attribute);
        }
        return contexts;
    }

    public String getId() {
        return this.getSession().getId();
    }
}

