/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.drools.RuntimeDroolsException;
import org.drools.base.AccessorKey;
import org.drools.base.ClassFieldAccessor;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassFieldWriter;
import org.drools.base.ClassObjectType;
import org.drools.spi.Acceptor;
import org.drools.spi.AcceptsClassObjectType;
import org.drools.spi.AcceptsReadAccessor;
import org.drools.spi.AcceptsWriteAccessor;

public class ClassFieldAccessorStore
implements Externalizable {
    private Map<AccessorKey, BaseLookupEntry> lookup = new HashMap<AccessorKey, BaseLookupEntry>();
    private ClassFieldAccessorCache cache;
    private boolean eagerWire = true;

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.lookup);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.lookup = (Map)in.readObject();
    }

    public void setEagerWire(boolean eagerWire) {
        this.eagerWire = eagerWire;
    }

    public void setClassFieldAccessorCache(ClassFieldAccessorCache cache) {
        this.cache = cache;
    }

    public ClassFieldWriter getWriter(Class cls, String fieldName, ClassLoader classLoader) {
        return this.getWriter(cls.getName(), fieldName, null);
    }

    public ClassFieldReader getReader(Class cls, String fieldName, ClassLoader classLoader) {
        return this.getReader(cls.getName(), fieldName, null, AccessorKey.AccessorType.FieldAccessor);
    }

    public ClassFieldReader getReader(String className, String fieldName, AcceptsReadAccessor target) {
        return this.getReader(className, fieldName, target, AccessorKey.AccessorType.FieldAccessor);
    }

    public synchronized ClassFieldReader getReader(String className, String fieldName, AcceptsReadAccessor target, AccessorKey.AccessorType accessorType) {
        AccessorKey key = new AccessorKey(className, fieldName, accessorType);
        FieldLookupEntry entry = (FieldLookupEntry)this.lookup.get(key);
        boolean exists = true;
        if (entry == null) {
            exists = false;
            entry = new FieldLookupEntry(new ClassFieldReader(className, fieldName));
        }
        if (this.eagerWire) {
            this.wire(entry.getClassFieldReader());
        }
        if (target != null) {
            target.setReadAccessor(entry.getClassFieldReader());
            entry.addAccessorTarget(target);
        }
        if (!exists) {
            this.lookup.put(key, entry);
        }
        return entry.getClassFieldReader();
    }

    public synchronized ClassFieldWriter getWriter(String className, String fieldName, AcceptsWriteAccessor target) {
        AccessorKey key = new AccessorKey(className, fieldName, AccessorKey.AccessorType.FieldAccessor);
        FieldLookupEntry entry = (FieldLookupEntry)this.lookup.get(key);
        boolean exists = true;
        if (entry == null) {
            exists = false;
            entry = new FieldLookupEntry(new ClassFieldWriter(className, fieldName));
        }
        if (this.eagerWire) {
            this.wire(entry.getClassFieldReader());
        }
        if (target != null) {
            target.setWriteAccessor(entry.getClassFieldWriter());
            entry.addAccessorTarget(target);
        }
        if (!exists) {
            this.lookup.put(key, entry);
        }
        return entry.getClassFieldWriter();
    }

    public ClassFieldAccessor getAccessor(Class cls, String fieldName, ClassLoader classLoader) {
        return this.getAccessor(cls.getName(), fieldName);
    }

    public ClassFieldAccessor getAccessor(String className, String fieldName) {
        AccessorKey key = new AccessorKey(className, fieldName, AccessorKey.AccessorType.FieldAccessor);
        FieldLookupEntry entry = (FieldLookupEntry)this.lookup.get(key);
        if (entry == null) {
            entry = new FieldLookupEntry(new ClassFieldReader(className, fieldName), new ClassFieldWriter(className, fieldName));
            this.lookup.put(key, entry);
        }
        ClassFieldAccessor accessor = new ClassFieldAccessor(entry.getClassFieldReader(), entry.getClassFieldWriter());
        entry.addAccessorTarget(accessor);
        if (this.eagerWire) {
            this.wire(entry.getClassFieldReader());
            this.wire(entry.getClassFieldWriter());
        }
        return accessor;
    }

    public ClassObjectType getClassObjectType(ClassObjectType objectType, AcceptsClassObjectType target) {
        return this.getClassObjectType(objectType, false, target);
    }

    public ClassObjectType getClassObjectType(ClassObjectType objectType, boolean isEvent, AcceptsClassObjectType target) {
        AccessorKey key = new AccessorKey(objectType.getClassName(), isEvent ? "$$DROOLS__isEvent__" : null, AccessorKey.AccessorType.ClassObjectType);
        ClassObjectTypeLookupEntry entry = (ClassObjectTypeLookupEntry)this.lookup.get(key);
        if (entry == null) {
            entry = new ClassObjectTypeLookupEntry(this.cache.getClassObjectType(objectType));
            this.lookup.put(key, entry);
        }
        if (target != null) {
            entry.addAccessorTarget(target);
            target.setClassObjectType(entry.getClassObjectType());
        }
        return entry.getClassObjectType();
    }

    public void merge(ClassFieldAccessorStore other) {
        block4: for (Map.Entry<AccessorKey, BaseLookupEntry> entry : other.lookup.entrySet()) {
            switch (entry.getValue().getAccessorType()) {
                case FieldAccessor: {
                    BaseLookupEntry lookupEntry = (FieldLookupEntry)this.lookup.get(entry.getKey());
                    if (lookupEntry == null) {
                        lookupEntry = (FieldLookupEntry)entry.getValue();
                        this.lookup.put(entry.getKey(), lookupEntry);
                        if (((FieldLookupEntry)lookupEntry).getClassFieldReader() != null) {
                            this.wire(((FieldLookupEntry)lookupEntry).getClassFieldReader());
                        }
                        if (((FieldLookupEntry)lookupEntry).getClassFieldWriter() == null) break;
                        this.wire(((FieldLookupEntry)lookupEntry).getClassFieldWriter());
                        break;
                    }
                    for (Acceptor target : entry.getValue().getAccessorTargets()) {
                        if (target instanceof AcceptsReadAccessor) {
                            ((AcceptsReadAccessor)target).setReadAccessor(((FieldLookupEntry)lookupEntry).getClassFieldReader());
                        } else if (target instanceof AcceptsWriteAccessor) {
                            ((AcceptsWriteAccessor)target).setWriteAccessor(((FieldLookupEntry)lookupEntry).getClassFieldWriter());
                        }
                        lookupEntry.addAccessorTarget(target);
                    }
                    continue block4;
                }
                case ClassObjectType: {
                    BaseLookupEntry lookupEntry = (ClassObjectTypeLookupEntry)this.lookup.get(entry.getKey());
                    if (lookupEntry == null) {
                        lookupEntry = new ClassObjectTypeLookupEntry(this.cache.getClassObjectType(((ClassObjectTypeLookupEntry)entry.getValue()).getClassObjectType()));
                        this.lookup.put(entry.getKey(), lookupEntry);
                    }
                    for (Acceptor target : entry.getValue().getAccessorTargets()) {
                        ((AcceptsClassObjectType)target).setClassObjectType(((ClassObjectTypeLookupEntry)lookupEntry).getClassObjectType());
                        lookupEntry.addAccessorTarget(target);
                    }
                    break;
                }
            }
        }
    }

    public void wire() {
        for (Map.Entry<AccessorKey, BaseLookupEntry> entry : this.lookup.entrySet()) {
            switch (entry.getValue().getAccessorType()) {
                case FieldAccessor: {
                    ClassFieldWriter writer;
                    ClassFieldReader reader = ((FieldLookupEntry)entry.getValue()).getClassFieldReader();
                    if (reader != null) {
                        this.wire(reader);
                    }
                    if ((writer = ((FieldLookupEntry)entry.getValue()).getClassFieldWriter()) == null) break;
                    this.wire(writer);
                    break;
                }
                case ClassObjectType: {
                    ClassObjectType classObjectType = ((ClassObjectTypeLookupEntry)entry.getValue()).getClassObjectType();
                    this.wire(classObjectType);
                    break;
                }
            }
        }
    }

    public void wire(ClassFieldReader reader) {
        reader.setReadAccessor(this.cache.getReadAcessor(reader));
    }

    public void wire(ClassFieldWriter writer) {
        writer.setWriteAccessor(this.cache.getWriteAcessor(writer));
    }

    public void wire(ClassObjectType objectType) {
        try {
            Class<?> cls = this.cache.getClassLoader().loadClass(objectType.getClassName());
            objectType.setClassType(cls);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException("Unable to load ClassObjectType class '" + objectType.getClassName() + "'");
        }
    }

    public static class FieldLookupEntry
    extends BaseLookupEntry {
        private ClassFieldReader reader;
        private ClassFieldWriter writer;

        public FieldLookupEntry() {
        }

        public FieldLookupEntry(ClassFieldReader reader) {
            this.reader = reader;
        }

        public FieldLookupEntry(ClassFieldWriter writer) {
            this.writer = writer;
        }

        public FieldLookupEntry(ClassFieldReader reader, ClassFieldWriter writer) {
            this.writer = writer;
            this.reader = reader;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.reader);
            out.writeObject(this.writer);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.reader = (ClassFieldReader)in.readObject();
            this.writer = (ClassFieldWriter)in.readObject();
        }

        public ClassFieldReader getClassFieldReader() {
            return this.reader;
        }

        public ClassFieldWriter getClassFieldWriter() {
            return this.writer;
        }

        public AccessorKey.AccessorType getAccessorType() {
            return AccessorKey.AccessorType.FieldAccessor;
        }
    }

    public static class ClassObjectTypeLookupEntry
    extends BaseLookupEntry {
        ClassObjectType classObjectType;

        public ClassObjectTypeLookupEntry() {
        }

        public ClassObjectTypeLookupEntry(ClassObjectType classObjectType) {
            this.classObjectType = classObjectType;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.classObjectType);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.classObjectType = (ClassObjectType)in.readObject();
        }

        public ClassObjectType getClassObjectType() {
            return this.classObjectType;
        }

        public void setClassObjectType(ClassObjectType classObjectType) {
            this.classObjectType = classObjectType;
        }

        public AccessorKey.AccessorType getAccessorType() {
            return AccessorKey.AccessorType.ClassObjectType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BaseLookupEntry
    implements Externalizable {
        private Map<Acceptor, Object> accessorTargets = Collections.emptyMap();

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.accessorTargets);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.accessorTargets = (Map)in.readObject();
        }

        public Set<Acceptor> getAccessorTargets() {
            return this.accessorTargets.keySet();
        }

        public void addAccessorTarget(Acceptor target) {
            if (this.accessorTargets == Collections.EMPTY_MAP) {
                this.accessorTargets = new IdentityHashMap<Acceptor, Object>();
            }
            this.accessorTargets.put(target, null);
        }

        public void addAccessorTargets(Set<Acceptor> targets) {
            if (this.accessorTargets == Collections.EMPTY_MAP) {
                this.accessorTargets = new IdentityHashMap<Acceptor, Object>();
            }
            for (Acceptor target : targets) {
                this.accessorTargets.put(target, null);
            }
        }

        public void removeTarget(Acceptor target) {
            this.accessorTargets.remove(target);
        }

        public abstract AccessorKey.AccessorType getAccessorType();
    }
}

