/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.command;

import org.drools.process.command.Command;
import org.drools.process.instance.ProcessInstance;
import org.drools.reteoo.ReteooWorkingMemory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalEventCommand
implements Command<Object> {
    private long processInstanceId = -1L;
    private String eventType;
    private Object event;

    public SignalEventCommand() {
    }

    public SignalEventCommand(String eventType, Object event) {
        this.eventType = eventType;
        this.event = event;
    }

    public SignalEventCommand(long processInstanceId, String eventType, Object event) {
        this.processInstanceId = processInstanceId;
        this.eventType = eventType;
        this.event = event;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public Object getEvent() {
        return this.event;
    }

    public void setEvent(Object event) {
        this.event = event;
    }

    @Override
    public Object execute(ReteooWorkingMemory session) {
        if (this.processInstanceId == -1L) {
            session.getSignalManager().signalEvent(this.eventType, this.event);
        } else {
            ProcessInstance processInstance = session.getProcessInstance(this.processInstanceId);
            if (processInstance != null) {
                processInstance.signalEvent(this.eventType, this.event);
            }
        }
        return null;
    }

    public String toString() {
        if (this.processInstanceId == -1L) {
            return "session.getSignalManager().signalEvent(" + this.eventType + ", " + this.event + ");";
        }
        return "processInstance.signalEvent(" + this.eventType + ", " + this.event + ");";
    }
}

