/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import org.drools.RuleBaseConfiguration;
import org.drools.RuntimeDroolsException;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Accumulate;
import org.drools.rule.Behavior;
import org.drools.rule.ContextEntry;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.PropagationContext;
import org.drools.util.ArrayUtils;
import org.drools.util.Entry;
import org.drools.util.Iterator;
import org.drools.util.ObjectHashMap;

public class AccumulateNode
extends BetaNode {
    private static final long serialVersionUID = 400L;
    private boolean unwrapRightObject;
    private Accumulate accumulate;
    private AlphaNodeFieldConstraint[] resultConstraints;
    private BetaConstraints resultBinder;

    public AccumulateNode() {
    }

    public AccumulateNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, AlphaNodeFieldConstraint[] resultConstraints, BetaConstraints sourceBinder, BetaConstraints resultBinder, Behavior[] behaviors, Accumulate accumulate, boolean unwrapRightObject, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), leftInput, rightInput, sourceBinder, behaviors);
        this.resultBinder = resultBinder;
        this.resultConstraints = resultConstraints;
        this.accumulate = accumulate;
        this.unwrapRightObject = unwrapRightObject;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.unwrapRightObject = in.readBoolean();
        this.accumulate = (Accumulate)in.readObject();
        this.resultConstraints = (AlphaNodeFieldConstraint[])in.readObject();
        this.resultBinder = (BetaConstraints)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.unwrapRightObject);
        out.writeObject(this.accumulate);
        out.writeObject(this.resultConstraints);
        out.writeObject(this.resultBinder);
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        InternalFactHandle handle;
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        AccumulateContext accresult = new AccumulateContext();
        if (this.tupleMemoryEnabled) {
            memory.betaMemory.getLeftTupleMemory().add(leftTuple);
            memory.betaMemory.getCreatedHandles().put(leftTuple, accresult, false);
        }
        accresult.context = this.accumulate.createContext();
        this.accumulate.init(memory.workingMemoryContext, accresult.context, leftTuple, workingMemory);
        this.constraints.updateFromTuple(memory.betaMemory.getContext(), workingMemory, leftTuple);
        for (RightTuple rightTuple = memory.betaMemory.getRightTupleMemory().getFirst(leftTuple); rightTuple != null; rightTuple = (RightTuple)rightTuple.getNext()) {
            handle = rightTuple.getFactHandle();
            if (!this.constraints.isAllowedCachedLeft(memory.betaMemory.getContext(), handle)) continue;
            LeftTuple tuple = leftTuple;
            if (this.unwrapRightObject) {
                tuple = (LeftTuple)handle.getObject();
                handle = tuple.getLastHandle();
            }
            this.accumulate.accumulate(memory.workingMemoryContext, accresult.context, tuple, handle, workingMemory);
            if (!this.tupleMemoryEnabled) continue;
            new LeftTuple(leftTuple, rightTuple, this, this.tupleMemoryEnabled);
        }
        this.constraints.resetTuple(memory.betaMemory.getContext());
        Object result = this.accumulate.getResult(memory.workingMemoryContext, accresult.context, leftTuple, workingMemory);
        if (result == null) {
            throw new RuntimeDroolsException("Accumulate must not return a null value.");
        }
        handle = workingMemory.getFactHandleFactory().newFactHandle(result, workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(context.getEntryPoint(), result), workingMemory);
        accresult.result = new RightTuple(handle, this);
        this.evaluateResultConstraints(leftTuple, context, workingMemory, memory, accresult);
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        memory.betaMemory.getLeftTupleMemory().remove(leftTuple);
        AccumulateContext accctx = (AccumulateContext)memory.betaMemory.getCreatedHandles().remove(leftTuple);
        LeftTuple child = this.getFirstMatch(leftTuple, accctx);
        while (child != null) {
            LeftTuple tmp = child.getLeftParentNext();
            child.unlinkFromLeftParent();
            child.unlinkFromRightParent();
            child = tmp;
        }
        if (accctx.propagated) {
            this.sink.propagateRetractLeftTupleDestroyRightTuple(leftTuple, context, workingMemory);
        } else {
            workingMemory.getFactHandleFactory().destroyFactHandle(accctx.result.getFactHandle());
        }
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        RightTuple rightTuple = new RightTuple(factHandle, this);
        if (!this.behavior.assertRightTuple(memory.betaMemory.getBehaviorContext(), rightTuple, workingMemory)) {
            rightTuple.unlinkFromRightParent();
            return;
        }
        memory.betaMemory.getRightTupleMemory().add(rightTuple);
        if (!this.tupleMemoryEnabled) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.betaMemory.getContext(), workingMemory, factHandle);
        Entry[] tuples = memory.betaMemory.getLeftTupleMemory().toArray();
        for (int i = 0; i < tuples.length; ++i) {
            LeftTuple tuple = (LeftTuple)tuples[i];
            if (!this.constraints.isAllowedCachedRight(memory.betaMemory.getContext(), tuple)) continue;
            if (this.accumulate.supportsReverse() || context.getType() == 0) {
                this.modifyTuple(true, tuple, rightTuple, context, workingMemory, memory);
                continue;
            }
            this.retractLeftTuple(tuple, context, workingMemory);
            this.assertLeftTuple(tuple, context, workingMemory);
        }
        this.constraints.resetFactHandle(memory.betaMemory.getContext());
    }

    public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        InternalFactHandle origin = (InternalFactHandle)context.getFactHandleOrigin();
        if (context.getType() == 5) {
            ((PropagationContextImpl)context).setFactHandle(null);
        }
        this.behavior.retractRightTuple(memory.betaMemory.getBehaviorContext(), rightTuple, workingMemory);
        memory.betaMemory.getRightTupleMemory().remove(rightTuple);
        LeftTuple childTuple = rightTuple.getBetaChildren();
        while (childTuple != null) {
            LeftTuple tmp = childTuple.getRightParentNext();
            if (this.accumulate.supportsReverse()) {
                this.modifyTuple(false, childTuple.getParent(), rightTuple, context, workingMemory, memory);
            } else {
                LeftTuple match = childTuple.getParent();
                childTuple.unlinkFromLeftParent();
                childTuple.unlinkFromRightParent();
                this.retractLeftTuple(match, context, workingMemory);
                this.assertLeftTuple(match, context, workingMemory);
            }
            childTuple = tmp;
        }
        if (context.getType() == 5) {
            ((PropagationContextImpl)context).setFactHandle(origin);
        }
    }

    private void removeMatchingChild(LeftTuple leftTuple, RightTuple rightTuple) {
        if (leftTuple.getBetaChildren() != null) {
            LeftTuple match = leftTuple.getBetaChildren();
            while (match.getRightParent() != rightTuple) {
                match = match.getLeftParentNext();
            }
            match.unlinkFromLeftParent();
            match.unlinkFromRightParent();
        }
    }

    public void modifyTuple(boolean isAssert, LeftTuple leftTuple, RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory, AccumulateMemory memory) {
        AccumulateContext accctx = (AccumulateContext)memory.betaMemory.getCreatedHandles().get(leftTuple);
        if (accctx.propagated) {
            LeftTuple firstMatch = this.getFirstMatch(leftTuple, accctx);
            if (firstMatch != null) {
                firstMatch.getLeftParentPrevious().setLeftParentNext(null);
                firstMatch.setLeftParentPrevious(null);
            }
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            leftTuple.setBetaChildren(firstMatch);
            accctx.propagated = false;
        }
        if (isAssert) {
            new LeftTuple(leftTuple, rightTuple, this, this.tupleMemoryEnabled);
        } else {
            this.removeMatchingChild(leftTuple, rightTuple);
        }
        InternalFactHandle handle = rightTuple.getFactHandle();
        LeftTuple tuple = leftTuple;
        if (this.unwrapRightObject) {
            tuple = (LeftTuple)handle.getObject();
            handle = tuple.getLastHandle();
        }
        if (context.getType() == 0) {
            this.accumulate.accumulate(memory.workingMemoryContext, accctx.context, tuple, handle, workingMemory);
        } else if (context.getType() == 2 || context.getType() == 3 || context.getType() == 4) {
            if (isAssert) {
                this.accumulate.accumulate(memory.workingMemoryContext, accctx.context, tuple, handle, workingMemory);
            } else {
                this.accumulate.reverse(memory.workingMemoryContext, accctx.context, tuple, handle, workingMemory);
            }
        } else {
            this.accumulate.reverse(memory.workingMemoryContext, accctx.context, tuple, handle, workingMemory);
        }
        Object result = this.accumulate.getResult(memory.workingMemoryContext, accctx.context, leftTuple, workingMemory);
        if (result == null) {
            throw new RuntimeDroolsException("Accumulate must not return a null value.");
        }
        accctx.result.getFactHandle().setObject(result);
        workingMemory.getFactHandleFactory().increaseFactHandleRecency(accctx.result.getFactHandle());
        this.evaluateResultConstraints(leftTuple, context, workingMemory, memory, accctx);
    }

    private void evaluateResultConstraints(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, AccumulateMemory memory, AccumulateContext accctx) {
        boolean isAllowed = true;
        int length = this.resultConstraints.length;
        for (int i = 0; i < length; ++i) {
            if (this.resultConstraints[i].isAllowed(accctx.result.getFactHandle(), workingMemory, memory.alphaContexts[i])) continue;
            isAllowed = false;
            break;
        }
        if (isAllowed) {
            this.resultBinder.updateFromTuple(memory.resultsContext, workingMemory, leftTuple);
            if (this.resultBinder.isAllowedCachedLeft(memory.resultsContext, accctx.result.getFactHandle())) {
                accctx.propagated = true;
                this.sink.propagateAssertLeftTuple(leftTuple, accctx.result, context, workingMemory, this.tupleMemoryEnabled);
            }
            this.resultBinder.resetTuple(memory.resultsContext);
        }
    }

    private LeftTuple getFirstMatch(LeftTuple leftTuple, AccumulateContext colctx) {
        LeftTuple child = leftTuple.getBetaChildren();
        if (colctx.propagated) {
            for (int i = 0; i < this.sink.size(); ++i) {
                child = child.getLeftParentNext();
            }
        }
        return child;
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        Iterator tupleIter = memory.betaMemory.getLeftTupleMemory().iterator();
        LeftTuple leftTuple = (LeftTuple)tupleIter.next();
        while (leftTuple != null) {
            AccumulateContext accctx = (AccumulateContext)memory.betaMemory.getCreatedHandles().get(leftTuple);
            if (accctx.propagated) {
                sink.assertLeftTuple(new LeftTuple(leftTuple, accctx.result, sink, this.tupleMemoryEnabled), context, workingMemory);
            }
            leftTuple = (LeftTuple)tupleIter.next();
        }
    }

    protected void doRemove(InternalWorkingMemory workingMemory, AccumulateMemory memory) {
        Iterator it = memory.betaMemory.getCreatedHandles().iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            AccumulateContext ctx = (AccumulateContext)entry.getValue();
            workingMemory.getFactHandleFactory().destroyFactHandle(ctx.result.getFactHandle());
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
    }

    public int hashCode() {
        return this.leftInput.hashCode() ^ this.rightInput.hashCode() ^ this.accumulate.hashCode() ^ this.resultBinder.hashCode() ^ ArrayUtils.hashCode(this.resultConstraints);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof AccumulateNode)) {
            return false;
        }
        AccumulateNode other = (AccumulateNode)object;
        if (!(this.getClass() == other.getClass() && this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.constraints.equals(other.constraints))) {
            return false;
        }
        return this.accumulate.equals(other.accumulate) && this.resultBinder.equals(other.resultBinder) && Arrays.equals(this.resultConstraints, other.resultConstraints);
    }

    public String toString() {
        return "[ " + this.getClass().getName() + "(" + this.id + ") ]";
    }

    public Object createMemory(RuleBaseConfiguration config) {
        AccumulateMemory memory = new AccumulateMemory();
        memory.betaMemory = this.constraints.createBetaMemory(config);
        memory.workingMemoryContext = this.accumulate.createWorkingMemoryContext();
        memory.resultsContext = this.resultBinder.createContext();
        memory.alphaContexts = new ContextEntry[this.resultConstraints.length];
        for (int i = 0; i < this.resultConstraints.length; ++i) {
            memory.alphaContexts[i] = this.resultConstraints[i].createContextEntry();
        }
        memory.betaMemory.setBehaviorContext(this.behavior.createBehaviorContext());
        return memory;
    }

    public short getType() {
        return 6;
    }

    public static class AccumulateContext
    implements Externalizable {
        public Serializable context;
        public RightTuple result;
        public boolean propagated;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.context = (Serializable)in.readObject();
            this.result = (RightTuple)in.readObject();
            this.propagated = in.readBoolean();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.context);
            out.writeObject(this.result);
            out.writeBoolean(this.propagated);
        }
    }

    public static class AccumulateMemory
    implements Externalizable {
        private static final long serialVersionUID = 400L;
        public Object workingMemoryContext;
        public BetaMemory betaMemory;
        public ContextEntry[] resultsContext;
        public ContextEntry[] alphaContexts;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.workingMemoryContext = in.readObject();
            this.betaMemory = (BetaMemory)in.readObject();
            this.resultsContext = (ContextEntry[])in.readObject();
            this.alphaContexts = (ContextEntry[])in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.workingMemoryContext);
            out.writeObject(this.betaMemory);
            out.writeObject(this.resultsContext);
            out.writeObject(this.alphaContexts);
        }
    }
}

