/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.instance.node;

import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalWorkingMemory;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaGroupPoppedEvent;
import org.drools.event.AgendaGroupPushedEvent;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.process.instance.ProcessInstance;
import org.drools.rule.Declaration;
import org.drools.runtime.process.NodeInstance;
import org.drools.spi.Activation;
import org.drools.workflow.core.node.MilestoneNode;
import org.drools.workflow.instance.WorkflowProcessInstance;
import org.drools.workflow.instance.node.EventBasedNodeInstance;

public class MilestoneNodeInstance
extends EventBasedNodeInstance
implements AgendaEventListener {
    private static final long serialVersionUID = 400L;

    protected MilestoneNode getMilestoneNode() {
        return (MilestoneNode)this.getNode();
    }

    public void internalTrigger(NodeInstance from, String type) {
        super.internalTrigger(from, type);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A MilestoneNode only accepts default incoming connections!");
        }
        String rule = "RuleFlow-Milestone-" + this.getProcessInstance().getProcessId() + "-" + this.getNode().getId();
        boolean isActive = ((InternalAgenda)this.getProcessInstance().getAgenda()).isRuleActiveInRuleFlowGroup("DROOLS_SYSTEM", rule, this.getProcessInstance().getId());
        if (isActive) {
            this.triggerCompleted();
        } else {
            this.addActivationListener();
        }
    }

    private boolean checkProcessInstance(Activation activation) {
        Map declarations = activation.getSubRule().getOuterDeclarations();
        for (Declaration declaration : declarations.values()) {
            Object value;
            if (!"processInstance".equals(declaration.getIdentifier()) || !((value = declaration.getValue((InternalWorkingMemory)this.getProcessInstance().getWorkingMemory(), activation.getTuple().get(declaration).getObject())) instanceof ProcessInstance)) continue;
            return ((ProcessInstance)value).getId() == this.getProcessInstance().getId();
        }
        return true;
    }

    public void addEventListeners() {
        super.addEventListeners();
        this.addActivationListener();
    }

    private void addActivationListener() {
        this.getProcessInstance().getWorkingMemory().addEventListener(this);
    }

    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().getWorkingMemory().removeEventListener(this);
    }

    public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
        String ruleFlowGroup = event.getActivation().getRule().getRuleFlowGroup();
        if ("DROOLS_SYSTEM".equals(ruleFlowGroup)) {
            String ruleName = event.getActivation().getRule().getName();
            String milestoneName = "RuleFlow-Milestone-" + this.getProcessInstance().getProcessId() + "-" + this.getNodeId();
            if (milestoneName.equals(ruleName) && this.checkProcessInstance(event.getActivation())) {
                WorkflowProcessInstance workflowProcessInstance = this.getProcessInstance();
                synchronized (workflowProcessInstance) {
                    this.removeEventListeners();
                    this.triggerCompleted();
                }
            }
        }
    }

    public void afterActivationFired(AfterActivationFiredEvent event, WorkingMemory workingMemory) {
    }

    public void agendaGroupPopped(AgendaGroupPoppedEvent event, WorkingMemory workingMemory) {
    }

    public void agendaGroupPushed(AgendaGroupPushedEvent event, WorkingMemory workingMemory) {
    }

    public void beforeActivationFired(BeforeActivationFiredEvent event, WorkingMemory workingMemory) {
    }
}

