/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.mule.api.MuleContext;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.exception.RollbackSourceCallback;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.context.notification.ExceptionNotification;
import org.mule.context.notification.NotificationException;

public class SystemExceptionListener {
    private CountDownLatch exceptionThrownLatch = new CountDownLatch(1);
    private int timeout = 10000;
    private List<ExceptionNotification> exceptionNotifications = new ArrayList<ExceptionNotification>();

    public SystemExceptionListener(MuleContext muleContext) {
        try {
            final SystemExceptionHandler exceptionListener = muleContext.getExceptionListener();
            muleContext.setExceptionListener(new SystemExceptionHandler(){

                public void handleException(Exception exception, RollbackSourceCallback rollbackMethod) {
                    SystemExceptionListener.this.exceptionThrownLatch.countDown();
                    exceptionListener.handleException(exception, rollbackMethod);
                }

                public void handleException(Exception exception) {
                    SystemExceptionListener.this.exceptionThrownLatch.countDown();
                    exceptionListener.handleException(exception);
                }
            });
            muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

                public void onNotification(ExceptionNotification notification) {
                    SystemExceptionListener.this.exceptionNotifications.add(notification);
                }
            });
        }
        catch (NotificationException e) {
            throw new RuntimeException(e);
        }
    }

    public SystemExceptionListener waitUntilAllNotificationsAreReceived() {
        try {
            if (!this.exceptionThrownLatch.await(this.timeout, TimeUnit.MILLISECONDS)) {
                Assert.fail((String)"An exception was never thrown");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public SystemExceptionListener setNumberOfExecutionsRequired(int numberOfExecutionsRequired) {
        this.exceptionThrownLatch = new CountDownLatch(numberOfExecutionsRequired);
        return this;
    }

    public SystemExceptionListener setTimeoutInMillis(int timeout) {
        this.timeout = timeout;
        return this;
    }
}

