/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.io.Serializable;
import java.util.List;
import javax.jms.Destination;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XAQueueSession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.jms.XATopicSession;
import javax.naming.InitialContext;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.model.OpenExecution;
import org.jbpm.internal.log.Log;
import org.jbpm.jpdl.internal.activity.JpdlAutomaticActivity;
import org.jbpm.pvm.internal.el.Expression;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ScopeInstanceImpl;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.descriptor.MapDescriptor;

public class JmsActivity
extends JpdlAutomaticActivity {
    private static final Log log = Log.getLog((String)JmsActivity.class.getName());
    private static final long serialVersionUID = 1L;
    protected String type = null;
    protected Expression textExpression = null;
    protected Expression objectExpression = null;
    protected MapDescriptor mapDescriptor = null;
    protected String connectionFactoryName = null;
    protected String destinationName = null;
    protected boolean transacted = true;
    protected int acknowledgeMode = 1;

    public void perform(OpenExecution execution) {
        block8: {
            try {
                InitialContext initialContext = new InitialContext();
                Destination destination = (Destination)initialContext.lookup(this.destinationName);
                Object connectionFactory = initialContext.lookup(this.connectionFactoryName);
                if (connectionFactory instanceof XAConnectionFactory) {
                    log.debug("connection factory '" + this.connectionFactoryName + "' is a XAConnectionFactory: using xa jms apis");
                    if (destination instanceof Queue) {
                        log.debug("destination '" + this.destinationName + "' is a Queue: using xa queue jms apis");
                        XAQueueConnectionFactory xaQueueConnectionFactory = (XAQueueConnectionFactory)connectionFactory;
                        this.sendToQueueXA((Queue)destination, xaQueueConnectionFactory, (ExecutionImpl)execution);
                        break block8;
                    }
                    if (destination instanceof Topic) {
                        log.debug("destination '" + this.destinationName + "' is a Topic: using xa topic jms apis");
                        XATopicConnectionFactory xaTopicConnectionFactory = (XATopicConnectionFactory)connectionFactory;
                        this.sendToTopicXA((Topic)destination, xaTopicConnectionFactory, (ExecutionImpl)execution);
                        break block8;
                    }
                    throw new JbpmException("invalid destination type for '" + this.destinationName + "': " + destination.getClass().getName());
                }
                log.debug("connection factory '" + this.connectionFactoryName + "' is a ConnectionFactory: using non-xa jms apis");
                if (destination instanceof Queue) {
                    log.debug("destination '" + this.destinationName + "' is a Queue: using non-xa queue jms apis");
                    QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)connectionFactory;
                    this.sendToQueue((Queue)destination, queueConnectionFactory, (ExecutionImpl)execution);
                    break block8;
                }
                if (destination instanceof Topic) {
                    log.debug("destination '" + this.destinationName + "' is a Topic: using non-xa topic jms apis");
                    TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)connectionFactory;
                    this.sendToTopic((Topic)destination, topicConnectionFactory, (ExecutionImpl)execution);
                    break block8;
                }
                throw new JbpmException("invalid destination type for '" + this.destinationName + "': " + destination.getClass().getName());
            }
            catch (RuntimeException e) {
                log.error("couldn't send jms message: " + e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error("couldn't send jms message: " + e.getMessage(), (Throwable)e);
                throw new JbpmException("couldn't send jms message to queue" + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToQueueXA(Queue queue, XAQueueConnectionFactory xaQueueConnectionFactory, ExecutionImpl execution) throws Exception {
        XAQueueConnection xaQueueConnection = null;
        XAQueueSession xaQueueSession = null;
        MessageProducer messageProducer = null;
        try {
            xaQueueConnection = xaQueueConnectionFactory.createXAQueueConnection();
            xaQueueSession = xaQueueConnection.createXAQueueSession();
            messageProducer = xaQueueSession.createProducer((Destination)queue);
            Message message = this.createMessage((Session)xaQueueSession, execution);
            messageProducer.send(message);
        }
        finally {
            try {
                messageProducer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                xaQueueSession.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                xaQueueConnection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToTopicXA(Topic topic, XATopicConnectionFactory xaTopicConnectionFactory, ExecutionImpl execution) throws Exception {
        XATopicConnection xaTopicConnection = null;
        XATopicSession xaTopicSession = null;
        MessageProducer messageProducer = null;
        try {
            xaTopicConnection = xaTopicConnectionFactory.createXATopicConnection();
            xaTopicSession = xaTopicConnection.createXATopicSession();
            messageProducer = xaTopicSession.createProducer((Destination)topic);
            Message message = this.createMessage((Session)xaTopicSession, execution);
            messageProducer.send(message);
        }
        finally {
            try {
                messageProducer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                xaTopicSession.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                xaTopicConnection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToQueue(Queue queue, QueueConnectionFactory queueConnectionFactory, ExecutionImpl execution) throws Exception {
        QueueConnection queueConnection = null;
        QueueSession queueSession = null;
        QueueSender queueSender = null;
        try {
            queueConnection = queueConnectionFactory.createQueueConnection();
            queueSession = queueConnection.createQueueSession(this.transacted, this.acknowledgeMode);
            queueSender = queueSession.createSender(queue);
            Message message = this.createMessage((Session)queueSession, execution);
            queueSender.send(message);
            if (this.transacted) {
                queueSession.commit();
            }
        }
        finally {
            try {
                queueSender.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                queueSession.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                queueConnection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToTopic(Topic topic, TopicConnectionFactory topicConnectionFactory, ExecutionImpl execution) throws Exception {
        TopicConnection topicConnection = null;
        TopicSession topicSession = null;
        TopicPublisher topicPublisher = null;
        try {
            topicConnection = topicConnectionFactory.createTopicConnection();
            topicSession = topicConnection.createTopicSession(this.transacted, this.acknowledgeMode);
            topicPublisher = topicSession.createPublisher(topic);
            Message message = this.createMessage((Session)topicSession, execution);
            topicPublisher.send(message);
            if (this.transacted) {
                topicSession.commit();
            }
        }
        finally {
            try {
                topicPublisher.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                topicSession.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                topicConnection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected Message createMessage(Session session, ExecutionImpl execution) throws Exception {
        if ("text".equals(this.type)) {
            return this.createTextMessage(session, execution);
        }
        if ("object".equals(this.type)) {
            return this.createObjectMessage(session, execution);
        }
        if ("map".equals(this.type)) {
            return this.createMapMessage(session, execution);
        }
        throw new JbpmException("no type configured in jms activity");
    }

    private MapMessage createMapMessage(Session session, ExecutionImpl execution) throws Exception {
        MapMessage result = session.createMapMessage();
        if (this.mapDescriptor != null) {
            List keyDescriptors = this.mapDescriptor.getKeyDescriptors();
            List valueDescriptors = this.mapDescriptor.getValueDescriptors();
            WireContext wireContext = new WireContext();
            wireContext.setScopeInstance((ScopeInstanceImpl)execution);
            for (int i = 0; i < keyDescriptors.size(); ++i) {
                String key = (String)wireContext.create((Descriptor)keyDescriptors.get(i), false);
                Object value = wireContext.create((Descriptor)valueDescriptors.get(i), false);
                result.setObject(key, value);
            }
        }
        return result;
    }

    private TextMessage createTextMessage(Session session, ExecutionImpl execution) throws Exception {
        Object value = this.textExpression.evaluate((Execution)execution);
        if (value != null) {
            return session.createTextMessage(value.toString());
        }
        throw new JbpmException("null value for expression '" + this.textExpression + "' in jms activity");
    }

    private ObjectMessage createObjectMessage(Session session, ExecutionImpl execution) throws Exception {
        Object object = this.objectExpression.evaluate((Execution)execution);
        if (object != null && !(object instanceof Serializable)) {
            throw new JbpmException("can't send jms message: creation of object message expression '" + this.objectExpression + "' must be done with serializable: " + object);
        }
        return session.createObjectMessage((Serializable)object);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTextExpression(Expression textExpression) {
        this.textExpression = textExpression;
    }

    public void setObjectExpression(Expression objectExpression) {
        this.objectExpression = objectExpression;
    }

    public void setMapDescriptor(MapDescriptor mapDescriptor) {
        this.mapDescriptor = mapDescriptor;
    }

    public void setConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }
}

