/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.retry.RetryContext;
import org.mule.api.transformer.TransformerException;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.NullPayload;
import org.mule.transport.tcp.TcpConnector;
import org.mule.transport.tcp.TcpInputStream;

public class TcpMessageDispatcher
extends AbstractMessageDispatcher {
    private final TcpConnector connector;

    public TcpMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (TcpConnector)endpoint.getConnector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doDispatch(MuleEvent event) throws Exception {
        Socket socket = this.connector.getSocket(this.endpoint);
        try {
            this.dispatchToSocket(socket, event);
        }
        finally {
            this.connector.releaseSocket(socket, this.endpoint);
        }
    }

    private void doDispatchToSocket(Socket socket, MuleEvent event) throws Exception {
        try {
            this.dispatchToSocket(socket, event);
        }
        catch (Exception e) {
            this.connector.releaseSocket(socket, this.endpoint);
            throw new Exception(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized MuleMessage doSend(MuleEvent event) throws Exception {
        Socket socket = this.connector.getSocket(this.endpoint);
        this.doDispatchToSocket(socket, event);
        try {
            if (this.returnResponse(event)) {
                Object result;
                block12: {
                    try {
                        result = TcpMessageDispatcher.receiveFromSocket(socket, event.getTimeout(), this.endpoint);
                        if (result != null) break block12;
                        DefaultMuleMessage defaultMuleMessage = new DefaultMuleMessage((Object)NullPayload.getInstance(), this.connector.getMuleContext());
                        return defaultMuleMessage;
                    }
                    catch (SocketTimeoutException e) {
                        this.logger.info((Object)("Socket timed out normally while doing a synchronous receive on endpointUri: " + this.endpoint.getEndpointURI()));
                        DefaultMuleMessage defaultMuleMessage = new DefaultMuleMessage((Object)NullPayload.getInstance(), this.connector.getMuleContext());
                        return defaultMuleMessage;
                    }
                }
                if (result instanceof MuleMessage) {
                    MuleMessage muleMessage = (MuleMessage)result;
                    return muleMessage;
                }
                MuleMessage muleMessage = this.createMuleMessage(result, this.endpoint.getEncoding());
                return muleMessage;
            }
            DefaultMuleMessage defaultMuleMessage = new DefaultMuleMessage((Object)NullPayload.getInstance(), this.connector.getMuleContext());
            return defaultMuleMessage;
        }
        finally {
            if (!this.returnResponse(event)) {
                this.connector.releaseSocket(socket, this.endpoint);
            }
        }
    }

    private void dispatchToSocket(Socket socket, MuleEvent event) throws Exception {
        Object payload = event.getMessage().getPayload();
        this.write(socket, payload);
    }

    private void write(Socket socket, Object data) throws IOException, TransformerException {
        BufferedOutputStream bos = new BufferedOutputStream(socket.getOutputStream());
        this.connector.getTcpProtocol().write(bos, data);
        bos.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object receiveFromSocket(final Socket socket, int timeout, final ImmutableEndpoint endpoint) throws IOException {
        int soTimeout;
        final TcpConnector connector = (TcpConnector)endpoint.getConnector();
        DataInputStream underlyingIs = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        TcpInputStream tis = new TcpInputStream(underlyingIs){

            public void close() throws IOException {
                try {
                    connector.releaseSocket(socket, endpoint);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    IOException e2 = new IOException();
                    e2.initCause(e);
                    throw e2;
                }
            }
        };
        int n = soTimeout = endpoint.getResponseTimeout() != 0 ? endpoint.getResponseTimeout() : timeout;
        if (soTimeout >= 0) {
            socket.setSoTimeout(soTimeout);
        }
        try {
            Object object = connector.getTcpProtocol().read((InputStream)((Object)tis));
            return object;
        }
        finally {
            if (!tis.isStreaming()) {
                tis.close();
            }
        }
    }

    protected synchronized void doDispose() {
        try {
            this.doDisconnect();
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to shutdown the dispatcher.", (Throwable)e);
        }
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetryContext validateConnection(RetryContext retryContext) {
        Socket socket = null;
        try {
            socket = this.connector.getSocket(this.endpoint);
            retryContext.setOk();
        }
        catch (Exception ex) {
            retryContext.setFailed((Throwable)ex);
        }
        finally {
            block13: {
                if (socket != null) {
                    try {
                        this.connector.releaseSocket(socket, this.endpoint);
                    }
                    catch (Exception e) {
                        if (!this.logger.isDebugEnabled()) break block13;
                        this.logger.debug((Object)("Failed to release a socket " + socket), (Throwable)e);
                    }
                }
            }
        }
        return retryContext;
    }
}

