/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MessagePropertiesContext;
import org.mule.RequestContext;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.api.transport.OutputHandler;
import org.mule.api.transport.PropertyScope;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.CoreMessages;
import org.mule.message.ds.ByteArrayDataSource;
import org.mule.message.ds.StringDataSource;
import org.mule.transformer.TransformerUtils;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.mule.util.ClassUtils;
import org.mule.util.ObjectUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;
import org.mule.util.UUID;
import org.mule.util.store.DeserializationPostInitialisable;

public class DefaultMuleMessage
implements MuleMessage,
ThreadSafeAccess,
DeserializationPostInitialisable {
    protected static final String NOT_SET = "<not set>";
    private static final long serialVersionUID = 1541720810851984845L;
    private static final Log logger = LogFactory.getLog(DefaultMuleMessage.class);
    private static final List<Class<?>> consumableClasses = new ArrayList();
    private String id;
    private String rootId;
    private transient Object payload;
    private transient Object originalPayload;
    private ExceptionPayload exceptionPayload;
    private MessagePropertiesContext properties;
    private transient Map<String, DataHandler> inboundAttachments;
    private transient Map<String, DataHandler> outboundAttachments;
    private transient byte[] cache;
    protected transient MuleContext muleContext;
    private transient AtomicReference<Thread> ownerThread;
    private transient AtomicBoolean mutable;
    private DataType<?> dataType;

    private static void addToConsumableClasses(String className) {
        try {
            consumableClasses.add(ClassUtils.loadClass(className, DefaultMuleMessage.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public DefaultMuleMessage(Object message, MuleContext muleContext) {
        this(message, (Map<String, Object>)null, muleContext);
    }

    public DefaultMuleMessage(Object message, Map<String, Object> outboundProperties, MuleContext muleContext) {
        this(message, outboundProperties, null, muleContext);
    }

    public DefaultMuleMessage(Object message, Map<String, Object> outboundProperties, Map<String, DataHandler> attachments, MuleContext muleContext) {
        this(message, null, outboundProperties, attachments, muleContext);
    }

    public DefaultMuleMessage(Object message, Map<String, Object> inboundProperties, Map<String, Object> outboundProperties, Map<String, DataHandler> attachments, MuleContext muleContext) {
        this.rootId = this.id = UUID.getUUID();
        this.properties = new MessagePropertiesContext();
        this.inboundAttachments = new ConcurrentHashMap<String, DataHandler>();
        this.outboundAttachments = new ConcurrentHashMap<String, DataHandler>();
        this.ownerThread = null;
        this.mutable = null;
        this.setMuleContext(muleContext);
        if (message instanceof MuleMessage) {
            MuleMessage muleMessage = (MuleMessage)message;
            this.setPayload(muleMessage.getPayload());
            this.copyMessageProperties(muleMessage);
        } else {
            this.setPayload(message);
            this.originalPayload = message;
        }
        this.addProperties(inboundProperties, PropertyScope.INBOUND);
        this.addProperties(outboundProperties);
        if (attachments != null) {
            this.inboundAttachments = attachments;
        }
        this.resetAccessControl();
    }

    public DefaultMuleMessage(Object message, MuleMessage previous, MuleContext muleContext) {
        this.rootId = this.id = UUID.getUUID();
        this.properties = new MessagePropertiesContext();
        this.inboundAttachments = new ConcurrentHashMap<String, DataHandler>();
        this.outboundAttachments = new ConcurrentHashMap<String, DataHandler>();
        this.ownerThread = null;
        this.mutable = null;
        this.id = previous.getUniqueId();
        this.rootId = previous.getMessageRootId();
        this.setMuleContext(muleContext);
        this.setEncoding(previous.getEncoding());
        if (message instanceof MuleMessage) {
            MuleMessage payloadMessage = (MuleMessage)message;
            this.setPayload(payloadMessage.getPayload());
            this.copyMessageProperties(payloadMessage);
        } else {
            this.setPayload(message);
            this.copyMessageProperties(previous);
        }
        this.originalPayload = previous.getPayload();
        if (previous.getExceptionPayload() != null) {
            this.setExceptionPayload(previous.getExceptionPayload());
        }
        if (previous instanceof DefaultMuleMessage) {
            this.setInvocationProperties(((DefaultMuleMessage)previous).properties.invocationMap);
            this.setSessionProperties(((DefaultMuleMessage)previous).properties.sessionMap);
        }
        this.copyAttachments(previous);
        this.resetAccessControl();
    }

    protected void copyMessageProperties(MuleMessage muleMessage) {
        Map<String, Object> inboundProperties = ((DefaultMuleMessage)muleMessage).properties.getScopedProperties(PropertyScope.INBOUND);
        this.addInboundProperties(inboundProperties);
        for (PropertyScope scope : new PropertyScope[]{PropertyScope.INBOUND, PropertyScope.OUTBOUND}) {
            try {
                for (String name : muleMessage.getPropertyNames(scope)) {
                    Object value = muleMessage.getProperty(name, scope);
                    if (value == null) continue;
                    this.setProperty(name, value, scope);
                }
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
    }

    private void copyAttachments(MuleMessage previous) {
        if (previous.getInboundAttachmentNames().size() > 0) {
            for (String name : previous.getInboundAttachmentNames()) {
                try {
                    this.inboundAttachments.put(name, previous.getInboundAttachment(name));
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(CoreMessages.failedToReadAttachment(name), (Throwable)e);
                }
            }
        }
        if (previous.getOutboundAttachmentNames().size() > 0) {
            for (String name : previous.getOutboundAttachmentNames()) {
                try {
                    this.addOutboundAttachment(name, previous.getOutboundAttachment(name));
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(CoreMessages.failedToReadAttachment(name), (Throwable)e);
                }
            }
        }
    }

    public DefaultMuleMessage(MuleMessage message) {
        this(message.getPayload(), message, message.getMuleContext());
    }

    private void setMuleContext(MuleContext context) {
        if (context == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("muleContext").getMessage());
        }
        this.muleContext = context;
    }

    @Override
    public <T> T getPayload(Class<T> outputType) throws TransformerException {
        return this.getPayload(DataTypeFactory.create(outputType), this.getEncoding());
    }

    @Override
    public <T> T getPayload(DataType<T> outputType) throws TransformerException {
        return this.getPayload(outputType, this.getEncoding());
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    protected <T> T getPayload(DataType<T> resultType, String encoding) throws TransformerException {
        if (resultType == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("resultType").getMessage());
        }
        DataType<?> source = DataTypeFactory.createFromObject(this);
        if (resultType.isCompatibleWith(source)) {
            return (T)this.getPayload();
        }
        Transformer transformer = this.muleContext.getRegistry().lookupTransformer(source, resultType);
        if (transformer == null) {
            throw new TransformerException(CoreMessages.noTransformerFoundForMessage(source, resultType));
        }
        Object result = transformer.transform(this, encoding);
        if (!resultType.getType().isAssignableFrom(result.getClass())) {
            throw new TransformerException(CoreMessages.transformOnObjectNotOfSpecifiedType(resultType, result));
        }
        if (this.isPayloadConsumed(source.getType())) {
            this.setPayload(result);
        }
        return (T)result;
    }

    protected boolean isPayloadConsumed(Class<?> inputCls) {
        return InputStream.class.isAssignableFrom(inputCls) || this.isConsumedFromAdditional(inputCls);
    }

    private boolean isConsumedFromAdditional(Class<?> inputCls) {
        if (consumableClasses.isEmpty()) {
            return false;
        }
        for (Class<?> c : consumableClasses) {
            if (!c.isAssignableFrom(inputCls)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getOriginalPayload() {
        return this.originalPayload;
    }

    public void setInboundProperty(String key, Object value) {
        this.setProperty(key, value, PropertyScope.INBOUND);
    }

    @Override
    public void setInvocationProperty(String key, Object value) {
        this.setProperty(key, value, PropertyScope.INVOCATION);
    }

    @Override
    public void setOutboundProperty(String key, Object value) {
        this.setProperty(key, value, PropertyScope.OUTBOUND);
    }

    @Override
    public void setSessionProperty(String key, Object value) {
        this.setProperty(key, value, PropertyScope.SESSION);
    }

    @Override
    public void setProperty(String key, Object value, PropertyScope scope) {
        this.assertAccess(true);
        if (key != null) {
            if (value != null) {
                this.properties.setProperty(key, value, scope);
            } else {
                logger.warn((Object)("setProperty(key, value) called with null value; removing key: " + key + "; please report the following stack trace to " + MuleManifest.getDevListEmail()), new Throwable());
                this.properties.removeProperty(key);
            }
        } else {
            logger.warn((Object)("setProperty(key, value) ignored because of null key for object: " + value + "; please report the following stack trace to " + MuleManifest.getDevListEmail()), new Throwable());
        }
    }

    @Override
    @Deprecated
    public Object getProperty(String key) {
        this.assertAccess(false);
        return this.properties.getProperty(key, PropertyScope.OUTBOUND);
    }

    @Override
    public Object removeProperty(String key) {
        this.assertAccess(true);
        return this.properties.removeProperty(key);
    }

    @Override
    public Object removeProperty(String key, PropertyScope scope) {
        this.assertAccess(true);
        return this.properties.removeProperty(key, scope);
    }

    @Override
    @Deprecated
    public void setProperty(String key, Object value) {
        this.assertAccess(true);
        if (key != null) {
            if (value != null) {
                this.properties.setProperty(key, value, PropertyScope.OUTBOUND);
            } else {
                logger.warn((Object)("setProperty(key, value) called with null value; removing key: " + key + "; please report the following stack trace to " + MuleManifest.getDevListEmail()), new Throwable());
                this.properties.removeProperty(key);
            }
        } else {
            logger.warn((Object)("setProperty(key, value) ignored because of null key for object: " + value + "; please report the following stack trace to " + MuleManifest.getDevListEmail()), new Throwable());
        }
    }

    @Override
    public final String getPayloadAsString() throws Exception {
        this.assertAccess(false);
        return this.getPayloadAsString(this.getEncoding());
    }

    @Override
    public String getPayloadForLogging(String encoding) {
        try {
            return this.getPayloadAsString(encoding);
        }
        catch (Exception e) {
            return "[Message could not be converted to string]";
        }
    }

    @Override
    public String getPayloadForLogging() {
        try {
            return this.getPayloadAsString();
        }
        catch (Exception e) {
            return "[Message could not be converted to string]";
        }
    }

    @Override
    public byte[] getPayloadAsBytes() throws Exception {
        this.assertAccess(false);
        if (this.cache != null) {
            return this.cache;
        }
        byte[] result = this.getPayload(DataType.BYTE_ARRAY_DATA_TYPE);
        if (this.muleContext.getConfiguration().isCacheMessageAsBytes()) {
            this.cache = result;
        }
        return result;
    }

    @Override
    public String getPayloadAsString(String encoding) throws Exception {
        this.assertAccess(false);
        if (this.cache != null) {
            return new String(this.cache, encoding);
        }
        String result = this.getPayload(DataType.STRING_DATA_TYPE, encoding);
        if (this.muleContext.getConfiguration().isCacheMessageAsBytes()) {
            this.cache = result.getBytes(encoding);
        }
        return result;
    }

    @Override
    @Deprecated
    public Set<String> getPropertyNames() {
        this.assertAccess(false);
        return this.properties.getPropertyNames();
    }

    @Override
    public Set<String> getPropertyNames(PropertyScope scope) {
        this.assertAccess(false);
        return this.properties.getScopedProperties(scope).keySet();
    }

    @Override
    public Set<String> getInvocationPropertyNames() {
        return this.getPropertyNames(PropertyScope.INVOCATION);
    }

    @Override
    public Set<String> getInboundPropertyNames() {
        return this.getPropertyNames(PropertyScope.INBOUND);
    }

    @Override
    public Set<String> getOutboundPropertyNames() {
        return this.getPropertyNames(PropertyScope.OUTBOUND);
    }

    @Override
    public Set<String> getSessionPropertyNames() {
        return this.getPropertyNames(PropertyScope.SESSION);
    }

    @Override
    public String getUniqueId() {
        this.assertAccess(false);
        return this.id;
    }

    public void setUniqueId(String uid) {
        this.assertAccess(true);
        this.id = uid;
    }

    @Override
    public String getMessageRootId() {
        this.assertAccess(false);
        return this.rootId;
    }

    @Override
    public void setMessageRootId(String rid) {
        this.assertAccess(true);
        this.rootId = rid;
    }

    @Override
    public void propagateRootId(MuleMessage parent) {
        this.assertAccess(true);
        if (parent != null) {
            this.rootId = parent.getMessageRootId();
        }
    }

    @Override
    public Object getProperty(String name, Object defaultValue) {
        this.assertAccess(false);
        return this.properties.getProperty(name, defaultValue);
    }

    @Override
    public <T> T getProperty(String name, PropertyScope scope) {
        this.assertAccess(false);
        return this.properties.getProperty(name, scope);
    }

    @Override
    public <T> T getInboundProperty(String name, T defaultValue) {
        return this.getProperty(name, PropertyScope.INBOUND, defaultValue);
    }

    @Override
    public <T> T getInboundProperty(String name) {
        return (T)this.getProperty(name, PropertyScope.INBOUND, null);
    }

    @Override
    public <T> T getInvocationProperty(String name, T defaultValue) {
        return this.getProperty(name, PropertyScope.INVOCATION, defaultValue);
    }

    @Override
    public <T> T getInvocationProperty(String name) {
        return (T)this.getInvocationProperty(name, null);
    }

    @Override
    public <T> T getOutboundProperty(String name, T defaultValue) {
        return this.getProperty(name, PropertyScope.OUTBOUND, defaultValue);
    }

    @Override
    public <T> T getOutboundProperty(String name) {
        return (T)this.getOutboundProperty(name, null);
    }

    @Override
    public <T> T getSessionProperty(String name, T defaultValue) {
        return this.getProperty(name, PropertyScope.SESSION, defaultValue);
    }

    @Override
    public <T> T getSessionProperty(String name) {
        return (T)this.getSessionProperty(name, null);
    }

    @Override
    public <T> T getProperty(String name, PropertyScope scope, T defaultValue) {
        Object result;
        this.assertAccess(false);
        if (defaultValue instanceof Boolean) {
            result = ObjectUtils.getBoolean(this.getProperty(name, scope), (Boolean)defaultValue);
        } else if (defaultValue instanceof Byte) {
            result = ObjectUtils.getByte(this.getProperty(name, scope), (Byte)defaultValue);
        } else if (defaultValue instanceof Integer) {
            result = ObjectUtils.getInt(this.getProperty(name, scope), (Integer)defaultValue);
        } else if (defaultValue instanceof Short) {
            result = ObjectUtils.getShort(this.getProperty(name, scope), (Short)defaultValue);
        } else if (defaultValue instanceof Long) {
            result = ObjectUtils.getLong(this.getProperty(name, scope), (Long)defaultValue);
        } else if (defaultValue instanceof Float) {
            result = Float.valueOf(ObjectUtils.getFloat(this.getProperty(name, scope), (Float)defaultValue));
        } else if (defaultValue instanceof Double) {
            result = ObjectUtils.getDouble(this.getProperty(name, scope), (Double)defaultValue);
        } else if (defaultValue instanceof String) {
            result = ObjectUtils.getString(this.getProperty(name, scope), (String)defaultValue);
        } else {
            T temp = this.getProperty(name, scope);
            if (temp == null) {
                return defaultValue;
            }
            if (defaultValue == null) {
                return temp;
            }
            if (defaultValue.getClass().isAssignableFrom(temp.getClass())) {
                result = temp;
            } else {
                throw new IllegalArgumentException(CoreMessages.objectNotOfCorrectType(temp.getClass(), defaultValue.getClass()).getMessage());
            }
        }
        return (T)result;
    }

    @Override
    public void setCorrelationId(String id) {
        this.assertAccess(true);
        if (StringUtils.isNotBlank((String)id)) {
            this.setProperty("MULE_CORRELATION_ID", id, PropertyScope.OUTBOUND);
        } else {
            this.removeProperty("MULE_CORRELATION_ID");
        }
    }

    @Override
    public String getCorrelationId() {
        this.assertAccess(false);
        String correlationId = (String)this.getOutboundProperty("MULE_CORRELATION_ID");
        if (correlationId == null) {
            correlationId = (String)this.getInboundProperty("MULE_CORRELATION_ID");
        }
        return correlationId;
    }

    @Override
    public void setReplyTo(Object replyTo) {
        this.assertAccess(true);
        if (replyTo != null) {
            this.setProperty("MULE_REPLYTO", replyTo, PropertyScope.OUTBOUND);
        } else {
            this.removeProperty("MULE_REPLYTO");
            this.removeProperty("MULE_REPLYTO", PropertyScope.INBOUND);
        }
    }

    @Override
    public Object getReplyTo() {
        this.assertAccess(false);
        Object replyTo = this.getProperty("MULE_REPLYTO", PropertyScope.OUTBOUND);
        if (replyTo == null) {
            replyTo = this.getProperty("MULE_REPLYTO", PropertyScope.INBOUND);
        }
        return replyTo;
    }

    @Override
    public int getCorrelationSequence() {
        this.assertAccess(false);
        Object correlationSequence = this.findPropertyInSpecifiedScopes("MULE_CORRELATION_SEQUENCE", PropertyScope.OUTBOUND, PropertyScope.INBOUND);
        return ObjectUtils.getInt(correlationSequence, -1);
    }

    @Override
    public void setCorrelationSequence(int sequence) {
        this.assertAccess(true);
        this.setOutboundProperty("MULE_CORRELATION_SEQUENCE", sequence);
    }

    @Override
    public int getCorrelationGroupSize() {
        this.assertAccess(false);
        Object correlationGroupSize = this.findPropertyInSpecifiedScopes("MULE_CORRELATION_GROUP_SIZE", PropertyScope.OUTBOUND, PropertyScope.INBOUND);
        return ObjectUtils.getInt(correlationGroupSize, -1);
    }

    @Override
    public void setCorrelationGroupSize(int size) {
        this.assertAccess(true);
        this.setOutboundProperty("MULE_CORRELATION_GROUP_SIZE", size);
    }

    @Override
    public ExceptionPayload getExceptionPayload() {
        this.assertAccess(false);
        return this.exceptionPayload;
    }

    @Override
    public void setExceptionPayload(ExceptionPayload exceptionPayload) {
        this.assertAccess(true);
        this.exceptionPayload = exceptionPayload;
    }

    public String toString() {
        this.assertAccess(false);
        StringBuffer buf = new StringBuffer(120);
        String nl = System.getProperty("line.separator");
        buf.append(nl);
        buf.append(this.getClass().getName());
        buf.append(nl);
        buf.append("{");
        buf.append(nl);
        buf.append("  id=").append(this.getUniqueId());
        buf.append(nl);
        buf.append("  payload=").append(this.getPayload().getClass().getName());
        buf.append(nl);
        buf.append("  correlationId=").append(StringUtils.defaultString((String)this.getCorrelationId(), (String)NOT_SET));
        buf.append(nl);
        buf.append("  correlationGroup=").append(this.getCorrelationGroupSize());
        buf.append(nl);
        buf.append("  correlationSeq=").append(this.getCorrelationSequence());
        buf.append(nl);
        buf.append("  encoding=").append(this.getEncoding());
        buf.append(nl);
        buf.append("  exceptionPayload=").append(ObjectUtils.defaultIfNull((Object)this.exceptionPayload, (Object)NOT_SET));
        buf.append(nl);
        buf.append(StringMessageUtils.headersToString(this));
        buf.append('}');
        return buf.toString();
    }

    @Override
    @Deprecated
    public void addAttachment(String name, DataHandler dataHandler) throws Exception {
        logger.warn((Object)"MuleMessage.addAttachment() method is deprecated, use MuleMessage.addOutboundAttachment() instead.  This method will be removed in the next point release");
        this.addOutboundAttachment(name, dataHandler);
    }

    @Override
    @Deprecated
    public void removeAttachment(String name) throws Exception {
        logger.warn((Object)"MuleMessage.removeAttachment() method is deprecated, use MuleMessage.removeOutboundAttachment() instead.  This method will be removed in the next point release");
        this.removeOutboundAttachment(name);
    }

    @Override
    @Deprecated
    public DataHandler getAttachment(String name) {
        logger.warn((Object)"MuleMessage.getAttachment() method is deprecated, use MuleMessage.getInboundAttachment() instead.  This method will be removed in the next point release");
        return this.getInboundAttachment(name);
    }

    @Override
    @Deprecated
    public Set<String> getAttachmentNames() {
        logger.warn((Object)"MuleMessage.getAttachmentNames() method is deprecated, use MuleMessage.getInboundAttachmentNames() instead.  This method will be removed in the next point release");
        return this.getInboundAttachmentNames();
    }

    @Override
    public void addOutboundAttachment(String name, DataHandler dataHandler) throws Exception {
        this.assertAccess(true);
        this.outboundAttachments.put(name, dataHandler);
    }

    public void addInboundAttachment(String name, DataHandler dataHandler) throws Exception {
        this.assertAccess(true);
        this.inboundAttachments.put(name, dataHandler);
    }

    @Override
    public void addOutboundAttachment(String name, Object object, String contentType) throws Exception {
        this.assertAccess(true);
        DataHandler dh = object instanceof File ? (contentType != null ? new DataHandler((Object)new FileInputStream((File)object), contentType) : new DataHandler((DataSource)new FileDataSource((File)object))) : (object instanceof URL ? (contentType != null ? new DataHandler((Object)((URL)object).openStream(), contentType) : new DataHandler((URL)object)) : (object instanceof String ? (contentType != null ? new DataHandler((DataSource)new StringDataSource((String)object, name, contentType)) : new DataHandler((DataSource)new StringDataSource((String)object, name))) : (object instanceof byte[] && contentType != null ? new DataHandler((DataSource)new ByteArrayDataSource((byte[])object, contentType, name)) : new DataHandler(object, contentType))));
        this.outboundAttachments.put(name, dh);
    }

    @Override
    public void removeOutboundAttachment(String name) throws Exception {
        this.assertAccess(true);
        this.outboundAttachments.remove(name);
    }

    @Override
    public DataHandler getInboundAttachment(String name) {
        this.assertAccess(false);
        return this.inboundAttachments.get(name);
    }

    @Override
    public DataHandler getOutboundAttachment(String name) {
        this.assertAccess(false);
        return this.outboundAttachments.get(name);
    }

    @Override
    public Set<String> getInboundAttachmentNames() {
        this.assertAccess(false);
        return Collections.unmodifiableSet(this.inboundAttachments.keySet());
    }

    @Override
    public Set<String> getOutboundAttachmentNames() {
        this.assertAccess(false);
        return Collections.unmodifiableSet(this.outboundAttachments.keySet());
    }

    @Override
    public <T> T findPropertyInAnyScope(String name, T defaultValue) {
        T value = this.findPropertyInSpecifiedScopes(name, PropertyScope.OUTBOUND, PropertyScope.INVOCATION, PropertyScope.SESSION, PropertyScope.INBOUND);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public String getEncoding() {
        this.assertAccess(false);
        String encoding = null;
        if (this.dataType != null) {
            encoding = this.dataType.getEncoding();
        }
        if (encoding != null) {
            return encoding;
        }
        encoding = (String)this.getOutboundProperty("MULE_ENCODING");
        if (encoding != null) {
            return encoding;
        }
        return System.getProperty("mule.encoding");
    }

    @Override
    public void setEncoding(String encoding) {
        this.assertAccess(true);
        if (encoding != null) {
            this.setOutboundProperty("MULE_ENCODING", encoding);
        }
    }

    public void setMimeType(String mimeType) {
        this.assertAccess(true);
        if (mimeType != null && !mimeType.equals("*/*")) {
            String encoding = this.getEncoding();
            if (encoding != null) {
                mimeType = mimeType + ";charset=" + encoding;
            }
            this.setOutboundProperty("Content-Type", mimeType);
        }
    }

    @Override
    public void addProperties(Map<String, Object> props) {
        this.addProperties(props, this.properties.getDefaultScope());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProperties(Map<String, Object> props, PropertyScope scope) {
        this.assertAccess(true);
        if (props != null) {
            Map<String, Object> map = props;
            synchronized (map) {
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    this.setProperty(entry.getKey(), entry.getValue(), scope);
                }
            }
        }
    }

    public void addInboundProperties(Map<String, Object> props) {
        this.properties.addInboundProperties(props);
    }

    @Override
    public void clearProperties() {
        this.assertAccess(true);
        this.properties.clearProperties(PropertyScope.INVOCATION);
        this.properties.clearProperties(PropertyScope.OUTBOUND);
    }

    @Override
    public void clearProperties(PropertyScope scope) {
        this.assertAccess(true);
        this.properties.clearProperties(scope);
    }

    @Override
    public Object getPayload() {
        return this.payload;
    }

    @Override
    public synchronized void setPayload(Object payload) {
        this.payload = payload == null ? NullPayload.getInstance() : payload;
        this.cache = null;
    }

    @Override
    public void release() {
        this.cache = null;
    }

    @Override
    public void applyTransformers(MuleEvent event, List<? extends Transformer> transformers) throws MuleException {
        this.applyTransformers(event, transformers, null);
    }

    @Override
    public void applyTransformers(MuleEvent event, Transformer ... transformers) throws MuleException {
        this.applyTransformers(event, Arrays.asList(transformers), null);
    }

    @Override
    public void applyTransformers(MuleEvent event, List<? extends Transformer> transformers, Class<?> outputType) throws MuleException {
        if (!transformers.isEmpty()) {
            this.applyAllTransformers(event, transformers);
        }
        if (null != outputType && !this.getPayload().getClass().isAssignableFrom(outputType)) {
            this.setPayload(this.getPayload(DataTypeFactory.create(outputType)));
        }
    }

    protected void applyAllTransformers(MuleEvent event, List<? extends Transformer> transformers) throws MuleException {
        if (!transformers.isEmpty()) {
            for (int index = 0; index < transformers.size(); ++index) {
                Class<?> srcCls;
                DataType<?> originalSourceType;
                Transformer transformer = transformers.get(index);
                if (transformer.isSourceDataTypeSupported(originalSourceType = DataTypeFactory.create(srcCls = this.getPayload().getClass()))) {
                    this.transformMessage(event, transformer);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Transformer " + transformer + " doesn't support the source payload: " + srcCls));
                }
                if (this.useExtendedTransformations()) {
                    if (this.canSkipTransformer(transformers, index)) continue;
                    Transformer implicitTransformer = this.muleContext.getDataTypeConverterResolver().resolve(originalSourceType, transformer.getSourceDataTypes());
                    if (implicitTransformer != null) {
                        this.transformMessage(event, implicitTransformer);
                        this.transformMessage(event, transformer);
                        continue;
                    }
                    throw new IllegalArgumentException("Cannot apply transformer " + transformer + " on source payload: " + srcCls);
                }
                if (transformer.isIgnoreBadInput()) continue;
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)"Exiting from transformer chain (ignoreBadInput = false)");
                break;
            }
        }
    }

    private boolean canSkipTransformer(List<? extends Transformer> transformers, int index) {
        Transformer transformer = transformers.get(index);
        boolean skipConverter = false;
        if (transformer instanceof Converter) {
            if (index == transformers.size() - 1) {
                try {
                    TransformerUtils.checkTransformerReturnClass(transformer, this.payload);
                    skipConverter = true;
                }
                catch (TransformerException e) {}
            } else {
                skipConverter = true;
            }
        }
        if (skipConverter) {
            logger.debug((Object)("Skipping converter: " + transformer));
        }
        return skipConverter;
    }

    private boolean useExtendedTransformations() {
        boolean result = true;
        if (this.muleContext != null && this.muleContext.getConfiguration() != null) {
            result = this.muleContext.getConfiguration().useExtendedTransformations();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformMessage(MuleEvent event, Transformer transformer) throws TransformerMessagingException, TransformerException {
        Object result = transformer instanceof MessageTransformer ? ((MessageTransformer)transformer).transform((Object)this, event) : transformer.transform(this);
        RequestContext.internalRewriteEvent(this, false);
        if (this.originalPayload == null && this.muleContext.getConfiguration().isCacheMessageOriginalPayload()) {
            this.originalPayload = this.payload;
        }
        if (result instanceof MuleMessage) {
            if (!result.equals(this)) {
                DefaultMuleMessage defaultMuleMessage = this;
                synchronized (defaultMuleMessage) {
                    MuleMessage resultMessage = (MuleMessage)result;
                    this.setPayload(resultMessage.getPayload());
                    this.originalPayload = resultMessage.getOriginalPayload();
                    this.copyMessageProperties(resultMessage);
                    this.copyAttachments(resultMessage);
                }
            }
        } else {
            this.setPayload(result);
        }
        this.setDataType(transformer.getReturnDataType());
    }

    protected void setDataType(DataType<?> dt) {
        this.dataType = dt;
        this.setEncoding(dt == null ? null : dt.getEncoding());
        this.setMimeType(dt == null ? null : dt.getMimeType());
    }

    @Override
    public ThreadSafeAccess newThreadCopy() {
        return new DefaultMuleMessage(this);
    }

    @Override
    public void resetAccessControl() {
        if (this.ownerThread != null) {
            this.ownerThread.set(null);
        }
        if (this.mutable != null) {
            this.mutable.set(true);
        }
    }

    @Override
    public void assertAccess(boolean write) {
        if (ThreadSafeAccess.AccessControl.isAssertMessageAccess()) {
            this.initAccessControl();
            this.setOwner();
            this.checkMutable(write);
        }
    }

    private synchronized void initAccessControl() {
        if (null == this.ownerThread) {
            this.ownerThread = new AtomicReference();
        }
        if (null == this.mutable) {
            this.mutable = new AtomicBoolean(true);
        }
    }

    private void setOwner() {
        if (null == this.ownerThread.get()) {
            this.ownerThread.compareAndSet(null, Thread.currentThread());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkMutable(boolean write) {
        Thread currentThread = Thread.currentThread();
        if (currentThread.equals(this.ownerThread.get())) {
            if (!write || this.mutable.get()) return;
            if (!this.isDisabled()) throw this.newException("Cannot write to immutable message");
            logger.warn((Object)"Writing to immutable message (exception disabled)");
            return;
        } else {
            if (!write) return;
            if (!this.isDisabled()) throw this.newException("Only owner thread can write to message: " + this.ownerThread.get() + "/" + Thread.currentThread());
            logger.warn((Object)"Non-owner writing to message (exception disabled)");
        }
    }

    protected boolean isDisabled() {
        return !ThreadSafeAccess.AccessControl.isFailOnMessageScribbling();
    }

    protected IllegalStateException newException(String message) {
        IllegalStateException exception = new IllegalStateException(message);
        logger.warn((Object)"Message access violation", (Throwable)exception);
        return exception;
    }

    public boolean isConsumable() {
        return this.isConsumedFromAdditional(this.getPayload().getClass());
    }

    private void writeObject(ObjectOutputStream out) throws Exception {
        out.defaultWriteObject();
        if (this.payload instanceof Serializable) {
            out.writeBoolean(true);
            out.writeObject(this.payload);
        } else {
            out.writeBoolean(false);
            byte[] serializablePayload = this.getPayloadAsBytes();
            out.writeInt(serializablePayload.length);
            new DataOutputStream(out).write(serializablePayload);
        }
        out.writeObject(this.serializeAttachments(this.inboundAttachments));
        out.writeObject(this.serializeAttachments(this.outboundAttachments));
    }

    private Map<String, SerializedDataHandler> serializeAttachments(Map<String, DataHandler> attachments) throws IOException {
        HashMap<String, SerializedDataHandler> toWrite;
        if (attachments == null) {
            toWrite = null;
        } else {
            toWrite = new HashMap<String, SerializedDataHandler>(attachments.size());
            for (Map.Entry<String, DataHandler> entry : attachments.entrySet()) {
                String name = entry.getKey();
                toWrite.put(name, new SerializedDataHandler(name, entry.getValue(), this.muleContext));
            }
        }
        return toWrite;
    }

    private Map<String, DataHandler> deserializeAttachments(Map<String, SerializedDataHandler> attachments) throws IOException {
        HashMap<String, DataHandler> toReturn;
        if (attachments == null) {
            toReturn = null;
        } else {
            toReturn = new HashMap<String, DataHandler>(attachments.size());
            for (Map.Entry<String, SerializedDataHandler> entry : attachments.entrySet()) {
                toReturn.put(entry.getKey(), entry.getValue().getHandler());
            }
        }
        return toReturn;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean payloadWasSerialized = in.readBoolean();
        if (payloadWasSerialized) {
            this.payload = in.readObject();
        } else {
            int payloadSize = in.readInt();
            byte[] serializedPayload = new byte[payloadSize];
            new DataInputStream(in).readFully(serializedPayload);
            this.payload = serializedPayload;
        }
        this.inboundAttachments = this.deserializeAttachments((Map)in.readObject());
        this.outboundAttachments = this.deserializeAttachments((Map)in.readObject());
    }

    public void initAfterDeserialisation(MuleContext context) throws MuleException {
        this.muleContext = context;
    }

    @Override
    public DataType<?> getDataType() {
        return this.dataType;
    }

    @Override
    @Deprecated
    public int getIntProperty(String name, int defaultValue) {
        this.assertAccess(false);
        logger.warn((Object)"MuleMessage.getIntProperty() method is deprecated, use MuleMessage.getInboundProperty() instead.  This method will be removed in the next point release");
        return this.getInboundProperty(name, defaultValue);
    }

    @Override
    @Deprecated
    public long getLongProperty(String name, long defaultValue) {
        this.assertAccess(false);
        logger.warn((Object)"MuleMessage.getLongProperty() method is deprecated, use MuleMessage.getInboundProperty() instead.  This method will be removed in the next point release");
        return this.getInboundProperty(name, defaultValue);
    }

    @Override
    @Deprecated
    public double getDoubleProperty(String name, double defaultValue) {
        this.assertAccess(false);
        logger.warn((Object)"MuleMessage.getDoubleProperty() method is deprecated, use MuleMessage.getInboundProperty() instead.  This method will be removed in the next point release");
        return this.getInboundProperty(name, defaultValue);
    }

    @Override
    @Deprecated
    public boolean getBooleanProperty(String name, boolean defaultValue) {
        this.assertAccess(false);
        logger.warn((Object)"MuleMessage.getBooleanProperty() method is deprecated, use MuleMessage.getInboundProperty() instead.  This method will be removed in the next point release");
        return this.getInboundProperty(name, defaultValue);
    }

    @Override
    @Deprecated
    public void setBooleanProperty(String name, boolean value) {
        this.assertAccess(true);
        logger.warn((Object)"MuleMessage.setBooleanProperty() method is deprecated, use MuleMessage.setOutboundProperty() instead.  This method will be removed in the next point release");
        this.setOutboundProperty(name, value);
    }

    @Override
    @Deprecated
    public void setIntProperty(String name, int value) {
        this.assertAccess(true);
        logger.warn((Object)"MuleMessage.setIntProperty() method is deprecated, use MuleMessage.setOutboundProperty() instead.  This method will be removed in the next point release");
        this.setOutboundProperty(name, value);
    }

    @Override
    @Deprecated
    public void setLongProperty(String name, long value) {
        this.assertAccess(true);
        logger.warn((Object)"MuleMessage.setLongProperty() method is deprecated, use MuleMessage.setOutboundProperty() instead.  This method will be removed in the next point release");
        this.setOutboundProperty(name, value);
    }

    @Override
    @Deprecated
    public void setDoubleProperty(String name, double value) {
        this.assertAccess(true);
        logger.warn((Object)"MuleMessage.setDoubleProperty() method is deprecated, use MuleMessage.setOutboundProperty() instead.  This method will be removed in the next point release");
        this.setOutboundProperty(name, value);
    }

    @Override
    @Deprecated
    public String getStringProperty(String name, String defaultValue) {
        this.assertAccess(false);
        logger.warn((Object)"MuleMessage.getStringProperty() method is deprecated, use MuleMessage.getInboundProperty() instead.  This method will be removed in the next point release");
        return this.getInboundProperty(name, defaultValue);
    }

    @Override
    @Deprecated
    public void setStringProperty(String name, String value) {
        this.assertAccess(true);
        logger.warn((Object)"MuleMessage.setStringProperty() method is deprecated, use MuleMessage.setOutboundProperty() instead.  This method will be removed in the next point release");
        this.setOutboundProperty(name, value);
    }

    public <T> T findPropertyInSpecifiedScopes(String name, PropertyScope ... scopesToSearch) {
        for (PropertyScope scope : scopesToSearch) {
            T result = this.getProperty(name, scope);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public MuleMessage createInboundMessage() throws Exception {
        DefaultMuleMessage newMessage = new DefaultMuleMessage(this.getPayload(), this, this.getMuleContext());
        this.copyToInbound(newMessage);
        return newMessage;
    }

    protected void copyToInbound(DefaultMuleMessage newMessage) throws Exception {
        HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>(3);
        for (String name : this.getOutboundAttachmentNames()) {
            attachments.put(name, this.getOutboundAttachment(name));
        }
        HashMap newInboundProperties = new HashMap(3);
        for (String string : this.getOutboundPropertyNames()) {
            newInboundProperties.put(string, this.getOutboundProperty(string));
        }
        newMessage.clearProperties(PropertyScope.INBOUND);
        newMessage.clearProperties(PropertyScope.INVOCATION);
        newMessage.clearProperties(PropertyScope.OUTBOUND);
        for (Map.Entry entry : newInboundProperties.entrySet()) {
            newMessage.setInboundProperty((String)entry.getKey(), entry.getValue());
        }
        newMessage.inboundAttachments.clear();
        newMessage.outboundAttachments.clear();
        for (Map.Entry entry : attachments.entrySet()) {
            newMessage.addInboundAttachment((String)entry.getKey(), (DataHandler)entry.getValue());
        }
        newMessage.setCorrelationId(this.getCorrelationId());
        newMessage.setCorrelationGroupSize(this.getCorrelationGroupSize());
        newMessage.setCorrelationSequence(this.getCorrelationSequence());
        newMessage.setReplyTo(this.getReplyTo());
        newMessage.setEncoding(this.getEncoding());
    }

    void setSessionProperties(Map<String, Object> sessionProperties) {
        this.properties.sessionMap = sessionProperties;
    }

    void setInvocationProperties(Map<String, Object> invocationProperties) {
        this.properties.invocationMap = invocationProperties;
    }

    static {
        DefaultMuleMessage.addToConsumableClasses("javax.xml.stream.XMLStreamReader");
        DefaultMuleMessage.addToConsumableClasses("javax.xml.transform.stream.StreamSource");
        consumableClasses.add(OutputHandler.class);
        consumableClasses.add(InputStream.class);
        consumableClasses.add(Reader.class);
    }

    public static class SerializedDataHandler
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private DataHandler handler;
        private String contentType;
        private Object contents;

        public SerializedDataHandler(String name, DataHandler handler, MuleContext muleContext) throws IOException {
            if (handler != null && !(handler instanceof Serializable)) {
                this.contentType = handler.getContentType();
                Object theContent = handler.getContent();
                if (theContent instanceof Serializable) {
                    this.contents = theContent;
                } else {
                    try {
                        DataType<?> source = DataTypeFactory.createFromObject(theContent);
                        Transformer transformer = muleContext.getRegistry().lookupTransformer(source, DataType.BYTE_ARRAY_DATA_TYPE);
                        if (transformer == null) {
                            throw new TransformerException(CoreMessages.noTransformerFoundForMessage(source, DataType.BYTE_ARRAY_DATA_TYPE));
                        }
                        this.contents = transformer.transform(theContent);
                    }
                    catch (TransformerException ex) {
                        String message = String.format("Unable to serialize the attachment %s, which is of type %s with contents of type %s", name, handler.getClass(), theContent.getClass());
                        logger.error((Object)message);
                        throw new IOException(message);
                    }
                }
            } else {
                this.handler = handler;
            }
        }

        public DataHandler getHandler() {
            return this.contents != null ? new DataHandler(this.contents, this.contentType) : this.handler;
        }
    }
}

