/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.el.ExpressionExecutor;
import org.mule.api.expression.InvalidExpressionException;
import org.mule.el.mvel.MVELExpressionLanguageContext;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.optimizers.OptimizerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVELExpressionExecutor
implements ExpressionExecutor<MVELExpressionLanguageContext> {
    private static Logger log = LoggerFactory.getLogger(MVELExpressionExecutor.class);
    protected static final int COMPILED_EXPRESSION_MAX_CACHE_SIZE = 1000;
    protected ParserContext parserContext;
    protected Cache<String, Serializable> compiledExpressionsCache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public MVELExpressionExecutor(ParserContext parserContext) {
        this.parserContext = parserContext;
    }

    @Override
    public Object execute(String expression, MVELExpressionLanguageContext context) {
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        if (log.isTraceEnabled()) {
            log.trace("Executing MVEL expression '" + expression + "' with context: \n" + context.toString());
        }
        return MVEL.executeExpression((Object)this.getCompiledExpression(expression), (VariableResolverFactory)context);
    }

    @Override
    public void validate(String expression) throws InvalidExpressionException {
        this.getCompiledExpression(expression);
    }

    protected Serializable getCompiledExpression(final String expression) {
        try {
            return (Serializable)this.compiledExpressionsCache.get((Object)expression, (Callable)new Callable<Serializable>(){

                @Override
                public Serializable call() {
                    return MVEL.compileExpression((String)expression, (ParserContext)new ParserContext(MVELExpressionExecutor.this.parserContext.getParserConfiguration()));
                }
            });
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new MuleRuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e);
        }
    }
}

