/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.MimeType;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.el.ExpressionLanguage;
import org.mule.api.el.ExpressionLanguageExtension;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.expression.InvalidExpressionException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.config.i18n.CoreMessages;
import org.mule.el.mvel.EventVariableResolverFactory;
import org.mule.el.mvel.GlobalVariableResolverFactory;
import org.mule.el.mvel.MVELExpressionExecutor;
import org.mule.el.mvel.MVELExpressionLanguageContext;
import org.mule.el.mvel.MessageVariableResolverFactory;
import org.mule.el.mvel.StaticVariableResolverFactory;
import org.mule.el.mvel.VariableVariableResolverFactory;
import org.mule.mvel2.CompileException;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.ast.Function;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.mvel2.compiler.ExpressionCompiler;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.integration.impl.CachedMapVariableResolverFactory;
import org.mule.mvel2.util.CompilerTools;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.mule.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVELExpressionLanguage
implements ExpressionLanguage,
Initialisable {
    private static Logger log = LoggerFactory.getLogger(MVELExpressionLanguage.class);
    protected ParserContext parserContext;
    protected MuleContext muleContext;
    protected MVELExpressionExecutor expressionExecutor;
    protected Collection<ExpressionLanguageExtension> expressionLanguageExtensions;
    protected MVELExpressionLanguageContext staticContext;
    protected String globalFunctionsString;
    protected String globalFunctionsFile;
    protected Map<String, Function> globalFunctions = new HashMap<String, Function>();
    protected Map<String, String> aliases = new HashMap<String, String>();
    protected Map<String, Class<?>> imports = new HashMap();
    protected boolean autoResolveVariables = true;

    public MVELExpressionLanguage(MuleContext muleContext) {
        this.muleContext = muleContext;
        System.setProperty("mvel2.compiler.allow_override_all_prophandling", "true");
    }

    @Override
    public void initialise() throws InitialisationException {
        this.parserContext = this.createParserContext();
        this.expressionExecutor = new MVELExpressionExecutor(this.parserContext);
        this.expressionLanguageExtensions = this.muleContext.getRegistry().lookupObjectsForLifecycle(ExpressionLanguageExtension.class);
        this.loadGlobalFunctions();
        this.createStaticContext();
    }

    protected void createStaticContext() {
        this.staticContext = new StaticVariableResolverFactory(this.parserContext, this.muleContext);
    }

    protected void loadGlobalFunctions() throws InitialisationException {
        if (this.globalFunctionsFile != null) {
            try {
                this.globalFunctions.putAll(CompilerTools.extractAllDeclaredFunctions((CompiledExpression)new ExpressionCompiler(IOUtils.getResourceAsString(this.globalFunctionsFile, this.getClass())).compile()));
            }
            catch (IOException e) {
                throw new InitialisationException(CoreMessages.failedToLoad(this.globalFunctionsFile), (Throwable)e, this);
            }
        }
        this.globalFunctions.putAll(CompilerTools.extractAllDeclaredFunctions((CompiledExpression)new ExpressionCompiler(this.globalFunctionsString).compile()));
    }

    @Override
    public <T> T evaluate(String expression) {
        MVELExpressionLanguageContext factory = this.createExpressionLanguageContext();
        factory.appendFactory(this.createGlobalVariableResolverFactory(factory));
        return this.evaluateInternal(expression, factory);
    }

    @Override
    public <T> T evaluate(String expression, Map<String, Object> vars) {
        MVELExpressionLanguageContext factory = this.createExpressionLanguageContext();
        if (vars != null) {
            factory.appendFactory((VariableResolverFactory)new CachedMapVariableResolverFactory(vars));
        }
        factory.appendFactory(this.createGlobalVariableResolverFactory(factory));
        return this.evaluateInternal(expression, factory);
    }

    @Override
    public <T> T evaluate(String expression, MuleEvent event) {
        return this.evaluate(expression, event, null);
    }

    @Override
    public <T> T evaluate(String expression, MuleEvent event, Map<String, Object> vars) {
        MVELExpressionLanguageContext factory = this.createExpressionLanguageContext();
        if (vars != null) {
            factory.appendFactory((VariableResolverFactory)new CachedMapVariableResolverFactory(vars));
        }
        factory.appendFactory(this.createEventVariableResolverFactory(event));
        factory.appendFactory(this.createGlobalVariableResolverFactory(factory));
        if (this.autoResolveVariables) {
            factory.localFactory.appendFactory(this.createVariableVariableResolverFactory(event));
        }
        factory.addPrivateVariable("_muleMessage", event.getMessage());
        return this.evaluateInternal(expression, factory);
    }

    @Override
    @Deprecated
    public <T> T evaluate(String expression, MuleMessage message) {
        MVELExpressionLanguageContext factory = this.createExpressionLanguageContext();
        factory.appendFactory(this.createMessageVariableResolverFactory(message));
        factory.appendFactory(this.createGlobalVariableResolverFactory(factory));
        if (this.autoResolveVariables) {
            factory.localFactory.appendFactory(this.createVariableVariableResolverFactory(message));
        }
        factory.addPrivateVariable("_muleMessage", message);
        return this.evaluateInternal(expression, factory);
    }

    @Override
    @Deprecated
    public <T> T evaluate(String expression, MuleMessage message, Map<String, Object> vars) {
        MVELExpressionLanguageContext factory = this.createExpressionLanguageContext();
        if (vars != null) {
            factory.appendFactory((VariableResolverFactory)new CachedMapVariableResolverFactory(vars));
        }
        factory.appendFactory(this.createMessageVariableResolverFactory(message));
        factory.appendFactory(this.createGlobalVariableResolverFactory(factory));
        if (this.autoResolveVariables) {
            factory.localFactory.appendFactory(this.createVariableVariableResolverFactory(message));
        }
        factory.addPrivateVariable("_muleMessage", message);
        return this.evaluateInternal(expression, factory);
    }

    protected <T> T evaluateInternal(String expression, MVELExpressionLanguageContext variableResolverFactory) {
        this.validate(expression);
        if (expression.startsWith("#[")) {
            expression = expression.substring(2, expression.length() - 1);
        }
        try {
            return (T)this.expressionExecutor.execute(expression, variableResolverFactory);
        }
        catch (Exception e) {
            throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(expression), (Throwable)e);
        }
    }

    @Override
    public boolean isValid(String expression) {
        try {
            this.validate(expression);
            return true;
        }
        catch (InvalidExpressionException e) {
            return false;
        }
    }

    @Override
    public void validate(String expression) throws InvalidExpressionException {
        if (expression.startsWith("#[")) {
            if (!expression.endsWith("]")) {
                throw new InvalidExpressionException(expression, "Expression string is not an expression");
            }
            expression = expression.substring(2, expression.length() - 1);
        }
        try {
            this.expressionExecutor.validate(expression);
        }
        catch (CompileException e) {
            throw new InvalidExpressionException(expression, e.getMessage());
        }
    }

    protected MVELExpressionLanguageContext createExpressionLanguageContext() {
        MVELExpressionLanguageContext factory = new MVELExpressionLanguageContext(this.parserContext.createSubcontext(), this.muleContext);
        factory.appendFactory((VariableResolverFactory)new MVELExpressionLanguageContext(this.staticContext));
        factory.addPrivateVariable("_muleContext", this.muleContext);
        return factory;
    }

    protected ParserContext createParserContext() {
        ParserContext parserContext = new ParserContext();
        this.configureParserContext(parserContext);
        return parserContext;
    }

    protected void configureParserContext(ParserContext parserContext) {
        parserContext.getParserConfiguration().setClassLoader(null);
        parserContext.addPackageImport("java.io");
        parserContext.addPackageImport("java.lang");
        parserContext.addPackageImport("java.net");
        parserContext.addPackageImport("java.util");
        parserContext.addImport(BigDecimal.class);
        parserContext.addImport(BigInteger.class);
        parserContext.addImport(DataHandler.class);
        parserContext.addImport(MimeType.class);
        parserContext.addImport(Pattern.class);
        parserContext.addImport(DataType.class);
        parserContext.addImport(DataTypeFactory.class);
        parserContext.addImport(NullPayload.class);
    }

    public void setGlobalFunctionsString(String globalFunctionsString) {
        this.globalFunctionsString = globalFunctionsString;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    public void setImports(Map<String, Class<?>> imports) {
        this.imports = imports;
    }

    public void setAutoResolveVariables(boolean autoResolveVariables) {
        this.autoResolveVariables = autoResolveVariables;
    }

    public void addGlobalFunction(String name, Function function) {
        this.globalFunctions.put(name, function);
    }

    public void addImport(String name, Class<?> clazz) {
        this.imports.put(name, clazz);
    }

    public void addAlias(String name, String expression) {
        this.aliases.put(name, expression);
    }

    public void setGlobalFunctionsFile(String globalFunctionsFile) {
        this.globalFunctionsFile = globalFunctionsFile;
    }

    protected VariableResolverFactory createGlobalVariableResolverFactory(MVELExpressionLanguageContext context) {
        return new GlobalVariableResolverFactory(this, context, this.parserContext, this.muleContext, this.expressionLanguageExtensions);
    }

    protected VariableResolverFactory createEventVariableResolverFactory(MuleEvent event) {
        return new EventVariableResolverFactory(this.parserContext, this.muleContext, event);
    }

    @Deprecated
    protected VariableResolverFactory createMessageVariableResolverFactory(MuleMessage message) {
        return new MessageVariableResolverFactory(this.parserContext, this.muleContext, message);
    }

    protected VariableResolverFactory createVariableVariableResolverFactory(MuleEvent event) {
        return new VariableVariableResolverFactory(this.parserContext, this.muleContext, event);
    }

    @Deprecated
    protected VariableResolverFactory createVariableVariableResolverFactory(MuleMessage message) {
        return new VariableVariableResolverFactory(this.parserContext, this.muleContext, message);
    }
}

