/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.mule.MessageExchangePattern;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.EndpointMessageProcessorChainFactory;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transport.Connector;
import org.mule.endpoint.AbstractEndpoint;
import org.mule.processor.AbstractRedeliveryPolicy;
import org.mule.transport.AbstractConnector;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

public class DefaultOutboundEndpoint
extends AbstractEndpoint
implements OutboundEndpoint {
    private static final long serialVersionUID = 8860985949279708638L;
    private MessagingExceptionHandler exceptionHandler;
    private List<String> responseProperties;

    public DefaultOutboundEndpoint(Connector connector, EndpointURI endpointUri, String name, Map properties, TransactionConfig transactionConfig, boolean deleteUnacceptedMessage, MessageExchangePattern messageExchangePattern, int responseTimeout, String initialState, String endpointEncoding, String endpointBuilderName, MuleContext muleContext, RetryPolicyTemplate retryPolicyTemplate, AbstractRedeliveryPolicy redeliveryPolicy, String responsePropertiesList, EndpointMessageProcessorChainFactory messageProcessorsFactory, List<MessageProcessor> messageProcessors, List<MessageProcessor> responseMessageProcessors, boolean disableTransportTransformer, String endpointMimeType) {
        this(connector, endpointUri, name, properties, transactionConfig, deleteUnacceptedMessage, messageExchangePattern, responseTimeout, initialState, endpointEncoding, endpointBuilderName, muleContext, retryPolicyTemplate, redeliveryPolicy, responsePropertiesList, messageProcessorsFactory, messageProcessors, responseMessageProcessors, disableTransportTransformer, endpointMimeType, null);
    }

    public DefaultOutboundEndpoint(Connector connector, EndpointURI endpointUri, String name, Map properties, TransactionConfig transactionConfig, boolean deleteUnacceptedMessage, MessageExchangePattern messageExchangePattern, int responseTimeout, String initialState, String endpointEncoding, String endpointBuilderName, MuleContext muleContext, RetryPolicyTemplate retryPolicyTemplate, AbstractRedeliveryPolicy redeliveryPolicy, String responsePropertiesList, EndpointMessageProcessorChainFactory messageProcessorsFactory, List<MessageProcessor> messageProcessors, List<MessageProcessor> responseMessageProcessors, boolean disableTransportTransformer, String endpointMimeType, MessagingExceptionHandler exceptionHandler) {
        super(connector, endpointUri, name, properties, transactionConfig, deleteUnacceptedMessage, messageExchangePattern, responseTimeout, initialState, endpointEncoding, endpointBuilderName, muleContext, retryPolicyTemplate, null, messageProcessorsFactory, messageProcessors, responseMessageProcessors, disableTransportTransformer, endpointMimeType);
        this.exceptionHandler = exceptionHandler;
        if (redeliveryPolicy != null) {
            logger.warn((Object)("Ignoring redelivery policy set on outbound endpoint " + endpointUri));
        }
        this.responseProperties = new ArrayList<String>();
        this.responseProperties.add("MULE_CORRELATION_ID");
        this.responseProperties.add("MULE_CORRELATION_GROUP_SIZE");
        this.responseProperties.add("MULE_CORRELATION_SEQUENCE");
        this.responseProperties.add("MULE_SESSION");
        String[] props = StringUtils.splitAndTrim(responsePropertiesList, ",");
        if (props != null) {
            this.responseProperties.addAll(Arrays.asList(props));
        }
    }

    @Override
    public List<String> getResponseProperties() {
        return this.responseProperties;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleEvent result = this.getMessageProcessorChain(event.getFlowConstruct()).process(event);
        if (!this.getExchangePattern().hasResponse()) {
            return VoidMuleEvent.getInstance();
        }
        return result;
    }

    @Override
    protected MessageProcessor createMessageProcessorChain(FlowConstruct flowConstruct) throws MuleException {
        EndpointMessageProcessorChainFactory factory = this.getMessageProcessorsFactory();
        MessagingExceptionHandler flowConstructExceptionListener = flowConstruct != null ? flowConstruct.getExceptionListener() : null;
        MessagingExceptionHandler exceptionHandler = this.exceptionHandler != null ? this.exceptionHandler : flowConstructExceptionListener;
        MessageProcessor chain = factory.createOutboundMessageProcessorChain(this, flowConstruct, ((AbstractConnector)this.getConnector()).createDispatcherMessageProcessor(this, exceptionHandler));
        if (chain instanceof MuleContextAware) {
            ((MuleContextAware)((Object)chain)).setMuleContext(this.getMuleContext());
        }
        if (chain instanceof FlowConstructAware) {
            ((FlowConstructAware)((Object)chain)).setFlowConstruct(flowConstruct);
        }
        if (chain instanceof Initialisable) {
            ((Initialisable)((Object)chain)).initialise();
        }
        return chain;
    }

    @Override
    public int hashCode() {
        if (this.exceptionHandler == null) {
            return super.hashCode();
        }
        return super.hashCode() + ClassUtils.hash(new Object[]{this.exceptionHandler});
    }
}

