/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transaction.TransactionException;
import org.mule.execution.ExecutionInterceptor;
import org.mule.transaction.TransactionCoordination;

class BeginAndResolveTransactionInterceptor<T>
implements ExecutionInterceptor<T> {
    private static final Log logger = LogFactory.getLog(BeginAndResolveTransactionInterceptor.class);
    private final ExecutionInterceptor<T> next;
    private final TransactionConfig transactionConfig;
    private final MuleContext muleContext;
    private final boolean processOnException;
    private boolean mustResolveAnyTransaction;

    BeginAndResolveTransactionInterceptor(ExecutionInterceptor next, TransactionConfig transactionConfig, MuleContext muleContext, boolean processOnException, boolean mustResolveAnyTransaction) {
        this.next = next;
        this.transactionConfig = transactionConfig;
        this.muleContext = muleContext;
        this.processOnException = processOnException;
        this.mustResolveAnyTransaction = mustResolveAnyTransaction;
    }

    @Override
    public T execute(ExecutionCallback<T> callback) throws Exception {
        byte action = this.transactionConfig.getAction();
        int timeout = this.transactionConfig.getTimeout();
        boolean resolveStartedTransaction = false;
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (action == 1 || action == 2 && tx == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Beginning transaction");
            }
            tx = this.transactionConfig.getFactory().beginTransaction(this.muleContext);
            tx.setTimeout(timeout);
            resolveStartedTransaction = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Transaction successfully started: " + tx));
            }
        }
        try {
            T result = this.next.execute(callback);
            this.resolveTransactionIfRequired(resolveStartedTransaction);
            return result;
        }
        catch (MessagingException e) {
            if (this.processOnException) {
                this.resolveTransactionIfRequired(resolveStartedTransaction || this.mustResolveAnyTransaction);
            }
            throw e;
        }
    }

    private void resolveTransactionIfRequired(boolean mustResolveTransaction) throws TransactionException {
        Transaction transaction = TransactionCoordination.getInstance().getTransaction();
        if (mustResolveTransaction && transaction != null) {
            TransactionCoordination.getInstance().resolveTransaction();
        }
    }
}

