/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.AbstractRoutingStrategy;
import org.mule.routing.IdentifiableDynamicRouteResolver;
import org.mule.routing.RoutingFailedMessagingException;

public class RoundRobinRoutingStrategy
extends AbstractRoutingStrategy {
    private final IdentifiableDynamicRouteResolver identifiableDynamicRouteResolver;
    private Map<String, Short> roundRobinState = new HashMap<String, Short>();

    public RoundRobinRoutingStrategy(MuleContext muleContext, IdentifiableDynamicRouteResolver identifiableDynamicRouteResolver) {
        super(muleContext);
        this.identifiableDynamicRouteResolver = identifiableDynamicRouteResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MuleEvent route(MuleEvent event, List<MessageProcessor> messageProcessors) throws MessagingException {
        if (messageProcessors == null || messageProcessors.isEmpty()) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), event, null);
        }
        String id = this.identifiableDynamicRouteResolver.getRouteIdentifier(event);
        Short nextMessageProcessor = 0;
        RoundRobinRoutingStrategy roundRobinRoutingStrategy = this;
        synchronized (roundRobinRoutingStrategy) {
            if (this.roundRobinState.containsKey(id)) {
                Short lastMessageProcessor = this.roundRobinState.get(id);
                nextMessageProcessor = (short)(lastMessageProcessor + 1 >= messageProcessors.size() ? 0 : lastMessageProcessor + 1);
                this.roundRobinState.put(id, nextMessageProcessor);
            } else {
                this.roundRobinState.put(id, (short)0);
            }
        }
        MessageProcessor mp = messageProcessors.get(nextMessageProcessor.shortValue());
        MuleEvent eventCopy = this.cloneEventForRouting(event, mp);
        try {
            return mp.process(eventCopy);
        }
        catch (MuleException me) {
            throw new RoutingFailedMessagingException(CoreMessages.createStaticMessage("Error processing event"), event, (Throwable)me);
        }
    }

    private MuleEvent cloneEventForRouting(MuleEvent event, MessageProcessor mp) throws MessagingException {
        return this.createEventToRoute(event, RoundRobinRoutingStrategy.cloneMessage(event, event.getMessage(), this.getMuleContext()), mp);
    }
}

