/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.io.OutputStream;
import java.util.List;
import org.apache.commons.lang.SerializationException;
import org.mule.DefaultMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.ResponseOutputStream;
import org.mule.VoidMuleEvent;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.execution.ExecutionTemplate;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.FilterUnacceptedException;
import org.mule.api.transaction.Transaction;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.PropertyScope;
import org.mule.api.transport.ReplyToHandler;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.execution.MessageProcessContext;
import org.mule.execution.MessageProcessTemplate;
import org.mule.execution.MessageProcessingManager;
import org.mule.execution.TransactionalErrorHandlingExecutionTemplate;
import org.mule.lifecycle.PrimaryNodeLifecycleNotificationListener;
import org.mule.session.DefaultMuleSession;
import org.mule.session.LegacySessionHandler;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.AbstractConnector;
import org.mule.transport.AbstractTransportMessageHandler;
import org.mule.transport.ConnectableLifecycleManager;
import org.mule.transport.TrackingWorkManager;
import org.mule.transport.WorkManagerHolder;
import org.mule.util.ClassUtils;
import org.mule.util.ObjectUtils;

public abstract class AbstractMessageReceiver
extends AbstractTransportMessageHandler
implements MessageReceiver {
    protected FlowConstruct flowConstruct;
    protected MessageProcessor listener;
    protected String receiverKey = null;
    private EndpointURI endpointUri;
    protected List<Transformer> defaultInboundTransformers;
    protected List<Transformer> defaultResponseTransformers;
    protected ReplyToHandler replyToHandler;
    private PrimaryNodeLifecycleNotificationListener primaryNodeLifecycleNotificationListener;
    private MessageProcessingManager messageProcessingManager;
    private WorkManager messageReceiverWorkManager;

    public AbstractMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(endpoint);
        if (flowConstruct == null) {
            throw new IllegalArgumentException("FlowConstruct cannot be null");
        }
        this.flowConstruct = flowConstruct;
        this.messageReceiverWorkManager = this.createWorkManager();
    }

    protected ConnectableLifecycleManager createLifecycleManager() {
        return new ConnectableLifecycleManager<AbstractMessageReceiver>(this.getReceiverKey(), this);
    }

    @Override
    public final void initialise() throws InitialisationException {
        this.endpointUri = this.endpoint.getEndpointURI();
        this.defaultInboundTransformers = this.connector.getDefaultInboundTransformers(this.endpoint);
        this.defaultResponseTransformers = this.connector.getDefaultResponseTransformers(this.endpoint);
        this.replyToHandler = this.getReplyToHandler();
        if (!this.shouldConsumeInEveryNode() && !this.flowConstruct.getMuleContext().isPrimaryPollingInstance()) {
            this.primaryNodeLifecycleNotificationListener = new PrimaryNodeLifecycleNotificationListener(new Startable(){

                @Override
                public void start() throws MuleException {
                    if (AbstractMessageReceiver.this.isStarted()) {
                        try {
                            AbstractMessageReceiver.this.doConnect();
                        }
                        catch (Exception e) {
                            throw new DefaultMuleException(e);
                        }
                        AbstractMessageReceiver.this.doStart();
                    }
                }
            }, this.flowConstruct.getMuleContext());
            this.primaryNodeLifecycleNotificationListener.register();
        }
        this.messageProcessingManager = (MessageProcessingManager)this.getConnector().getMuleContext().getRegistry().get("_muleMessageProcessingManager");
        super.initialise();
    }

    @Override
    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public final MuleEvent routeMessage(MuleMessage message) throws MuleException {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        return this.routeMessage(message, tx, null);
    }

    @Override
    public final MuleEvent routeMessage(MuleMessage message, Transaction trans) throws MuleException {
        return this.routeMessage(message, trans, null);
    }

    @Override
    public final MuleEvent routeMessage(MuleMessage message, Transaction trans, OutputStream outputStream) throws MuleException {
        return this.routeMessage(message, new DefaultMuleSession(), trans, outputStream);
    }

    public final MuleEvent routeMessage(MuleMessage message, MuleSession session, Transaction trans, OutputStream outputStream) throws MuleException {
        return this.routeMessage(message, session, outputStream);
    }

    public final MuleEvent routeMessage(MuleMessage message, MuleSession session, OutputStream outputStream) throws MuleException {
        this.warnIfMuleClientSendUsed(message);
        this.propagateRootMessageIdProperty(message);
        MuleEvent muleEvent = this.createMuleEvent(message, outputStream);
        if (!this.endpoint.isDisableTransportTransformer()) {
            this.applyInboundTransformers(muleEvent);
        }
        return this.routeEvent(muleEvent);
    }

    protected void propagateRootMessageIdProperty(MuleMessage message) {
        String rootId = (String)message.getInboundProperty("MULE_ROOT_MESSAGE_ID");
        if (rootId != null) {
            message.setMessageRootId(rootId);
            message.removeProperty("MULE_ROOT_MESSAGE_ID", PropertyScope.INBOUND);
        }
    }

    protected void warnIfMuleClientSendUsed(MuleMessage message) {
        Object remoteSyncProperty = message.removeProperty("MULE_REMOTE_SYNC", PropertyScope.INBOUND);
        if (ObjectUtils.getBoolean(remoteSyncProperty, false) && !this.endpoint.getExchangePattern().hasResponse()) {
            this.logger.warn((Object)("MuleClient.send() was used but inbound endpoint " + this.endpoint.getEndpointURI().getUri().toString() + " is not 'request-response'.  No response will be returned."));
        }
        message.removeProperty("MULE_REMOTE_SYNC", PropertyScope.INBOUND);
    }

    protected void applyInboundTransformers(MuleEvent event) throws MuleException {
        event.getMessage().applyTransformers(event, this.defaultInboundTransformers);
    }

    protected void applyResponseTransformers(MuleEvent event) throws MuleException {
        event.getMessage().applyTransformers(event, this.defaultResponseTransformers);
    }

    protected MuleMessage handleUnacceptedFilter(MuleMessage message) {
        if (this.logger.isDebugEnabled()) {
            String messageId = message.getUniqueId();
            this.logger.debug((Object)("Message " + messageId + " failed to pass filter on endpoint: " + this.endpoint + ". Message is being ignored"));
        }
        return message;
    }

    protected MuleEvent createMuleEvent(MuleMessage message, OutputStream outputStream) throws MuleException {
        MuleEvent event;
        MuleSession session;
        ResponseOutputStream ros = null;
        if (outputStream != null) {
            ros = outputStream instanceof ResponseOutputStream ? (ResponseOutputStream)outputStream : new ResponseOutputStream(outputStream);
        }
        try {
            session = this.connector.getSessionHandler().retrieveSessionInfoFromMessage(message);
        }
        catch (SerializationException se) {
            try {
                session = new LegacySessionHandler().retrieveSessionInfoFromMessage(message);
            }
            catch (Exception e) {
                throw se;
            }
        }
        if (session == null) {
            session = new DefaultMuleSession();
        }
        if (message.getReplyTo() != null) {
            event = new DefaultMuleEvent(message, this.getEndpoint(), this.flowConstruct, session, this.replyToHandler, message.getReplyTo(), ros);
            message.setReplyTo(null);
        } else {
            event = new DefaultMuleEvent(message, this.getEndpoint(), this.flowConstruct, session, null, null, ros);
        }
        event = OptimizedRequestContext.unsafeSetEvent(event);
        if (session.getSecurityContext() != null && session.getSecurityContext().getAuthentication() != null) {
            session.getSecurityContext().getAuthentication().setEvent(event);
        }
        return event;
    }

    @Override
    public EndpointURI getEndpointURI() {
        return this.endpointUri;
    }

    @Override
    public String getConnectionDescription() {
        return this.endpoint.getEndpointURI().toString();
    }

    protected String getConnectEventId() {
        return this.connector.getName() + ".receiver (" + this.endpoint.getEndpointURI() + ")";
    }

    @Override
    public void setReceiverKey(String receiverKey) {
        this.receiverKey = receiverKey;
    }

    @Override
    public String getReceiverKey() {
        return this.receiverKey;
    }

    @Override
    public InboundEndpoint getEndpoint() {
        return (InboundEndpoint)super.getEndpoint();
    }

    @Override
    public void setEndpoint(InboundEndpoint endpoint) {
        super.setEndpoint(endpoint);
    }

    @Override
    protected WorkManager getWorkManager() {
        return this.messageReceiverWorkManager;
    }

    private WorkManager getConnectorWorkManager() {
        try {
            return this.connector.getReceiverWorkManager();
        }
        catch (MuleException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", receiverKey=").append(this.receiverKey);
        sb.append(", endpoint=").append(this.endpoint.getEndpointURI());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void setListener(MessageProcessor processor) {
        this.listener = processor;
    }

    @Override
    protected void doDispose() {
        this.listener = null;
        this.flowConstruct = null;
        if (this.primaryNodeLifecycleNotificationListener != null) {
            this.primaryNodeLifecycleNotificationListener.unregister();
        }
        super.doDispose();
    }

    protected ReplyToHandler getReplyToHandler() {
        return ((AbstractConnector)this.endpoint.getConnector()).getReplyToHandler(this.endpoint);
    }

    protected ExecutionTemplate<MuleEvent> createExecutionTemplate() {
        return TransactionalErrorHandlingExecutionTemplate.createMainExecutionTemplate(this.endpoint.getMuleContext(), this.endpoint.getTransactionConfig());
    }

    public boolean shouldConsumeInEveryNode() {
        return true;
    }

    @Override
    protected final void connectHandler() throws Exception {
        if (this.shouldConsumeInEveryNode() || this.getFlowConstruct().getMuleContext().isPrimaryPollingInstance()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Connecting clusterizable message receiver");
            }
            this.doConnect();
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Clusterizable message receiver not connected on this node");
        }
    }

    @Override
    protected final void doStartHandler() throws MuleException {
        if (this.shouldConsumeInEveryNode() || this.getFlowConstruct().getMuleContext().isPrimaryPollingInstance()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Starting clusterizable message receiver");
            }
            if (this.messageReceiverWorkManager == null) {
                this.messageReceiverWorkManager = this.createWorkManager();
            }
            this.doStart();
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Clusterizable message receiver not started on this node");
        }
    }

    @Override
    protected void doStop() throws MuleException {
        super.doStop();
        if (this.messageReceiverWorkManager != null) {
            this.messageReceiverWorkManager.dispose();
            this.messageReceiverWorkManager = null;
        }
    }

    private WorkManager createWorkManager() {
        int shutdownTimeout = this.connector.getMuleContext().getConfiguration().getShutdownTimeout();
        return new TrackingWorkManager(new WorkManagerHolder(){

            @Override
            public WorkManager getWorkManager() {
                return AbstractMessageReceiver.this.getConnectorWorkManager();
            }
        }, shutdownTimeout);
    }

    public MuleEvent routeEvent(MuleEvent muleEvent) throws MuleException {
        MuleEvent resultEvent = this.listener.process(muleEvent);
        if (resultEvent != null && !VoidMuleEvent.getInstance().equals(resultEvent) && resultEvent.getMessage() != null && resultEvent.getMessage().getExceptionPayload() != null && resultEvent.getMessage().getExceptionPayload().getException() instanceof FilterUnacceptedException) {
            this.handleUnacceptedFilter(muleEvent.getMessage());
            return muleEvent;
        }
        if (this.endpoint.getExchangePattern().hasResponse() && resultEvent != null && !VoidMuleEvent.getInstance().equals(resultEvent)) {
            DefaultMuleSession resultSession = new DefaultMuleSession(resultEvent.getSession());
            resultSession.setSecurityContext(null);
            this.connector.getSessionHandler().storeSessionInfoToMessage(resultSession, resultEvent.getMessage());
            if (resultEvent.getMessage() != null && !this.endpoint.isDisableTransportTransformer()) {
                this.applyResponseTransformers(resultEvent);
            }
            if (this.connector.isEnableMessageEvents()) {
                this.connector.fireNotification(new EndpointMessageNotification(resultEvent.getMessage(), this.endpoint, resultEvent.getFlowConstruct(), 805));
            }
            return resultEvent;
        }
        return null;
    }

    protected void processMessage(MessageProcessTemplate messageProcessTemplate, MessageProcessContext messageProcessContext) {
        this.messageProcessingManager.processMessage(messageProcessTemplate, messageProcessContext);
    }
}

