/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.PollingReceiverWorker;
import org.mule.transport.PollingReceiverWorkerSchedule;
import org.mule.util.ObjectUtils;

public abstract class AbstractPollingMessageReceiver
extends AbstractMessageReceiver {
    public static final long DEFAULT_POLL_FREQUENCY = 1000L;
    public static final TimeUnit DEFAULT_POLL_TIMEUNIT = TimeUnit.MILLISECONDS;
    public static final long DEFAULT_STARTUP_DELAY = 1000L;
    private long frequency = 1000L;
    private TimeUnit timeUnit = DEFAULT_POLL_TIMEUNIT;
    protected final Map<ScheduledFuture, PollingReceiverWorker> schedules = new HashMap<ScheduledFuture, PollingReceiverWorker>();

    public AbstractPollingMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
    }

    @Override
    protected void doStart() throws MuleException {
        try {
            this.schedule();
        }
        catch (Exception ex) {
            this.stop();
            throw new CreateException(CoreMessages.failedToScheduleWork(), ex, this);
        }
    }

    @Override
    protected void doStop() throws MuleException {
        super.doStop();
        this.unschedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule() throws RejectedExecutionException, NullPointerException, IllegalArgumentException {
        Map<ScheduledFuture, PollingReceiverWorker> map = this.schedules;
        synchronized (map) {
            PollingReceiverWorker pollingReceiverWorker = this.createWork();
            ScheduledFuture<?> schedule = this.connector.getScheduler().scheduleWithFixedDelay(new PollingReceiverWorkerSchedule(pollingReceiverWorker), 1000L, this.getFrequency(), this.getTimeUnit());
            this.schedules.put(schedule, pollingReceiverWorker);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(ObjectUtils.identityToShortString(this) + " scheduled " + ObjectUtils.identityToShortString(schedule) + " with " + this.frequency + " " + (Object)((Object)this.getTimeUnit()) + " polling frequency"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unschedule() {
        Map<ScheduledFuture, PollingReceiverWorker> map = this.schedules;
        synchronized (map) {
            Iterator<ScheduledFuture> i = this.schedules.keySet().iterator();
            while (i.hasNext()) {
                ScheduledFuture schedule = i.next();
                schedule.cancel(false);
                int shutdownTimeout = this.connector.getMuleContext().getConfiguration().getShutdownTimeout();
                PollingReceiverWorker worker = this.schedules.get(schedule);
                for (int elapsed = 0; worker.isRunning() && elapsed < shutdownTimeout; elapsed += 50) {
                    try {
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        this.logger.warn((Object)(ObjectUtils.identityToShortString(this) + "  interrupted while waiting for poll() to complete as part of message receiver stop."), (Throwable)e);
                        break;
                    }
                }
                i.remove();
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)(ObjectUtils.identityToShortString(this) + " cancelled polling schedule: " + ObjectUtils.identityToShortString(schedule)));
            }
        }
    }

    public void disableNativeScheduling() {
        this.unschedule();
    }

    protected PollingReceiverWorker createWork() {
        return new PollingReceiverWorker(this);
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long value) {
        this.frequency = value <= 0L ? 1000L : value;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    protected int getBatchSize(int available) {
        if (available <= 0) {
            return 0;
        }
        int maxThreads = this.connector.getReceiverThreadingProfile().getMaxThreadsActive();
        return Math.max(1, Math.min(available, maxThreads / 2 - 1));
    }

    public final void performPoll() throws Exception {
        if (!this.pollOnPrimaryInstanceOnly() || this.flowConstruct.getMuleContext().isPrimaryPollingInstance()) {
            this.poll();
        }
    }

    protected boolean pollOnPrimaryInstanceOnly() {
        return false;
    }

    protected abstract void poll() throws Exception;
}

