/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.MuleException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.MessageRequester;
import org.mule.api.transport.MessageRequesterFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractConnector;

public class KeyedPoolMessageRequesterFactoryAdapter
implements MessageRequesterFactory,
KeyedPoolableObjectFactory {
    private final MessageRequesterFactory factory;

    public KeyedPoolMessageRequesterFactoryAdapter(MessageRequesterFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("factory").toString());
        }
        this.factory = factory;
    }

    public void activateObject(Object key, Object obj) throws Exception {
        this.applyLifecycle((MessageRequester)obj, false);
        this.factory.activate((InboundEndpoint)key, (MessageRequester)obj);
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        this.factory.destroy((InboundEndpoint)key, (MessageRequester)obj);
    }

    public Object makeObject(Object key) throws Exception {
        MessageRequester obj = this.factory.create((InboundEndpoint)key);
        this.applyLifecycle(obj, true);
        return obj;
    }

    public void passivateObject(Object key, Object obj) throws Exception {
        this.factory.passivate((InboundEndpoint)key, (MessageRequester)obj);
    }

    public boolean validateObject(Object key, Object obj) {
        return this.factory.validate((InboundEndpoint)key, (MessageRequester)obj);
    }

    @Override
    public boolean isCreateRequesterPerRequest() {
        return this.factory.isCreateRequesterPerRequest();
    }

    @Override
    public MessageRequester create(InboundEndpoint endpoint) throws MuleException {
        return this.factory.create(endpoint);
    }

    @Override
    public void activate(InboundEndpoint endpoint, MessageRequester requester) throws MuleException {
        this.factory.activate(endpoint, requester);
    }

    @Override
    public void destroy(InboundEndpoint endpoint, MessageRequester requester) {
        this.factory.destroy(endpoint, requester);
    }

    @Override
    public void passivate(InboundEndpoint endpoint, MessageRequester requester) {
        this.factory.passivate(endpoint, requester);
    }

    @Override
    public boolean validate(InboundEndpoint endpoint, MessageRequester requester) {
        return this.factory.validate(endpoint, requester);
    }

    protected void applyLifecycle(MessageRequester requester, boolean created) throws MuleException {
        String phase = ((AbstractConnector)requester.getConnector()).getLifecycleManager().getCurrentPhase();
        if (phase.equals("start") && !requester.getLifecycleState().isStarted()) {
            if (!requester.getLifecycleState().isInitialised()) {
                requester.initialise();
            }
            requester.start();
        } else if (phase.equals("stop") && requester.getLifecycleState().isStarted()) {
            requester.stop();
        } else if ("dispose".equals(phase)) {
            requester.dispose();
        }
    }
}

