/*
 * Decompiled with CFR 0.152.
 */
package org.mule.work;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.WorkManager;
import org.mule.api.work.WorkExecutor;
import org.mule.config.ImmutableThreadingProfile;
import org.mule.work.ScheduleWorkExecutor;
import org.mule.work.StartWorkExecutor;
import org.mule.work.SyncWorkExecutor;
import org.mule.work.WorkerContext;

public class MuleWorkManager
implements WorkManager,
MuleContextAware {
    protected static final Log logger = LogFactory.getLog(MuleWorkManager.class);
    private static final long FORCEFUL_SHUTDOWN_TIMEOUT = 5000L;
    private final ThreadingProfile threadingProfile;
    private volatile ExecutorService workExecutorService;
    private final String name;
    private int gracefulShutdownTimeout;
    private MuleContext muleContext;
    private final WorkExecutor scheduleWorkExecutor = new ScheduleWorkExecutor();
    private final WorkExecutor startWorkExecutor = new StartWorkExecutor();
    private final WorkExecutor syncWorkExecutor = new SyncWorkExecutor();

    public MuleWorkManager(ThreadingProfile profile, String name, int shutdownTimeout) {
        if (name == null) {
            name = "WorkManager#" + this.hashCode();
        }
        this.threadingProfile = new ImmutableThreadingProfile(profile);
        this.name = name;
        this.gracefulShutdownTimeout = shutdownTimeout;
    }

    @Override
    public synchronized void start() throws MuleException {
        this.gracefulShutdownTimeout = this.getMuleContext().getConfiguration().getShutdownTimeout();
        if (this.workExecutorService == null) {
            this.workExecutorService = this.threadingProfile.createPool(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void dispose() {
        if (this.workExecutorService != null) {
            this.workExecutorService.shutdown();
            try {
                if (!this.workExecutorService.awaitTermination(this.gracefulShutdownTimeout, TimeUnit.MILLISECONDS)) {
                    List<Runnable> outstanding = this.workExecutorService.shutdownNow();
                    if (!this.workExecutorService.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                        logger.warn((Object)MessageFormat.format("Pool {0} did not terminate in time; {1} work items were cancelled.", this.name, outstanding.isEmpty() ? "No" : Integer.toString(outstanding.size())));
                    } else if (!outstanding.isEmpty()) {
                        logger.warn((Object)MessageFormat.format("Pool {0} terminated; {1} work items were cancelled.", this.name, Integer.toString(outstanding.size())));
                    }
                }
            }
            catch (InterruptedException ie) {
                this.workExecutorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
            finally {
                this.workExecutorService = null;
            }
        }
    }

    public XATerminator getXATerminator() {
        return null;
    }

    public void doWork(Work work) throws WorkException {
        this.executeWork(new WorkerContext(work), this.syncWorkExecutor);
    }

    public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.syncWorkExecutor);
    }

    public long startWork(Work work) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.startWorkExecutor);
        return System.currentTimeMillis() - workWrapper.getAcceptedTime();
    }

    public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.startWorkExecutor);
        return System.currentTimeMillis() - workWrapper.getAcceptedTime();
    }

    public void scheduleWork(Work work) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.scheduleWorkExecutor);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.scheduleWorkExecutor);
    }

    @Override
    public void execute(Runnable work) {
        if (!this.isStarted()) {
            throw new IllegalStateException("This MuleWorkManager '" + this.name + "' is stopped");
        }
        this.workExecutorService.execute(work);
    }

    private void executeWork(WorkerContext work, WorkExecutor workExecutor) throws WorkException {
        if (!this.isStarted()) {
            throw new IllegalStateException("This MuleWorkManager '" + this.name + "' is stopped");
        }
        try {
            work.workAccepted(this);
            workExecutor.doExecute(work, this.workExecutorService);
            WorkException exception = work.getWorkException();
            if (null != exception) {
                throw exception;
            }
        }
        catch (InterruptedException e) {
            WorkCompletedException wcj = new WorkCompletedException("The execution has been interrupted for WorkManager: " + this.name, (Throwable)e);
            wcj.setErrorCode("-1");
            throw wcj;
        }
    }

    @Override
    public boolean isStarted() {
        return this.workExecutorService != null && !this.workExecutorService.isShutdown();
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
        if (this.threadingProfile != null && muleContext != null) {
            this.threadingProfile.setMuleContext(muleContext);
        }
    }

    protected ThreadingProfile getThreadingProfile() {
        return this.threadingProfile;
    }
}

