/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.mule.DefaultMuleMessage;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.execution.ExecutionTemplate;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.api.transport.PropertyScope;
import org.mule.construct.Flow;
import org.mule.processor.strategy.SynchronousProcessingStrategy;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.ConnectException;
import org.mule.transport.file.FileConnector;
import org.mule.transport.file.FileContentsMuleMessageFactory;
import org.mule.transport.file.InputStreamCloseListener;
import org.mule.transport.file.ReceiverFileInputStream;
import org.mule.transport.file.i18n.FileMessages;
import org.mule.util.FileUtils;
import org.mule.util.lock.LockFactory;

public class FileMessageReceiver
extends AbstractPollingMessageReceiver {
    public static final String COMPARATOR_CLASS_NAME_PROPERTY = "comparator";
    public static final String COMPARATOR_REVERSE_ORDER_PROPERTY = "reverseOrder";
    public static final String MULE_TRANSPORT_FILE_SINGLEPOLLINSTANCE = "mule.transport.file.singlepollinstance";
    private static final List<File> NO_FILES = new ArrayList<File>();
    private FileConnector fileConnector = null;
    private String readDir = null;
    private String moveDir = null;
    private String workDir = null;
    private File readDirectory = null;
    private File moveDirectory = null;
    private String moveToPattern = null;
    private String workFileNamePattern = null;
    private FilenameFilter filenameFilter = null;
    private FileFilter fileFilter = null;
    private boolean forceSync;
    private LockFactory lockFactory;
    private boolean poolOnPrimaryInstanceOnly;
    private ObjectStore<String> filesBeingProcessingObjectStore;

    public FileMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint, String readDir, String moveDir, String moveToPattern, long frequency) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.fileConnector = (FileConnector)connector;
        this.setFrequency(frequency);
        this.readDir = readDir;
        this.moveDir = moveDir;
        this.moveToPattern = moveToPattern;
        this.workDir = this.fileConnector.getWorkDirectory();
        this.workFileNamePattern = this.fileConnector.getWorkFileNamePattern();
        if (endpoint.getFilter() instanceof FilenameFilter) {
            this.filenameFilter = (FilenameFilter)endpoint.getFilter();
        } else if (endpoint.getFilter() instanceof FileFilter) {
            this.fileFilter = (FileFilter)endpoint.getFilter();
        } else if (endpoint.getFilter() != null) {
            throw new CreateException(FileMessages.invalidFileFilter(endpoint.getEndpointURI()), (Object)this);
        }
        this.checkMustForceSync();
    }

    protected void checkMustForceSync() throws CreateException {
        boolean connectorIsAutoDelete = false;
        boolean isStreaming = false;
        if (this.connector instanceof FileConnector) {
            connectorIsAutoDelete = this.fileConnector.isAutoDelete();
            isStreaming = this.fileConnector.isStreaming();
        }
        boolean messageFactoryConsumes = this.createMuleMessageFactory() instanceof FileContentsMuleMessageFactory;
        this.forceSync = connectorIsAutoDelete && !messageFactoryConsumes && !isStreaming;
    }

    protected void doInitialise() throws InitialisationException {
        this.lockFactory = this.getConnector().getMuleContext().getLockFactory();
        boolean synchronousProcessing = false;
        if (this.getFlowConstruct() instanceof Flow) {
            synchronousProcessing = ((Flow)this.getFlowConstruct()).getProcessingStrategy() instanceof SynchronousProcessingStrategy;
        }
        this.poolOnPrimaryInstanceOnly = Boolean.valueOf(System.getProperty(MULE_TRANSPORT_FILE_SINGLEPOLLINSTANCE, "false")) != false || !synchronousProcessing;
        ObjectStoreManager objectStoreManager = (ObjectStoreManager)this.getConnector().getMuleContext().getRegistry().get("_muleObjectStoreManager");
        this.filesBeingProcessingObjectStore = objectStoreManager.getObjectStore(this.getEndpoint().getName(), false, 1000, 60000, 20000);
    }

    protected void doConnect() throws Exception {
        if (this.readDir != null) {
            this.readDirectory = FileUtils.openDirectory((String)this.readDir);
            if (!this.readDirectory.canRead()) {
                throw new ConnectException(FileMessages.fileDoesNotExist(this.readDirectory.getAbsolutePath()), (Connectable)this);
            }
            this.logger.debug((Object)("Listening on endpointUri: " + this.readDirectory.getAbsolutePath()));
        }
        if (this.moveDir != null) {
            this.moveDirectory = FileUtils.openDirectory((String)this.moveDir);
            if (!this.moveDirectory.canRead() || !this.moveDirectory.canWrite()) {
                throw new ConnectException(FileMessages.moveToDirectoryNotWritable(), (Connectable)this);
            }
        }
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doDispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() {
        block12: {
            try {
                Comparator<File> comparator;
                List<File> files = this.listFiles();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Files: " + files.toString()));
                }
                if ((comparator = this.getComparator()) != null) {
                    Collections.sort(files, comparator);
                }
                for (File file : files) {
                    Lock fileLock;
                    block13: {
                        if (this.getLifecycleState().isStopping()) break block12;
                        if (!file.isFile() || !(fileLock = this.lockFactory.createLock(file.getName())).tryLock()) continue;
                        String fileAbsolutePath = file.getAbsolutePath();
                        try {
                            this.filesBeingProcessingObjectStore.store((Serializable)((Object)fileAbsolutePath), (Serializable)((Object)fileAbsolutePath));
                            if (!this.logger.isDebugEnabled()) break block13;
                            this.logger.debug((Object)String.format("Flag for '%s' stored successfully.", fileAbsolutePath));
                        }
                        catch (ObjectAlreadyExistsException e) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)String.format("Flag for '%s' being processed is on. Skipping file.", fileAbsolutePath));
                            }
                            fileLock.unlock();
                            continue;
                        }
                    }
                    try {
                        if (!file.exists()) continue;
                        this.processFile(file);
                    }
                    finally {
                        fileLock.unlock();
                    }
                }
            }
            catch (Exception e) {
                this.getConnector().getMuleContext().getExceptionListener().handleException(e);
            }
        }
    }

    protected boolean pollOnPrimaryInstanceOnly() {
        return this.poolOnPrimaryInstanceOnly;
    }

    public void processFile(File file) throws MuleException {
        File sourceFile;
        if (this.fileConnector.getCheckFileAge() && !this.isAgedFile(file, this.fileConnector.getFileAge())) {
            this.removeProcessingMark(file.getAbsolutePath());
            return;
        }
        if (!(file.canRead() && file.exists() && file.isFile())) {
            throw new DefaultMuleException(FileMessages.fileDoesNotExist(file.getName()));
        }
        if (!this.attemptFileLock(file)) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Lock obtained on file: " + file.getAbsolutePath()));
        }
        String originalSourceFilePath = file.getAbsolutePath();
        String originalSourceFileName = file.getName();
        String originalSourceDirectory = file.getParent();
        DefaultMuleMessage fileParserMessasge = new DefaultMuleMessage(null, this.getEndpoint().getMuleContext());
        fileParserMessasge.setOutboundProperty("originalFilename", (Object)originalSourceFileName);
        fileParserMessasge.setInboundProperty("originalDirectory", (Object)originalSourceDirectory);
        if (this.workDir != null) {
            String workFileName = this.fileConnector.getFilenameParser().getFilename((MuleMessage)fileParserMessasge, this.workFileNamePattern);
            File workFile = FileUtils.newFile((String)this.workDir, (String)workFileName);
            this.fileConnector.move(file, workFile);
            sourceFile = workFile;
        } else {
            sourceFile = file;
        }
        File destinationFile = null;
        if (this.moveDir != null) {
            String destinationFileName = originalSourceFileName;
            if (this.moveToPattern != null) {
                destinationFileName = this.fileConnector.getFilenameParser().getFilename((MuleMessage)fileParserMessasge, this.moveToPattern);
            }
            destinationFile = FileUtils.newFile((String)this.moveDir, (String)destinationFileName);
        }
        MuleMessage message = null;
        String encoding = this.endpoint.getEncoding();
        try {
            if (this.fileConnector.isStreaming()) {
                ReceiverFileInputStream payload = this.createReceiverFileInputStream(sourceFile, destinationFile, new InputStreamCloseListener(){

                    @Override
                    public void fileClose(File file) {
                        FileMessageReceiver.this.removeProcessingMark(file.getAbsolutePath());
                    }
                });
                message = this.createMuleMessage(payload, encoding);
            } else {
                message = this.createMuleMessage(sourceFile, encoding);
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"File being read disappeared!", (Throwable)e);
            return;
        }
        if (this.workDir != null) {
            message.setProperty("sourceDirectory", (Object)file.getParent(), PropertyScope.INBOUND);
            message.setProperty("sourceFileName", (Object)file.getName(), PropertyScope.INBOUND);
        }
        message.setOutboundProperty("originalFilename", (Object)originalSourceFileName);
        message.setProperty("originalDirectory", (Object)originalSourceDirectory, PropertyScope.INBOUND);
        if (this.forceSync) {
            message.setProperty("MULE_FORCE_SYNC", (Object)Boolean.TRUE, PropertyScope.INBOUND);
        }
        Object originalPayload = message.getPayload();
        ExecutionTemplate executionTemplate = this.createExecutionTemplate();
        MuleMessage finalMessage = message;
        if (this.fileConnector.isStreaming()) {
            this.processWithStreaming(sourceFile, (ReceiverFileInputStream)originalPayload, (ExecutionTemplate<MuleEvent>)executionTemplate, finalMessage);
        } else {
            this.processWithoutStreaming(originalSourceFilePath, originalSourceFileName, originalSourceDirectory, sourceFile, destinationFile, (ExecutionTemplate<MuleEvent>)executionTemplate, finalMessage);
        }
    }

    protected boolean isAgedFile(File file, long fileAge) {
        long lastMod = file.lastModified();
        long now = System.currentTimeMillis();
        long thisFileAge = now - lastMod;
        if (thisFileAge < fileAge) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("The file has not aged enough yet, will return nothing for: " + file));
            }
            return false;
        }
        return true;
    }

    private void removeProcessingMark(String fileAbsolutePath) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Removing processing flag for '%s'", fileAbsolutePath));
            }
            this.filesBeingProcessingObjectStore.remove((Serializable)((Object)fileAbsolutePath));
        }
        catch (ObjectStoreException e) {
            this.logger.warn((Object)String.format("Failure trying to remove file '%s' from list of files under processing", fileAbsolutePath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWithoutStreaming(String originalSourceFile, final String originalSourceFileName, final String originalSourceDirectory, final File sourceFile, final File destinationFile, ExecutionTemplate<MuleEvent> executionTemplate, final MuleMessage finalMessage) throws DefaultMuleException {
        try {
            executionTemplate.execute((ExecutionCallback)new ExecutionCallback<MuleEvent>(){

                public MuleEvent process() throws Exception {
                    FileMessageReceiver.this.moveAndDelete(sourceFile, destinationFile, originalSourceFileName, originalSourceDirectory, finalMessage);
                    return null;
                }
            });
            this.deleteFileIfRequired(sourceFile, destinationFile);
        }
        catch (MessagingException e) {
            if (e.causedRollback()) {
                this.rollbackFileMoveIfRequired(originalSourceFile, sourceFile);
            } else {
                this.deleteFileIfRequired(sourceFile, destinationFile);
            }
        }
        catch (Exception e) {
            this.rollbackFileMoveIfRequired(originalSourceFile, sourceFile);
            this.connector.getMuleContext().getExceptionListener().handleException(e);
        }
        finally {
            this.removeProcessingMark(originalSourceFile);
        }
    }

    private void processWithStreaming(final File sourceFile, final ReceiverFileInputStream originalPayload, ExecutionTemplate<MuleEvent> executionTemplate, final MuleMessage finalMessage) {
        try {
            final AtomicBoolean exceptionWasThrown = new AtomicBoolean(false);
            executionTemplate.execute((ExecutionCallback)new ExecutionCallback<MuleEvent>(){

                public MuleEvent process() throws Exception {
                    try {
                        finalMessage.setOutboundProperty("filename", (Object)sourceFile.getName());
                        FileMessageReceiver.this.routeMessage(finalMessage);
                    }
                    catch (Exception e) {
                        exceptionWasThrown.set(true);
                        originalPayload.setStreamProcessingError(true);
                        throw e;
                    }
                    return null;
                }
            });
            if (exceptionWasThrown.get()) {
                originalPayload.setStreamProcessingError(false);
                originalPayload.close();
            }
        }
        catch (MessagingException e) {
            if (!e.causedRollback()) {
                try {
                    originalPayload.setStreamProcessingError(false);
                    originalPayload.close();
                }
                catch (Exception ex) {
                    this.logger.warn((Object)ex);
                }
            }
        }
        catch (Exception e) {
            this.connector.getMuleContext().getExceptionListener().handleException(e);
        }
    }

    protected ReceiverFileInputStream createReceiverFileInputStream(File sourceFile, File destinationFile) throws FileNotFoundException {
        return new ReceiverFileInputStream(sourceFile, this.fileConnector.isAutoDelete(), destinationFile);
    }

    protected ReceiverFileInputStream createReceiverFileInputStream(File sourceFile, File destinationFile, InputStreamCloseListener closeListener) throws FileNotFoundException {
        return new ReceiverFileInputStream(sourceFile, this.fileConnector.isAutoDelete(), destinationFile, closeListener);
    }

    private void rollbackFileMoveIfRequired(String originalSourceFile, File sourceFile) {
        if (!sourceFile.getAbsolutePath().equals(originalSourceFile)) {
            try {
                this.rollbackFileMove(sourceFile, originalSourceFile);
            }
            catch (IOException iox) {
                this.logger.warn((Object)iox);
            }
        }
    }

    private void moveAndDelete(File sourceFile, File destinationFile, String originalSourceFileName, String originalSourceDirectory, MuleMessage message) throws MuleException {
        if (destinationFile != null) {
            try {
                FileUtils.moveFile((File)sourceFile, (File)destinationFile);
            }
            catch (IOException e) {
                throw new DefaultMuleException(FileMessages.failedToMoveFile(sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath()));
            }
            message = this.createMuleMessage(destinationFile, this.endpoint.getEncoding());
            message.setOutboundProperty("filename", (Object)destinationFile.getName());
            message.setOutboundProperty("originalFilename", (Object)originalSourceFileName);
            message.setProperty("originalDirectory", (Object)originalSourceDirectory, PropertyScope.INBOUND);
        }
        this.routeMessage(message);
    }

    private void deleteFileIfRequired(File sourceFile, File destinationFile) throws DefaultMuleException {
        if (this.fileConnector.isAutoDelete() && destinationFile == null && !sourceFile.delete()) {
            throw new DefaultMuleException(FileMessages.failedToDeleteFile(sourceFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean attemptFileLock(File sourceFile) throws MuleException {
        FileLock lock = null;
        FileChannel channel = null;
        boolean fileCanBeLocked = false;
        try {
            channel = new RandomAccessFile(sourceFile, "rw").getChannel();
            lock = channel.tryLock();
        }
        catch (FileNotFoundException fnfe) {
            throw new DefaultMuleException(FileMessages.fileDoesNotExist(sourceFile.getName()));
        }
        catch (IOException e) {
        }
        finally {
            if (lock != null) {
                fileCanBeLocked = true;
                try {
                    lock.release();
                }
                catch (IOException e) {}
            }
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {}
            }
        }
        return fileCanBeLocked;
    }

    List<File> listFiles() throws MuleException {
        if (!this.readDirectory.exists()) {
            throw new DefaultMuleException(FileMessages.errorWhileListingFiles());
        }
        try {
            ArrayList<File> files = new ArrayList<File>();
            this.basicListFiles(this.readDirectory, files);
            return files.isEmpty() ? NO_FILES : files;
        }
        catch (Exception e) {
            throw new DefaultMuleException(FileMessages.errorWhileListingFiles(), (Throwable)e);
        }
    }

    protected void basicListFiles(File currentDirectory, List<File> discoveredFiles) {
        File[] files = currentDirectory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.basicListFiles(file, discoveredFiles);
                continue;
            }
            boolean addFile = true;
            if (this.fileFilter != null) {
                addFile = this.fileFilter.accept(file);
            } else if (this.filenameFilter != null) {
                addFile = this.filenameFilter.accept(currentDirectory, file.getName());
            }
            if (!addFile) continue;
            discoveredFiles.add(file);
        }
    }

    protected void rollbackFileMove(File sourceFile, String destinationFilePath) throws IOException {
        try {
            FileUtils.moveFile((File)sourceFile, (File)FileUtils.newFile((String)destinationFilePath));
        }
        catch (IOException t) {
            this.logger.debug((Object)("rollback of file move failed: " + t.getMessage()));
            throw t;
        }
    }

    protected Comparator<File> getComparator() throws Exception {
        Object comparatorClassName = this.getEndpoint().getProperty((Object)COMPARATOR_CLASS_NAME_PROPERTY);
        if (comparatorClassName != null) {
            Object reverseProperty = this.getEndpoint().getProperty((Object)COMPARATOR_REVERSE_ORDER_PROPERTY);
            boolean reverse = false;
            if (reverseProperty != null) {
                reverse = Boolean.valueOf((String)reverseProperty);
            }
            Class<?> clazz = this.endpoint.getMuleContext().getExecutionClassLoader().loadClass(comparatorClassName.toString());
            Comparator comparator = (Comparator)clazz.newInstance();
            return reverse ? new ReverseComparator(comparator) : comparator;
        }
        return null;
    }
}

