/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import org.mule.DefaultMuleMessage;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transport.PropertyScope;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.file.FileConnector;
import org.mule.transport.file.FileMessageDispatcher;
import org.mule.transport.file.ReceiverFileInputStream;
import org.mule.transport.file.i18n.FileMessages;
import org.mule.util.FileUtils;

public class FileMessageRequester
extends AbstractMessageRequester {
    private final FileConnector fileConnector;
    private String workDir = null;
    private String workFileNamePattern = null;
    private FilenameFilter filenameFilter = null;
    private FileFilter fileFilter = null;

    public FileMessageRequester(InboundEndpoint endpoint) throws MuleException {
        super(endpoint);
        this.fileConnector = (FileConnector)endpoint.getConnector();
        this.workDir = this.fileConnector.getWorkDirectory();
        this.workFileNamePattern = this.fileConnector.getWorkFileNamePattern();
        Filter filter = endpoint.getFilter();
        if (filter instanceof FilenameFilter) {
            this.filenameFilter = (FilenameFilter)filter;
        } else if (filter instanceof FileFilter) {
            this.fileFilter = (FileFilter)filter;
        } else if (filter != null) {
            throw new CreateException(FileMessages.invalidFileFilter(endpoint.getEndpointURI()), (Object)this);
        }
    }

    public Object getDelegateSession() throws MuleException {
        return null;
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        File file = FileUtils.newFile((String)this.endpoint.getEndpointURI().getAddress());
        File result = null;
        if (file.exists()) {
            if (file.isFile()) {
                result = file;
            } else if (file.isDirectory()) {
                result = this.fileFilter != null ? FileMessageDispatcher.getNextFile(this.endpoint.getEndpointURI().getAddress(), this.fileFilter) : FileMessageDispatcher.getNextFile(this.endpoint.getEndpointURI().getAddress(), this.filenameFilter);
            }
            if (result != null) {
                boolean checkFileAge = this.fileConnector.getCheckFileAge();
                if (checkFileAge) {
                    long fileAge = this.fileConnector.getFileAge();
                    long lastMod = result.lastModified();
                    long now = System.currentTimeMillis();
                    long thisFileAge = now - lastMod;
                    if (thisFileAge < fileAge) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("The file has not aged enough yet, will return nothing for: " + result.getCanonicalPath()));
                        }
                        return null;
                    }
                }
                String originalSourceFileName = result.getName();
                String originalSourceDirectory = result.getParent();
                File workFile = null;
                if (this.workDir != null) {
                    String workFileName = this.formatUsingFilenameParser(originalSourceFileName, originalSourceDirectory, this.workFileNamePattern);
                    workFile = FileUtils.newFile((String)this.workDir, (String)workFileName);
                    this.fileConnector.move(result, workFile);
                    result = workFile;
                }
                File destinationFile = null;
                String movDir = this.getMoveDirectory();
                if (movDir != null) {
                    String destinationFileName = originalSourceFileName;
                    String moveToPattern = this.getMoveToPattern();
                    if (moveToPattern != null) {
                        destinationFileName = this.formatUsingFilenameParser(originalSourceFileName, originalSourceDirectory, moveToPattern);
                    }
                    destinationFile = FileUtils.newFile((String)movDir, (String)destinationFileName);
                }
                MuleMessage returnMessage = null;
                String encoding = this.endpoint.getEncoding();
                try {
                    if (this.fileConnector.isStreaming()) {
                        ReceiverFileInputStream receiverStream = new ReceiverFileInputStream(result, this.fileConnector.isAutoDelete(), destinationFile);
                        returnMessage = this.createMuleMessage(receiverStream, encoding);
                    } else {
                        returnMessage = this.createMuleMessage(result, encoding);
                    }
                }
                catch (FileNotFoundException e) {
                    this.logger.error((Object)"File being read disappeared!", (Throwable)e);
                    return null;
                }
                returnMessage.setOutboundProperty("originalFilename", (Object)originalSourceFileName);
                returnMessage.setProperty("originalDirectory", (Object)originalSourceDirectory, PropertyScope.INBOUND);
                if (!this.fileConnector.isStreaming()) {
                    this.moveOrDelete(result, destinationFile);
                }
                return returnMessage;
            }
        }
        return null;
    }

    protected String formatUsingFilenameParser(String originalFileName, String originalDirectory, String pattern) {
        DefaultMuleMessage fileParserMessasge = new DefaultMuleMessage(null, this.getEndpoint().getMuleContext());
        fileParserMessasge.setOutboundProperty("originalFilename", (Object)originalFileName);
        fileParserMessasge.setInboundProperty("originalDirectory", (Object)originalDirectory);
        return this.fileConnector.getFilenameParser().getFilename((MuleMessage)fileParserMessasge, pattern);
    }

    private void moveOrDelete(File sourceFile, File destinationFile) throws DefaultMuleException {
        if (destinationFile != null) {
            try {
                FileUtils.moveFile((File)sourceFile, (File)destinationFile);
            }
            catch (IOException e) {
                throw new DefaultMuleException(FileMessages.failedToMoveFile(sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath()));
            }
        }
        if (this.fileConnector.isAutoDelete() && destinationFile == null && !sourceFile.delete()) {
            throw new DefaultMuleException(FileMessages.failedToDeleteFile(sourceFile));
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected String getMoveDirectory() {
        String moveDirectory = (String)this.endpoint.getProperty((Object)"moveToDirectory");
        if (moveDirectory == null) {
            moveDirectory = this.fileConnector.getMoveToDirectory();
        }
        return moveDirectory;
    }

    protected String getMoveToPattern() {
        String pattern = (String)this.endpoint.getProperty((Object)"moveToPattern");
        if (pattern == null) {
            pattern = this.fileConnector.getMoveToPattern();
        }
        return pattern;
    }
}

