/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.registry.ServiceType;
import org.mule.config.spring.factories.AbstractEndpointFactoryBean;
import org.mule.endpoint.AbstractEndpoint;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.exception.MessagingToSystemExceptionHandlerAdapter;
import org.mule.processor.AbstractRedeliveryPolicy;
import org.mule.transport.service.TransportServiceDescriptor;

public class OutboundEndpointFactoryBean
extends AbstractEndpointFactoryBean
implements FlowConstructAware {
    private Boolean isInExceptionStrategy = false;
    private FlowConstruct flowConstruct;

    public OutboundEndpointFactoryBean(EndpointURIEndpointBuilder global) throws EndpointException {
        super(global);
    }

    public OutboundEndpointFactoryBean() {
    }

    public Class getObjectType() {
        return OutboundEndpoint.class;
    }

    @Override
    public Object doGetObject() throws Exception {
        String scheme = this.getEndpointBuilder().getEndpoint().getFullScheme();
        TransportServiceDescriptor tsd = (TransportServiceDescriptor)this.muleContext.getRegistry().lookupServiceDescriptor(ServiceType.TRANSPORT, scheme, null);
        this.resolveMessagingExceptionHandler();
        EndpointBuilder endpointBuilder = tsd.createEndpointBuilder((EndpointURIEndpointBuilder)this);
        OutboundEndpoint outboundEndpoint = this.muleContext.getEndpointFactory().getOutboundEndpoint(endpointBuilder);
        if (outboundEndpoint instanceof AbstractEndpoint) {
            ((AbstractEndpoint)AbstractEndpoint.class.cast(outboundEndpoint)).setAnnotations(this.getAnnotations());
        }
        return outboundEndpoint;
    }

    public void setRedeliveryPolicy(AbstractRedeliveryPolicy redeliveryPolicy) {
        throw new IllegalStateException("A redelivery policy cannot be specified for an outbound endpoint.");
    }

    public void setIsInExceptionStrategy(Boolean isInExceptionStrategy) {
        this.isInExceptionStrategy = isInExceptionStrategy;
    }

    private void resolveMessagingExceptionHandler() {
        this.messagingExceptionHandler = this.isInExceptionStrategy != false ? new MessagingToSystemExceptionHandlerAdapter() : (this.flowConstruct != null ? this.flowConstruct.getExceptionListener() : null);
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }
}

