/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.Validate;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.mule.module.pgp.StreamTransformer;

public class DecryptStreamTransformer
implements StreamTransformer {
    private static final long offset = 0x1000000L;
    private InputStream toBeDecrypted;
    private PGPPublicKey publicKey;
    private PGPSecretKey secretKey;
    private String password;
    private InputStream uncStream;
    private InputStream compressedStream;
    private InputStream clearStream;
    private long bytesWrote;

    public DecryptStreamTransformer(InputStream toBeDecrypted, PGPPublicKey publicKey, PGPSecretKey secretKey, String password) throws IOException {
        Validate.notNull((Object)toBeDecrypted, (String)"The toBeDecrypted should not be null");
        Validate.notNull((Object)publicKey, (String)"The publicKey should not be null");
        Validate.notNull((Object)secretKey, (String)"The secretKey should not be null");
        Validate.notNull((Object)password, (String)"The password should not be null");
        this.toBeDecrypted = toBeDecrypted;
        this.publicKey = publicKey;
        this.secretKey = secretKey;
        this.password = password;
        this.bytesWrote = 0L;
    }

    @Override
    public void initialize(OutputStream out) throws Exception {
        InputStream decodedInputStream = PGPUtil.getDecoderStream((InputStream)this.toBeDecrypted);
        PGPObjectFactory pgpF = new PGPObjectFactory(decodedInputStream);
        Object pgpObject = pgpF.nextObject();
        if (pgpObject == null) {
            throw new IllegalArgumentException("Invalid PGP message");
        }
        PGPEncryptedDataList enc = pgpObject instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)pgpObject : (PGPEncryptedDataList)pgpF.nextObject();
        Iterator it = enc.getEncryptedDataObjects();
        PGPPublicKeyEncryptedData pbe = null;
        PGPPrivateKey privateKey = null;
        while (privateKey == null && it.hasNext()) {
            pbe = (PGPPublicKeyEncryptedData)it.next();
            privateKey = this.getPrivateKey(pbe.getKeyID(), this.password);
            if (privateKey != null) continue;
            throw new IllegalArgumentException("Failed to find private key with ID " + pbe.getKeyID());
        }
        this.clearStream = pbe.getDataStream(privateKey, "BC");
        PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(this.clearStream);
        pgpObject = pgpObjectFactory.nextObject();
        while (!(pgpObject instanceof PGPLiteralData)) {
            if (pgpObject instanceof PGPOnePassSignatureList) {
                pgpObject = pgpObjectFactory.nextObject();
                continue;
            }
            if (pgpObject instanceof PGPCompressedData) {
                PGPCompressedData cData = (PGPCompressedData)pgpObject;
                this.compressedStream = new BufferedInputStream(cData.getDataStream());
                pgpObjectFactory = new PGPObjectFactory(this.compressedStream);
                pgpObject = pgpObjectFactory.nextObject();
                continue;
            }
            throw new PGPException("input is not PGPLiteralData - type unknown.");
        }
        PGPLiteralData pgpLiteralData = (PGPLiteralData)pgpObject;
        this.uncStream = pgpLiteralData.getInputStream();
    }

    @Override
    public boolean write(OutputStream out, AtomicLong bytesRequested) throws Exception {
        int len = 0;
        byte[] buf = new byte[65536];
        boolean wroteSomething = false;
        while (bytesRequested.get() + 0x1000000L > this.bytesWrote && (len = this.uncStream.read(buf)) > 0) {
            out.write(buf, 0, len);
            this.bytesWrote += (long)len;
            wroteSomething = true;
        }
        if (wroteSomething && len <= 0) {
            this.uncStream.close();
            if (this.compressedStream != null) {
                this.compressedStream.close();
            }
            this.clearStream.close();
            return true;
        }
        return false;
    }

    private PGPPrivateKey getPrivateKey(long keyID, String pass) throws PGPException, NoSuchProviderException {
        PGPSecretKey pgpSecKey = this.secretKey;
        if (pgpSecKey == null) {
            return null;
        }
        return pgpSecKey.extractPrivateKey(pass.toCharArray(), "BC");
    }
}

