/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.util;

import de.odysseus.staxon.json.util.XMLMultipleProcessingInstructionHandler;
import de.odysseus.staxon.util.EventWriterDelegate;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class XMLMultipleEventWriter
extends EventWriterDelegate {
    private final XMLMultipleProcessingInstructionHandler handler;

    public XMLMultipleEventWriter(XMLEventWriter parent, boolean matchRoot, String ... multiplePaths) throws XMLStreamException {
        super(parent);
        this.handler = new XMLMultipleProcessingInstructionHandler(this, matchRoot, false);
        for (String path : multiplePaths) {
            this.addMultiplePath(path);
        }
    }

    @Override
    public void setParent(XMLEventWriter parent) {
        throw new UnsupportedOperationException();
    }

    public void addMultiplePath(String path) throws XMLStreamException {
        this.handler.addMultiplePath(path);
    }

    @Override
    public void add(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            this.add(reader.nextEvent());
        }
    }

    @Override
    public void add(XMLEvent event) throws XMLStreamException {
        switch (event.getEventType()) {
            case 1: {
                QName name = event.asStartElement().getName();
                this.handler.preStartElement(name.getPrefix(), name.getLocalPart());
                super.add(event);
                this.handler.postStartElement();
                break;
            }
            case 2: {
                this.handler.preEndElement();
                super.add(event);
                this.handler.postEndElement();
                break;
            }
            default: {
                super.add(event);
            }
        }
    }
}

