/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import org.cometd.Channel;
import org.cometd.Client;
import org.cometd.ClientListener;
import org.cometd.DeliverListener;
import org.cometd.Extension;
import org.cometd.Message;
import org.cometd.MessageListener;
import org.cometd.QueueListener;
import org.cometd.RemoveListener;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.ChannelImpl;
import org.mortbay.cometd.MessageImpl;
import org.mortbay.log.Log;
import org.mortbay.util.ArrayQueue;
import org.mortbay.util.LazyList;
import org.mortbay.util.ajax.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientImpl
implements Client {
    private String _id;
    private String _type;
    private int _responsesPending;
    private ChannelImpl[] _subscriptions = new ChannelImpl[0];
    private RemoveListener[] _rListeners;
    private MessageListener[] _syncMListeners;
    private MessageListener[] _asyncMListeners;
    private QueueListener[] _qListeners;
    private DeliverListener[] _dListeners;
    protected AbstractBayeux _bayeux;
    private String _browserId;
    private JSON.Literal _advice;
    private int _batch;
    private int _maxQueue;
    private ArrayQueue<Message> _queue = new ArrayQueue(8, 16, (Object)this);
    private long _timeout = -1L;
    private long _interval = -1L;
    private int _lag;
    private Extension[] _extensions;
    private boolean _deliverViaMetaConnectOnly;
    private volatile boolean _isExpired;
    int _adviseVersion;

    protected ClientImpl(AbstractBayeux bayeux) {
        this._bayeux = bayeux;
        this._maxQueue = bayeux.getMaxClientQueue();
    }

    protected ClientImpl(AbstractBayeux bayeux, String idPrefix) {
        this._bayeux = bayeux;
        this._maxQueue = 0;
    }

    public void addExtension(Extension ext) {
        this._extensions = (Extension[])LazyList.addToArray((Object[])this._extensions, (Object)ext, Extension.class);
    }

    public void removeExtension(Extension ext) {
        this._extensions = (Extension[])LazyList.removeFromArray((Object[])this._extensions, (Object)ext);
    }

    Extension[] getExtensions() {
        return this._extensions;
    }

    public void deliver(Client from, String toChannel, Object data, String id) {
        Message m;
        MessageImpl message = this._bayeux.newMessage();
        message.put("channel", (Object)toChannel);
        message.put("data", data);
        if (id != null) {
            message.put("id", (Object)id);
        }
        if ((m = this._bayeux.extendSendBayeux(from, message)) != null) {
            this.doDelivery(from, m);
        }
        if (m instanceof MessageImpl) {
            ((MessageImpl)m).decRef();
        }
    }

    public void deliverLazy(Client from, String toChannel, Object data, String id) {
        MessageImpl message = this._bayeux.newMessage();
        message.put("channel", (Object)toChannel);
        message.put("data", data);
        if (id != null) {
            message.put("id", (Object)id);
        }
        message.setLazy(true);
        Message m = this._bayeux.extendSendBayeux(from, message);
        if (m != null) {
            this.doDelivery(from, m);
        }
        if (m instanceof MessageImpl) {
            ((MessageImpl)m).decRef();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelivery(Client from, Message msg) {
        Message message = this._bayeux.extendSendClient(from, this, msg);
        if (message == null) {
            return;
        }
        MessageListener[] alisteners = null;
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            if (this._maxQueue < 0) {
                ((MessageImpl)message).incRef();
                this._queue.addUnsafe((Object)message);
            } else {
                boolean queue;
                if (this._queue.size() >= this._maxQueue) {
                    if (this._qListeners != null && this._qListeners.length > 0) {
                        queue = true;
                        for (QueueListener l : this._qListeners) {
                            queue &= this.notifyQueueListener(l, from, message);
                        }
                    } else {
                        queue = false;
                    }
                } else {
                    queue = true;
                }
                if (queue) {
                    ((MessageImpl)message).incRef();
                    this._queue.addUnsafe((Object)message);
                }
            }
            if (this._syncMListeners != null) {
                for (MessageListener l : this._syncMListeners) {
                    this.notifyMessageListener(l, from, message);
                }
            }
            alisteners = this._asyncMListeners;
            if (this._batch == 0 && this._responsesPending < 1 && this._queue.size() > 0) {
                if (((MessageImpl)message).isLazy()) {
                    this.lazyResume();
                } else {
                    this.resume();
                }
            }
        }
        if (alisteners != null) {
            for (MessageListener l : alisteners) {
                this.notifyMessageListener(l, from, message);
            }
        }
    }

    private boolean notifyQueueListener(QueueListener listener, Client from, Message message) {
        try {
            return listener.queueMaxed(from, (Client)this, message);
        }
        catch (Throwable x) {
            Log.warn((Throwable)x);
            return false;
        }
    }

    private void notifyMessageListener(MessageListener listener, Client from, Message message) {
        try {
            listener.deliver(from, (Client)this, message);
        }
        catch (Throwable x) {
            Log.warn((Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeliverListeners() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            if (this._dListeners != null) {
                for (DeliverListener l : this._dListeners) {
                    this.notifyDeliverListener(l, (Queue<Message>)this._queue);
                }
            }
        }
    }

    private void notifyDeliverListener(DeliverListener listener, Queue<Message> queue) {
        try {
            listener.deliver((Client)this, queue);
        }
        catch (Throwable x) {
            Log.warn((Throwable)x);
        }
    }

    public void setMetaConnectDeliveryOnly(boolean deliverViaMetaConnectOnly) {
        this._deliverViaMetaConnectOnly = deliverViaMetaConnectOnly;
    }

    public boolean isMetaConnectDeliveryOnly() {
        return this._deliverViaMetaConnectOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBatch() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            ++this._batch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endBatch() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            if (--this._batch == 0 && this._responsesPending < 1) {
                block2 : switch (this._queue.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (((MessageImpl)this._queue.get(0)).isLazy()) {
                            this.lazyResume();
                            break;
                        }
                        this.resume();
                        break;
                    }
                    default: {
                        int i = this._queue.size();
                        while (i-- > 0) {
                            if (((MessageImpl)this._queue.get(i)).isLazy()) continue;
                            this.resume();
                            break block2;
                        }
                        this.lazyResume();
                    }
                }
            }
        }
    }

    public String getConnectionType() {
        return this._type;
    }

    public String getId() {
        return this._id;
    }

    public boolean hasMessages() {
        return this._queue.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNonLazyMessages() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            int i = this._queue.size();
            while (i-- > 0) {
                if (((MessageImpl)this._queue.getUnsafe(i)).isLazy()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isLocal() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            if (this._bayeux.hasClient(this._id)) {
                this.remove(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(boolean timeout) {
        RemoveListener[] listeners;
        String browser_id;
        this._isExpired = timeout;
        Client client = this._bayeux.removeClient(this._id);
        if (client != null && this._bayeux.isLogInfo()) {
            this._bayeux.logInfo("Remove client " + client + " timeout=" + timeout);
        }
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            browser_id = this._browserId;
            this._browserId = null;
            listeners = this._rListeners;
        }
        if (browser_id != null) {
            this._bayeux.clientOffBrowser(browser_id, this._id);
        }
        if (listeners != null) {
            for (RemoveListener l : listeners) {
                this.notifyRemoveListener(l, this._id, timeout);
            }
        }
        this.resume();
    }

    private void notifyRemoveListener(RemoveListener listener, String clientId, boolean timeout) {
        try {
            listener.removed(clientId, timeout);
        }
        catch (Throwable x) {
            Log.warn((Throwable)x);
        }
    }

    public boolean isExpired() {
        return this._isExpired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int responded() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            return this._responsesPending--;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int responsePending() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            return ++this._responsesPending;
        }
    }

    public void lazyResume() {
    }

    public void resume() {
    }

    public int getMessages() {
        return this._queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> takeMessages() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            ArrayList<Message> list = new ArrayList<Message>((Collection<Message>)this._queue);
            this._queue.clear();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnMessages(List<Message> messages) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            this._queue.addAll(0, messages);
        }
    }

    public String toString() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSubscription(ChannelImpl channel) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            this._subscriptions = (ChannelImpl[])LazyList.addToArray((Object[])this._subscriptions, (Object)channel, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscription(ChannelImpl channel) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            this._subscriptions = (ChannelImpl[])LazyList.removeFromArray((Object[])this._subscriptions, (Object)channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnectionType(String type) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            this._type = type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setId(String id) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            this._id = id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeAll() {
        ChannelImpl[] subscriptions;
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            subscriptions = this._subscriptions;
            this._subscriptions = new ChannelImpl[0];
        }
        for (ChannelImpl channel : subscriptions) {
            channel.unsubscribe(this);
        }
    }

    public void setBrowserId(String id) {
        if (this._browserId != null && !this._browserId.equals(id)) {
            this._bayeux.clientOffBrowser(this._browserId, this._id);
        }
        this._browserId = id;
        if (this._browserId != null) {
            this._bayeux.clientOnBrowser(this._browserId, this._id);
        }
    }

    public String getBrowserId() {
        return this._browserId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Client)) {
            return false;
        }
        return this.getId().equals(((Client)o).getId());
    }

    public JSON.Literal getAdvice() {
        return this._advice;
    }

    public void setAdvice(JSON.Literal advice) {
        this._advice = advice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ClientListener listener) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            if (listener instanceof MessageListener) {
                if (listener instanceof MessageListener.Synchronous) {
                    this._syncMListeners = (MessageListener[])LazyList.addToArray((Object[])this._syncMListeners, (Object)listener, MessageListener.class);
                } else {
                    this._asyncMListeners = (MessageListener[])LazyList.addToArray((Object[])this._asyncMListeners, (Object)listener, MessageListener.class);
                }
            }
            if (listener instanceof RemoveListener) {
                this._rListeners = (RemoveListener[])LazyList.addToArray((Object[])this._rListeners, (Object)listener, RemoveListener.class);
            }
            if (listener instanceof QueueListener) {
                this._qListeners = (QueueListener[])LazyList.addToArray((Object[])this._qListeners, (Object)listener, QueueListener.class);
            }
            if (listener instanceof DeliverListener) {
                this._dListeners = (DeliverListener[])LazyList.addToArray((Object[])this._dListeners, (Object)listener, DeliverListener.class);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ClientListener listener) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            if (listener instanceof MessageListener) {
                this._syncMListeners = (MessageListener[])LazyList.removeFromArray((Object[])this._syncMListeners, (Object)listener);
                this._asyncMListeners = (MessageListener[])LazyList.removeFromArray((Object[])this._asyncMListeners, (Object)listener);
            }
            if (listener instanceof RemoveListener) {
                this._rListeners = (RemoveListener[])LazyList.removeFromArray((Object[])this._rListeners, (Object)listener);
            }
            if (listener instanceof QueueListener) {
                this._qListeners = (QueueListener[])LazyList.removeFromArray((Object[])this._qListeners, (Object)listener);
            }
        }
    }

    public long getInterval() {
        return this._interval;
    }

    public void setInterval(long intervalMS) {
        this._interval = intervalMS;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long timeoutMS) {
        this._timeout = timeoutMS;
    }

    public void setMaxQueue(int maxQueue) {
        this._maxQueue = maxQueue;
    }

    public int getMaxQueue() {
        return this._maxQueue;
    }

    public Queue<Message> getQueue() {
        return this._queue;
    }

    public int getLag() {
        return this._lag;
    }

    public void setLag(int lag) {
        this._lag = lag;
    }

    public Channel[] getSubscriptions() {
        ChannelImpl[] subscriptions = this._subscriptions;
        if (subscriptions == null) {
            return null;
        }
        Channel[] channels = new Channel[subscriptions.length];
        System.arraycopy(subscriptions, 0, channels, 0, subscriptions.length);
        return channels;
    }
}

