/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.cometd.Message;
import org.mortbay.cometd.AbstractTransport;
import org.mortbay.cometd.MessageImpl;
import org.mortbay.util.ajax.JSON;

public class JSONPTransport
extends AbstractTransport {
    public static final String __DEFAULT_CALLBACK = "jsonpcallback";
    int _responses = 0;
    PrintWriter _out;
    String _jsonp = null;
    String _mimeType = "text/javascript; charset=utf-8";

    public JSONPTransport(String jsonp) {
        this._jsonp = jsonp;
    }

    public void send(Message message) throws IOException {
        if (message != null) {
            if (this._responses == 0) {
                HttpServletResponse response = this.getResponse();
                response.setContentType(this._mimeType);
                this._out = response.getWriter();
                this._out.write(this._jsonp == null ? __DEFAULT_CALLBACK : this._jsonp);
                this._out.write("([");
            } else {
                this._out.write(",\r\n");
            }
            String r = message instanceof MessageImpl ? ((MessageImpl)message).getJSON() : JSON.toString((Map)message);
            ++this._responses;
            this._out.write(r);
        }
    }

    public void complete() throws IOException {
        HttpServletResponse response = this.getResponse();
        response.setStatus(200);
        if (this._responses == 0) {
            response.setContentType(this._mimeType);
            this._out = response.getWriter();
            this._out.write(this._jsonp == null ? __DEFAULT_CALLBACK : this._jsonp);
            this._out.write("([");
        }
        this._out.write("])\r\n");
        this._out.close();
    }

    public boolean isMetaConnectDeliveryOnly() {
        return true;
    }

    public String getJsonp() {
        return this._jsonp;
    }

    public String toString() {
        return "JSONPTransport[jsonp=" + this._jsonp + "]";
    }
}

