/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import org.mule.module.launcher.application.AbstractApplicationClassLoader;
import org.mule.module.launcher.application.ApplicationClassLoader;
import org.mule.util.FileUtils;
import org.mule.util.SystemUtils;

public class MuleApplicationClassLoader
extends AbstractApplicationClassLoader
implements ApplicationClassLoader {
    public static final String PATH_LIBRARY = "lib";
    public static final String PATH_CLASSES = "classes";
    public static final String PATH_MULE = "mule";
    public static final String PATH_PER_APP = "per-app";
    protected static final URL[] CLASSPATH_EMPTY = new URL[0];
    private String appName;
    private String libraryPath;

    public MuleApplicationClassLoader(String appName, ClassLoader parentCl) {
        this(appName, parentCl, Collections.emptySet());
    }

    public MuleApplicationClassLoader(String appName, ClassLoader parentCl, Set<String> loaderOverrides) {
        block2: {
            super(CLASSPATH_EMPTY, parentCl, loaderOverrides);
            this.appName = appName;
            try {
                String muleHome = System.getProperty("mule.home");
                String configPath = String.format("%s/apps/%s", muleHome, appName);
                File parentFile = new File(configPath);
                File classesDir = new File(parentFile, PATH_CLASSES);
                this.addURL(classesDir.toURI().toURL());
                File libDir = new File(parentFile, PATH_LIBRARY);
                this.addJars(appName, libDir, true);
                this.libraryPath = libDir.getAbsolutePath();
                File libs = new File(muleHome, PATH_LIBRARY);
                File muleLibs = new File(libs, PATH_MULE);
                File perAppLibs = new File(muleLibs, PATH_PER_APP);
                this.addJars(appName, perAppLibs, false);
            }
            catch (IOException e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)String.format("[%s]", appName), (Throwable)e);
            }
        }
    }

    private void addJars(String appName, File dir, boolean verbose) throws MalformedURLException {
        if (dir.exists() && dir.canRead()) {
            Collection jars = FileUtils.listFiles((File)dir, (String[])new String[]{"jar"}, (boolean)false);
            if (!jars.isEmpty() && this.logger.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("[%s] Loading the following jars:%n", appName));
                sb.append("=============================").append(SystemUtils.LINE_SEPARATOR);
                for (File jar : jars) {
                    sb.append(jar.toURI().toURL()).append(SystemUtils.LINE_SEPARATOR);
                }
                sb.append("=============================").append(SystemUtils.LINE_SEPARATOR);
                if (verbose) {
                    this.logger.info((Object)sb.toString());
                } else {
                    this.logger.debug((Object)sb.toString());
                }
            }
            for (File jar : jars) {
                this.addURL(jar.toURI().toURL());
            }
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    @Override
    public URL getResource(String name) {
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return super.getResources(name);
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getName(), this.appName, Integer.toHexString(System.identityHashCode(this)));
    }

    @Override
    protected String findLibrary(String name) {
        File library;
        String parentResolvedPath = super.findLibrary(name);
        if (null == parentResolvedPath && (library = new File(this.libraryPath, System.mapLibraryName(name))).exists()) {
            parentResolvedPath = library.getAbsolutePath();
        }
        return parentResolvedPath;
    }
}

