/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.beanutils.BeanToPropertyValueTransformer;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.StartupContext;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.launcher.AppDeployerMonitorThreadFactory;
import org.mule.module.launcher.CompositeDeploymentListener;
import org.mule.module.launcher.DefaultMuleDeployer;
import org.mule.module.launcher.DeploymentException;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.DeploymentStatusTracker;
import org.mule.module.launcher.MuleDeployer;
import org.mule.module.launcher.PluginClassLoaderManager;
import org.mule.module.launcher.StartupListener;
import org.mule.module.launcher.StartupSummaryDeploymentListener;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.application.ApplicationClassLoaderFactory;
import org.mule.module.launcher.application.ApplicationFactory;
import org.mule.module.launcher.application.CompositeApplicationClassLoaderFactory;
import org.mule.module.launcher.application.DefaultApplicationFactory;
import org.mule.module.launcher.application.MuleApplicationClassLoaderFactory;
import org.mule.module.launcher.util.DebuggableReentrantLock;
import org.mule.module.launcher.util.ElementAddedEvent;
import org.mule.module.launcher.util.ElementRemovedEvent;
import org.mule.module.launcher.util.ObservableList;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.ArrayUtils;
import org.mule.util.CollectionUtils;
import org.mule.util.SplashScreen;
import org.mule.util.StringUtils;

public class MuleDeploymentService
implements DeploymentService {
    public static final String APP_ANCHOR_SUFFIX = "-anchor.txt";
    public static final String ZIP_FILE_SUFFIX = ".zip";
    public static final IOFileFilter ZIP_APPS_FILTER = new AndFileFilter((IOFileFilter)new SuffixFileFilter(".zip"), FileFileFilter.FILE);
    public static final String ANOTHER_DEPLOYMENT_OPERATION_IS_IN_PROGRESS = "Another deployment operation is in progress";
    public static final String INSTALL_OPERATION_HAS_BEEN_INTERRUPTED = "Install operation has been interrupted";
    protected static final int DEFAULT_CHANGES_CHECK_INTERVAL_MS = 5000;
    public static final String CHANGE_CHECK_INTERVAL_PROPERTY = "mule.launcher.changeCheckInterval";
    protected ScheduledExecutorService appDirMonitorTimer;
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected MuleDeployer deployer;
    protected ApplicationFactory appFactory;
    private ReentrantLock lock = new DebuggableReentrantLock(true);
    private ObservableList<Application> applications = new ObservableList();
    private Map<String, ZombieFile> zombieMap = new HashMap<String, ZombieFile>();
    private final File appsDir = MuleContainerBootstrapUtils.getMuleAppsDir();
    private List<StartupListener> startupListeners = new ArrayList<StartupListener>();
    private CompositeDeploymentListener deploymentListener = new CompositeDeploymentListener();

    public MuleDeploymentService(PluginClassLoaderManager pluginClassLoaderManager) {
        ApplicationClassLoaderFactory applicationClassLoaderFactory = new MuleApplicationClassLoaderFactory();
        applicationClassLoaderFactory = new CompositeApplicationClassLoaderFactory(applicationClassLoaderFactory, pluginClassLoaderManager);
        DefaultApplicationFactory appFactory = new DefaultApplicationFactory(applicationClassLoaderFactory);
        appFactory.setDeploymentListener(this.deploymentListener);
        this.appFactory = appFactory;
        DefaultMuleDeployer deployer = new DefaultMuleDeployer();
        deployer.setApplicationFactory(this.appFactory);
        this.deployer = deployer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        this.lock.lock();
        try {
            DeploymentStatusTracker deploymentStatusTracker = new DeploymentStatusTracker();
            this.addDeploymentListener(deploymentStatusTracker);
            StartupSummaryDeploymentListener summaryDeploymentListener = new StartupSummaryDeploymentListener(deploymentStatusTracker);
            this.addStartupListener(summaryDeploymentListener);
            this.deleteAllAnchors();
            Map options = StartupContext.get().getStartupOptions();
            String appString = (String)options.get("app");
            if (appString == null) {
                String[] explodedApps = this.appsDir.list((FilenameFilter)DirectoryFileFilter.DIRECTORY);
                String[] packagedApps = this.appsDir.list((FilenameFilter)ZIP_APPS_FILTER);
                this.deployPackedApps(packagedApps);
                this.deployExplodedApps(explodedApps);
            } else {
                String[] apps = appString.split(":");
                for (String app : apps = this.removeDuplicateAppNames(apps)) {
                    try {
                        File applicationFile = new File(this.appsDir, app + ZIP_FILE_SUFFIX);
                        if (applicationFile.exists() && applicationFile.isFile()) {
                            this.deployPackedApp(app + ZIP_FILE_SUFFIX);
                            continue;
                        }
                        this.deployExplodedApp(app);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            for (StartupListener listener : this.startupListeners) {
                try {
                    listener.onAfterStartup();
                }
                catch (Throwable t) {
                    this.logger.error((Object)t);
                }
            }
            if (appString == null) {
                this.scheduleChangeMonitor(this.appsDir);
            } else if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)SplashScreen.miniSplash((String)"Mule is up and running in a fixed app set mode"));
            }
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    private void deleteAllAnchors() {
        String[] appAnchors;
        for (String anchor : appAnchors = this.appsDir.list((FilenameFilter)new SuffixFileFilter(APP_ANCHOR_SUFFIX))) {
            new File(this.appsDir, anchor).delete();
        }
    }

    private void deployApplication(Application application) throws DeploymentException {
        try {
            this.deploymentListener.onDeploymentStart(application.getAppName());
            this.guardedDeploy(application);
            this.deploymentListener.onDeploymentSuccess(application.getAppName());
            this.zombieMap.remove(application.getAppName());
        }
        catch (Throwable t) {
            String msg = SplashScreen.miniSplash((String)String.format("Failed to deploy app '%s', see below", application.getAppName()));
            this.logger.error((Object)msg, t);
            this.addZombieApp(application);
            this.deploymentListener.onDeploymentFailure(application.getAppName(), t);
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            msg = "Failed to deploy application: " + application.getAppName();
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
    }

    private String[] removeDuplicateAppNames(String[] apps) {
        LinkedList<String> appNames = new LinkedList<String>();
        for (String appName : apps) {
            if (appNames.contains(appName)) continue;
            appNames.add(appName);
        }
        return appNames.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    protected void scheduleChangeMonitor(File appsDir) {
        int reloadIntervalMs = MuleDeploymentService.getChangesCheckIntervalMs();
        this.appDirMonitorTimer = Executors.newSingleThreadScheduledExecutor(new AppDeployerMonitorThreadFactory());
        this.appDirMonitorTimer.scheduleWithFixedDelay(new AppDirWatcher(appsDir), 0L, reloadIntervalMs, TimeUnit.MILLISECONDS);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Mule is up and kicking (every %dms)", reloadIntervalMs)));
        }
    }

    public static int getChangesCheckIntervalMs() {
        try {
            String value = System.getProperty(CHANGE_CHECK_INTERVAL_PROPERTY);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 5000;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.stopAppDirMonitorTimer();
        this.lock.lock();
        try {
            Collections.reverse(this.applications);
            for (Application application : this.applications) {
                try {
                    application.stop();
                    application.dispose();
                }
                catch (Throwable t) {
                    this.logger.error((Object)t);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void stopAppDirMonitorTimer() {
        if (this.appDirMonitorTimer != null) {
            this.appDirMonitorTimer.shutdown();
            try {
                this.appDirMonitorTimer.awaitTermination(MuleDeploymentService.getChangesCheckIntervalMs(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Application findApplication(String appName) {
        return (Application)CollectionUtils.find(this.applications, (Predicate)new BeanPropertyValueEqualsPredicate("appName", (Object)appName));
    }

    @Override
    public List<Application> getApplications() {
        return Collections.unmodifiableList(this.applications);
    }

    public Map<URL, Long> getZombieMap() {
        HashMap<URL, Long> result = new HashMap<URL, Long>();
        for (String app : this.zombieMap.keySet()) {
            ZombieFile file = this.zombieMap.get(app);
            result.put(file.url, file.originalTimestamp);
        }
        return result;
    }

    protected MuleDeployer getDeployer() {
        return this.deployer;
    }

    public void setAppFactory(ApplicationFactory appFactory) {
        this.appFactory = appFactory;
    }

    public void setDeployer(MuleDeployer deployer) {
        this.deployer = deployer;
    }

    public ApplicationFactory getAppFactory() {
        return this.appFactory;
    }

    @Override
    public ReentrantLock getLock() {
        return this.lock;
    }

    protected void onApplicationInstalled(Application a) {
        this.trackApplication(a);
    }

    private void trackApplication(Application application) {
        Application previousApplication = this.findApplication(application.getAppName());
        this.applications.remove(previousApplication);
        this.applications.add(application);
    }

    protected void undeploy(Application app) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("================== Request to Undeploy Application: " + app.getAppName()));
        }
        try {
            this.deploymentListener.onUndeploymentStart(app.getAppName());
            this.applications.remove(app);
            this.guardedUndeploy(app);
            this.deploymentListener.onUndeploymentSuccess(app.getAppName());
        }
        catch (RuntimeException e) {
            this.deploymentListener.onUndeploymentFailure(app.getAppName(), e);
            throw e;
        }
    }

    @Override
    public void undeploy(String appName) {
        Application app = (Application)CollectionUtils.find(this.applications, (Predicate)new BeanPropertyValueEqualsPredicate("appName", (Object)appName));
        this.undeploy(app);
    }

    @Override
    public void deploy(URL appArchiveUrl) throws IOException {
        try {
            Application application;
            try {
                application = this.guardedInstallFrom(appArchiveUrl);
                this.trackApplication(application);
            }
            catch (Throwable t) {
                File appArchive = new File(appArchiveUrl.toURI());
                String appName = StringUtils.removeEnd((String)appArchive.getName(), (String)ZIP_FILE_SUFFIX);
                String msg = SplashScreen.miniSplash((String)String.format("Failed to deploy app '%s', see below", appName));
                this.logger.error((Object)msg, t);
                this.addZombieFile(appName, appArchive);
                this.deploymentListener.onDeploymentFailure(appName, t);
                throw t;
            }
            this.deployApplication(application);
        }
        catch (Throwable t) {
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            String msg = "Failed to deploy from URL: " + appArchiveUrl;
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void guardedDeploy(Application application) {
        try {
            if (!this.lock.tryLock(0L, TimeUnit.SECONDS)) {
                return;
            }
            this.deployer.deploy(application);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void guardedUndeploy(Application app) {
        try {
            if (!this.lock.tryLock(0L, TimeUnit.SECONDS)) {
                return;
            }
            this.deployer.undeploy(app);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    private Application guardedInstallFrom(URL appArchiveUrl) throws IOException {
        try {
            if (!this.lock.tryLock(0L, TimeUnit.SECONDS)) {
                throw new IOException(ANOTHER_DEPLOYMENT_OPERATION_IS_IN_PROGRESS);
            }
            Application application = this.deployer.installFrom(appArchiveUrl);
            return application;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(INSTALL_OPERATION_HAS_BEEN_INTERRUPTED);
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    protected void addZombieApp(Application application) {
        String resource;
        File appDir = new File(MuleContainerBootstrapUtils.getMuleAppsDir(), application.getAppName());
        File resourceFile = new File(appDir, resource = application.getDescriptor().getConfigResources()[0]);
        if (resourceFile.exists()) {
            try {
                this.zombieMap.put(application.getAppName(), new ZombieFile(resourceFile));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void addZombieFile(String appName, File marker) {
        if (marker == null) {
            return;
        }
        if (!marker.exists()) {
            return;
        }
        try {
            this.zombieMap.put(appName, new ZombieFile(marker));
        }
        catch (Exception e) {
            this.logger.debug((Object)String.format("Failed to mark an exploded app [%s] as a zombie", marker.getName()), (Throwable)e);
        }
    }

    @Override
    public void addStartupListener(StartupListener listener) {
        this.startupListeners.add(listener);
    }

    @Override
    public void removeStartupListener(StartupListener listener) {
        this.startupListeners.remove(listener);
    }

    @Override
    public void addDeploymentListener(DeploymentListener listener) {
        this.deploymentListener.addDeploymentListener(listener);
    }

    @Override
    public void removeDeploymentListener(DeploymentListener listener) {
        this.deploymentListener.removeDeploymentListener(listener);
    }

    private void deployPackedApps(String[] zips) {
        for (String zip : zips) {
            try {
                this.deployPackedApp(zip);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void deployPackedApp(String zip) throws Exception {
        String appName = StringUtils.removeEnd((String)zip, (String)ZIP_FILE_SUFFIX);
        File appZip = new File(this.appsDir, zip);
        URL url = appZip.toURI().toURL();
        ZombieFile zombieFile = this.zombieMap.get(appName);
        if (zombieFile != null && zombieFile.isFor(url) && !zombieFile.updatedZombieApp()) {
            return;
        }
        Application app = (Application)CollectionUtils.find(this.applications, (Predicate)new BeanPropertyValueEqualsPredicate("appName", (Object)appName));
        if (app != null) {
            this.undeploy(appName);
        }
        this.deploy(url);
    }

    private void deployExplodedApps(String[] apps) {
        Collection deployedAppNames = CollectionUtils.collect(this.applications, (Transformer)new BeanToPropertyValueTransformer("appName"));
        for (String addedApp : apps) {
            ZombieFile zombieFile = this.zombieMap.get(addedApp);
            if (zombieFile != null && !zombieFile.updatedZombieApp() || deployedAppNames.contains(addedApp) && !this.zombieMap.containsKey(addedApp)) continue;
            try {
                this.deployExplodedApp(addedApp);
            }
            catch (DeploymentException e) {
                // empty catch block
            }
        }
    }

    private void deployExplodedApp(String addedApp) throws DeploymentException {
        Application application;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("================== New Exploded Application: " + addedApp));
        }
        try {
            application = this.appFactory.createApp(addedApp);
            this.onApplicationInstalled(application);
        }
        catch (Throwable t) {
            File appsDir1 = MuleContainerBootstrapUtils.getMuleAppsDir();
            File appDir1 = new File(appsDir1, addedApp);
            this.addZombieFile(addedApp, appDir1);
            String msg = SplashScreen.miniSplash((String)String.format("Failed to deploy exploded application: '%s', see below", addedApp));
            this.logger.error((Object)msg, t);
            this.deploymentListener.onDeploymentFailure(addedApp, t);
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            msg = "Failed to deploy application: " + addedApp;
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
        this.deployApplication(application);
    }

    private String[] findExpectedAnchorFiles() {
        String[] appAnchors = new String[this.applications.size()];
        int i = 0;
        for (Application application : this.applications) {
            appAnchors[i++] = application.getAppName() + APP_ANCHOR_SUFFIX;
        }
        return appAnchors;
    }

    private static class ZombieFile {
        URL url;
        Long originalTimestamp;
        File file;

        private ZombieFile(File file) {
            this.file = file;
            this.originalTimestamp = file.lastModified();
            try {
                this.url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public boolean isFor(URL url) {
            return this.url.equals(url);
        }

        public boolean updatedZombieApp() {
            return this.originalTimestamp.longValue() != this.file.lastModified();
        }
    }

    protected class AppDirWatcher
    implements Runnable {
        protected File appsDir;
        protected volatile boolean dirty;

        public AppDirWatcher(File appsDir) {
            this.appsDir = appsDir;
            MuleDeploymentService.this.applications.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e instanceof ElementAddedEvent || e instanceof ElementRemovedEvent) {
                        if (MuleDeploymentService.this.logger.isDebugEnabled()) {
                            MuleDeploymentService.this.logger.debug((Object)"Deployed applications set has been modified, flushing state.");
                        }
                        AppDirWatcher.this.dirty = true;
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (MuleDeploymentService.this.logger.isDebugEnabled()) {
                    MuleDeploymentService.this.logger.debug((Object)"Checking for changes...");
                }
                if (!MuleDeploymentService.this.lock.tryLock(0L, TimeUnit.SECONDS)) {
                    if (MuleDeploymentService.this.logger.isDebugEnabled()) {
                        MuleDeploymentService.this.logger.debug((Object)("Another deployment operation in progress, will skip this cycle. Owner thread: " + ((DebuggableReentrantLock)MuleDeploymentService.this.lock).getOwner()));
                    }
                    return;
                }
                this.undeployRemovedApps();
                String[] apps = this.appsDir.list((FilenameFilter)DirectoryFileFilter.DIRECTORY);
                String[] zips = this.appsDir.list((FilenameFilter)ZIP_APPS_FILTER);
                MuleDeploymentService.this.deployPackedApps(zips);
                if (zips.length > 0 || this.dirty) {
                    apps = this.appsDir.list((FilenameFilter)DirectoryFileFilter.DIRECTORY);
                }
                MuleDeploymentService.this.deployExplodedApps(apps);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (MuleDeploymentService.this.lock.isHeldByCurrentThread()) {
                    MuleDeploymentService.this.lock.unlock();
                }
                this.dirty = false;
            }
        }

        private void undeployRemovedApps() {
            String[] currentAnchors = this.appsDir.list((FilenameFilter)new SuffixFileFilter(MuleDeploymentService.APP_ANCHOR_SUFFIX));
            if (MuleDeploymentService.this.logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("Current anchors:%n", new Object[0]));
                for (String currentAnchor : currentAnchors) {
                    sb.append(String.format("  %s%n", currentAnchor));
                }
                MuleDeploymentService.this.logger.debug((Object)sb.toString());
            }
            String[] appAnchors = MuleDeploymentService.this.findExpectedAnchorFiles();
            Collection deletedAnchors = CollectionUtils.subtract(Arrays.asList(appAnchors), Arrays.asList(currentAnchors));
            if (MuleDeploymentService.this.logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("Deleted anchors:%n", new Object[0]));
                for (String deletedAnchor : deletedAnchors) {
                    sb.append(String.format("  %s%n", deletedAnchor));
                }
                MuleDeploymentService.this.logger.debug((Object)sb.toString());
            }
            for (String deletedAnchor : deletedAnchors) {
                String appName = StringUtils.removeEnd((String)deletedAnchor, (String)MuleDeploymentService.APP_ANCHOR_SUFFIX);
                try {
                    if (MuleDeploymentService.this.zombieMap.containsKey(appName)) continue;
                    if (MuleDeploymentService.this.findApplication(appName) != null) {
                        MuleDeploymentService.this.undeploy(appName);
                        continue;
                    }
                    if (!MuleDeploymentService.this.logger.isDebugEnabled()) continue;
                    MuleDeploymentService.this.logger.debug((Object)String.format("Application [%s] has already been undeployed via API", appName));
                }
                catch (Throwable t) {
                    MuleDeploymentService.this.logger.error((Object)("Failed to undeploy application: " + appName), t);
                }
            }
        }
    }
}

