/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.notification.MuleContextListener;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.config.builders.AutoConfigurationBuilder;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.NotificationException;
import org.mule.module.launcher.AbstractFileWatcher;
import org.mule.module.launcher.ApplicationMuleContextBuilder;
import org.mule.module.launcher.ConfigChangeMonitorThreadFactory;
import org.mule.module.launcher.DeploymentInitException;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.DeploymentStartException;
import org.mule.module.launcher.DeploymentStopException;
import org.mule.module.launcher.DisposableClassLoader;
import org.mule.module.launcher.InstallException;
import org.mule.module.launcher.MuleDeploymentService;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.application.ApplicationClassLoaderFactory;
import org.mule.module.launcher.application.MuleContextDeploymentListener;
import org.mule.module.launcher.application.NullDeploymentListener;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.ClassUtils;
import org.mule.util.ExceptionUtils;
import org.mule.util.FileUtils;
import org.mule.util.SplashScreen;
import org.mule.util.StringUtils;

public class DefaultMuleApplication
implements Application {
    protected static final int DEFAULT_RELOAD_CHECK_INTERVAL_MS = 3000;
    protected static final String ANCHOR_FILE_BLURB = "Delete this file while Mule is running to undeploy this app in a clean way.";
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected final transient Log deployLogger = LogFactory.getLog(MuleDeploymentService.class);
    protected ScheduledExecutorService watchTimer;
    protected MuleContext muleContext;
    protected ClassLoader deploymentClassLoader;
    protected ApplicationDescriptor descriptor;
    protected final ApplicationClassLoaderFactory applicationClassLoaderFactory;
    protected String[] absoluteResourcePaths;
    protected DeploymentListener deploymentListener;

    protected DefaultMuleApplication(ApplicationDescriptor appDesc, ApplicationClassLoaderFactory applicationClassLoaderFactory) {
        this.descriptor = appDesc;
        this.applicationClassLoaderFactory = applicationClassLoaderFactory;
        this.deploymentListener = new NullDeploymentListener();
    }

    public void setDeploymentListener(DeploymentListener deploymentListener) {
        if (deploymentListener == null) {
            throw new IllegalArgumentException("Deployment listener cannot be null");
        }
        this.deploymentListener = deploymentListener;
    }

    @Override
    public void install() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("New app '%s'", this.descriptor.getAppName())));
        }
        String[] configResources = this.descriptor.getConfigResources();
        this.absoluteResourcePaths = new String[configResources.length];
        for (int i = 0; i < configResources.length; ++i) {
            String resource = configResources[i];
            File file = this.toAbsoluteFile(resource);
            if (!file.exists()) {
                String message = String.format("Config for app '%s' not found: %s", this.getAppName(), file);
                throw new InstallException(MessageFactory.createStaticMessage((String)message));
            }
            this.absoluteResourcePaths[i] = file.getAbsolutePath();
        }
        this.deploymentClassLoader = this.applicationClassLoaderFactory.create(this.descriptor);
    }

    @Override
    public String getAppName() {
        return this.descriptor.getAppName();
    }

    @Override
    public ApplicationDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setAppName(String appName) {
        this.descriptor.setAppName(appName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Starting app '%s'", this.descriptor.getAppName())));
        }
        try {
            this.muleContext.start();
            File marker = new File(MuleContainerBootstrapUtils.getMuleAppsDir(), String.format("%s-anchor.txt", this.getAppName()));
            FileUtils.writeStringToFile((File)marker, (String)ANCHOR_FILE_BLURB);
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(null);
                this.deployLogger.info((Object)SplashScreen.miniSplash((String)String.format("Started app '%s'", this.descriptor.getAppName())));
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        catch (MuleException e) {
            this.logger.error(null, ExceptionUtils.getRootCause((Throwable)e));
            throw new DeploymentStartException(CoreMessages.createStaticMessage((String)ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
        catch (IOException e) {
            this.logger.error(null, ExceptionUtils.getRootCause((Throwable)e));
            throw new DeploymentStartException(CoreMessages.createStaticMessage((String)ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    @Override
    public void init() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Initializing app '%s'", this.descriptor.getAppName())));
        }
        try {
            ConfigurationBuilder cfgBuilder = this.createConfigurationBuilder();
            if (!cfgBuilder.isConfigured()) {
                ArrayList<ConfigurationBuilder> builders = new ArrayList<ConfigurationBuilder>(3);
                builders.add(this.createConfigurationBuilderFromApplicationProperties());
                this.addAnnotationsConfigBuilderIfPresent(builders);
                builders.add(cfgBuilder);
                DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
                if (this.deploymentListener != null) {
                    muleContextFactory.addListener((MuleContextListener)new MuleContextDeploymentListener(this.getAppName(), this.deploymentListener));
                }
                this.muleContext = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)new ApplicationMuleContextBuilder(this.descriptor));
                if (this.descriptor.isRedeploymentEnabled()) {
                    this.createRedeployMonitor();
                }
            }
        }
        catch (Exception e) {
            this.logger.error(null, ExceptionUtils.getRootCause((Throwable)e));
            throw new DeploymentInitException(CoreMessages.createStaticMessage((String)ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    protected ConfigurationBuilder createConfigurationBuilder() throws Exception {
        String configBuilderClassName = this.determineConfigBuilderClassName();
        return (ConfigurationBuilder)ClassUtils.instanciateClass((String)configBuilderClassName, (Object[])new Object[]{this.absoluteResourcePaths}, (ClassLoader)this.getDeploymentClassLoader());
    }

    protected String determineConfigBuilderClassName() {
        String builderFromDesc = this.descriptor.getConfigurationBuilder();
        if ("spring".equalsIgnoreCase(builderFromDesc)) {
            return "org.mule.config.spring.SpringXmlConfigurationBuilder";
        }
        if (builderFromDesc == null) {
            return AutoConfigurationBuilder.class.getName();
        }
        return builderFromDesc;
    }

    protected ConfigurationBuilder createConfigurationBuilderFromApplicationProperties() {
        Map<String, String> appProperties = this.descriptor.getAppProperties();
        File appPath = new File(MuleContainerBootstrapUtils.getMuleAppsDir(), this.getAppName());
        appProperties.put("app.home", appPath.getAbsolutePath());
        appProperties.put("app.name", this.getAppName());
        return new SimpleConfigurationBuilder(appProperties);
    }

    protected void addAnnotationsConfigBuilderIfPresent(List<ConfigurationBuilder> builders) throws Exception {
        if (ClassUtils.isClassOnPath((String)"org.mule.config.AnnotationsConfigurationBuilder", this.getClass())) {
            Object configBuilder = ClassUtils.instanciateClass((String)"org.mule.config.AnnotationsConfigurationBuilder", (Object[])ClassUtils.NO_ARGS, this.getClass());
            builders.add((ConfigurationBuilder)configBuilder);
        }
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public ClassLoader getDeploymentClassLoader() {
        return this.deploymentClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            ClassLoader appCl = this.getDeploymentClassLoader();
            if (appCl != null) {
                Thread.currentThread().setContextClassLoader(appCl);
            }
            this.doDispose();
            if (appCl != null && appCl instanceof DisposableClassLoader) {
                ((DisposableClassLoader)((Object)appCl)).dispose();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(null);
        }
    }

    @Override
    public void redeploy() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Redeploying app '%s'", this.descriptor.getAppName())));
        }
        String appName = this.getAppName();
        this.deploymentListener.onUndeploymentStart(appName);
        try {
            this.dispose();
            this.deploymentListener.onUndeploymentSuccess(appName);
        }
        catch (RuntimeException e) {
            this.deploymentListener.onUndeploymentFailure(appName, e);
            throw e;
        }
        this.install();
        ClassLoader cl = this.getDeploymentClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        this.deploymentListener.onDeploymentStart(appName);
        try {
            this.init();
            this.start();
            this.deploymentListener.onDeploymentSuccess(appName);
        }
        catch (Throwable cause) {
            this.logger.error((Object)"Application deployment error", cause);
            this.deploymentListener.onDeploymentFailure(appName, cause);
        }
        Thread.currentThread().setContextClassLoader(null);
    }

    @Override
    public void stop() {
        if (this.muleContext == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)String.format("Stopping app '%s' with no mule context", this.descriptor.getAppName()));
            }
            return;
        }
        this.muleContext.getLifecycleManager().checkPhase("stop");
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Stopping app '%s'", this.descriptor.getAppName())));
            }
            this.muleContext.stop();
        }
        catch (MuleException e) {
            throw new DeploymentStopException(MessageFactory.createStaticMessage((String)this.descriptor.getAppName()), e);
        }
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getName(), this.descriptor.getAppName(), Integer.toHexString(System.identityHashCode(this)));
    }

    protected void doDispose() {
        if (this.muleContext == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)String.format("App '%s' never started, nothing to dispose of", this.descriptor.getAppName()));
            }
            return;
        }
        if (this.muleContext.isStarted() && !this.muleContext.isDisposed()) {
            try {
                this.stop();
            }
            catch (DeploymentStopException e) {
                this.logger.error((Object)e);
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Disposing app '%s'", this.descriptor.getAppName())));
        }
        this.muleContext.dispose();
        this.muleContext = null;
    }

    protected void createRedeployMonitor() throws NotificationException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Monitoring for hot-deployment: " + StringUtils.join((Object[])this.absoluteResourcePaths, (char)';')));
        }
        ArrayList<File> configFiles = new ArrayList<File>();
        for (String path : this.absoluteResourcePaths) {
            configFiles.add(new File(path));
        }
        new ConfigFileWatcher(configFiles).register();
    }

    protected void scheduleConfigMonitor(AbstractFileWatcher watcher) {
        int reloadIntervalMs = 3000;
        this.watchTimer = Executors.newSingleThreadScheduledExecutor(new ConfigChangeMonitorThreadFactory(this.descriptor.getAppName()));
        this.watchTimer.scheduleWithFixedDelay(watcher, 3000L, 3000L, TimeUnit.MILLISECONDS);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Reload interval: 3000");
        }
    }

    protected File toAbsoluteFile(String path) {
        String muleHome = System.getProperty("mule.home");
        String configPath = String.format("%s/apps/%s/%s", muleHome, this.getAppName(), path);
        return new File(configPath);
    }

    protected class FileWatcherNotificationListener
    implements MuleContextNotificationListener<MuleContextNotification> {
        private AbstractFileWatcher watcher;

        public FileWatcherNotificationListener(AbstractFileWatcher watcher) {
            this.watcher = watcher;
        }

        public void onNotification(MuleContextNotification notification) {
            int action = notification.getAction();
            switch (action) {
                case 104: {
                    DefaultMuleApplication.this.scheduleConfigMonitor(this.watcher);
                    break;
                }
                case 105: {
                    if (DefaultMuleApplication.this.watchTimer != null) {
                        DefaultMuleApplication.this.watchTimer.shutdownNow();
                    }
                    DefaultMuleApplication.this.muleContext.unregisterListener((ServerNotificationListener)this);
                }
            }
        }
    }

    protected class ConfigFileWatcher
    extends AbstractFileWatcher {
        public ConfigFileWatcher(List<File> watchedResources) {
            super(watchedResources);
        }

        public void register() throws NotificationException {
            DefaultMuleApplication.this.muleContext.registerListener((ServerNotificationListener)new FileWatcherNotificationListener(this));
        }

        @Override
        protected synchronized void onChange(File file) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("================== Reloading " + file));
            }
            ClassLoader cl = DefaultMuleApplication.this.getDeploymentClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            DefaultMuleApplication.this.redeploy();
        }
    }
}

