/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.log4j;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RepositorySelector;
import org.apache.log4j.spi.RootLogger;
import org.apache.log4j.xml.DOMConfigurator;
import org.mule.module.launcher.application.ApplicationClassLoader;
import org.mule.module.launcher.application.ShutdownListener;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.module.reboot.MuleContainerSystemClassLoader;

public class ApplicationAwareRepositorySelector
implements RepositorySelector {
    protected static final String PATTERN_LAYOUT = "%-5p %d [%t] %c: %m%n";
    protected static final Integer NO_CCL_CLASSLOADER = 0;
    protected LoggerRepositoryCache cache = new LoggerRepositoryCache();
    protected Logger logger = Logger.getLogger(this.getClass());
    protected final ThreadLocal<LoggerRepository> repositoryUnderConstruction = new ThreadLocal();

    public LoggerRepository getLoggerRepository() {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        LoggerRepository repository = this.repositoryUnderConstruction.get();
        if (repository != null) {
            return repository;
        }
        repository = this.cache.getLoggerRepository(ccl);
        if (repository == null) {
            RootLogger root = new RootLogger(Level.INFO);
            repository = new Hierarchy((Logger)root);
            this.repositoryUnderConstruction.set(repository);
            try {
                ConfigWatchDog configWatchDog = null;
                if (ccl instanceof ApplicationClassLoader) {
                    ApplicationClassLoader muleCL = (ApplicationClassLoader)((Object)ccl);
                    URL appLogConfig = this.getAppLoggingConfig(muleCL);
                    String appName = muleCL.getAppName();
                    if (appLogConfig == null) {
                        String logName = String.format("mule-app-%s.log", appName);
                        File logDir = new File(MuleContainerBootstrapUtils.getMuleHome(), "logs");
                        File logFile = new File(logDir, logName);
                        DailyRollingFileAppender fileAppender = new DailyRollingFileAppender((Layout)new PatternLayout(PATTERN_LAYOUT), logFile.getAbsolutePath(), "'.'yyyy-MM-dd");
                        fileAppender.setAppend(true);
                        fileAppender.activateOptions();
                        root.addAppender((Appender)fileAppender);
                    } else {
                        this.configureFrom(appLogConfig, repository);
                        if (appLogConfig.toExternalForm().startsWith("file:")) {
                            configWatchDog = new ConfigWatchDog(ccl, appLogConfig.getFile(), repository);
                            configWatchDog.setName(String.format("[%s].log4j.config.monitor", appName));
                        } else if (this.logger.isInfoEnabled()) {
                            this.logger.info((Object)String.format("Logging config %s is not an external file, will not be monitored for changes", appLogConfig));
                        }
                    }
                } else {
                    File defaultSystemLog = new File(MuleContainerBootstrapUtils.getMuleHome(), "conf/log4j.xml");
                    if (!defaultSystemLog.exists() && !defaultSystemLog.canRead()) {
                        defaultSystemLog = new File(MuleContainerBootstrapUtils.getMuleHome(), "conf/log4j.properties");
                    }
                    this.configureFrom(defaultSystemLog.toURL(), repository);
                    if (ccl instanceof MuleContainerSystemClassLoader) {
                        configWatchDog = new ConfigWatchDog(ccl, defaultSystemLog.getAbsolutePath(), repository);
                        configWatchDog.setName("Mule.system.log4j.config.monitor");
                    }
                }
                LoggerRepository previous = this.cache.storeLoggerRepository(ccl, repository);
                if (previous != null) {
                    repository = previous;
                } else if (configWatchDog != null) {
                    configWatchDog.start();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.repositoryUnderConstruction.remove();
            }
        }
        return repository;
    }

    private URL getAppLoggingConfig(ApplicationClassLoader muleCL) {
        URL appLogConfig = muleCL.findResource("log4j.xml");
        if (appLogConfig == null) {
            appLogConfig = muleCL.findResource("log4j.properties");
        }
        if (appLogConfig != null && this.logger.isInfoEnabled()) {
            this.logger.info((Object)String.format("Found logging config for application '%s' at '%s'", muleCL.getAppName(), appLogConfig));
        }
        return appLogConfig;
    }

    protected void configureFrom(URL url, LoggerRepository repository) {
        if (url.toExternalForm().endsWith(".xml")) {
            new DOMConfigurator().doConfigure(url, repository);
        } else {
            new PropertyConfigurator().doConfigure(url, repository);
        }
    }

    protected class ConfigWatchDog
    extends Thread {
        protected LoggerRepository repository;
        protected File file;
        protected long lastModif = 0L;
        protected boolean warnedAlready = false;
        protected volatile boolean interrupted = false;
        public static final long DEFAULT_DELAY = 60000L;
        protected String filename;
        protected long delay = 60000L;

        public ConfigWatchDog(ClassLoader classLoader, String filename, LoggerRepository repository) {
            if (classLoader instanceof ApplicationClassLoader) {
                ((ApplicationClassLoader)((Object)classLoader)).addShutdownListener(new ShutdownListener(){

                    @Override
                    public void execute() {
                        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
                        ApplicationAwareRepositorySelector.this.cache.remove(ccl);
                        ConfigWatchDog.this.interrupt();
                    }
                });
            }
            this.filename = filename;
            this.file = new File(filename);
            this.lastModif = this.file.lastModified();
            this.setDaemon(true);
            this.repository = repository;
            this.delay = 10000L;
        }

        public void doOnChange() {
            if (ApplicationAwareRepositorySelector.this.logger.isInfoEnabled()) {
                ApplicationAwareRepositorySelector.this.logger.info((Object)("Reconfiguring logging from: " + this.filename));
            }
            if (this.filename.endsWith(".xml")) {
                new DOMConfigurator().doConfigure(this.filename, this.repository);
            } else {
                new PropertyConfigurator().doConfigure(this.filename, this.repository);
            }
        }

        public void setDelay(long delay) {
            this.delay = delay;
        }

        protected void checkAndConfigure() {
            boolean fileExists;
            try {
                fileExists = this.file.exists();
            }
            catch (SecurityException e) {
                LogLog.warn((String)("Was not allowed to read check file existence, file:[" + this.filename + "]."));
                this.interrupted = true;
                return;
            }
            if (fileExists) {
                long l = this.file.lastModified();
                if (l > this.lastModif) {
                    this.lastModif = l;
                    this.doOnChange();
                    this.warnedAlready = false;
                }
            } else if (!this.warnedAlready) {
                LogLog.debug((String)("[" + this.filename + "] does not exist."));
                this.warnedAlready = true;
            }
        }

        @Override
        public void run() {
            while (!this.interrupted) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException e) {
                    this.interrupted = true;
                    Thread.currentThread().interrupt();
                    break;
                }
                this.checkAndConfigure();
            }
            if (ApplicationAwareRepositorySelector.this.logger.isDebugEnabled()) {
                ApplicationAwareRepositorySelector.this.logger.debug((Object)(this.getName() + " terminated successfully"));
            }
        }
    }

    protected static class LoggerRepositoryCache {
        protected ConcurrentMap<Integer, LoggerRepository> repositories = new ConcurrentHashMap<Integer, LoggerRepository>();

        protected LoggerRepositoryCache() {
        }

        public LoggerRepository getLoggerRepository(ClassLoader classLoader) {
            return (LoggerRepository)this.repositories.get(this.computeKey(classLoader));
        }

        public LoggerRepository storeLoggerRepository(ClassLoader classLoader, LoggerRepository repository) {
            return this.repositories.putIfAbsent(this.computeKey(classLoader), repository);
        }

        public void remove(ClassLoader classLoader) {
            this.repositories.remove(this.computeKey(classLoader));
        }

        protected Integer computeKey(ClassLoader classLoader) {
            return classLoader == null ? NO_CCL_CLASSLOADER.intValue() : classLoader.hashCode();
        }
    }
}

