/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.util;

import com.envoisolutions.sxc.util.XoXMLStreamWriter;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XoXMLStreamWriterImpl
implements XoXMLStreamWriter {
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private XMLStreamWriter delegate;
    private DefaultNamespace defaultNamespace = new DefaultNamespace();

    public XoXMLStreamWriterImpl(XMLStreamWriter writer) {
        this.delegate = writer;
        try {
            this.delegate.setPrefix("xml", "http://www.w3.org/XML/1998/namespace");
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeXsiNil() throws XMLStreamException {
        String prefix = this.getUniquePrefix(XSI_NS, true);
        this.writeAttribute(prefix, XSI_NS, "nil", "true");
    }

    @Override
    public void writeAndDeclareIfUndeclared(String prefix, String namespace) throws XMLStreamException {
        if (!namespace.equals(this.defaultNamespace.getNamespaceURI()) && this.getPrefix(namespace) == null) {
            this.writeNamespace(prefix, namespace);
            this.setPrefix(prefix, namespace);
        }
    }

    private void writeAndDeclareIfUndeclared(String prefix, String namespace, boolean useExactPrefix) throws XMLStreamException {
        if (prefix.startsWith("xml")) {
            return;
        }
        if (useExactPrefix) {
            Iterator<String> prefixes = this.getNamespaceContext().getPrefixes(namespace);
            while (prefixes.hasNext()) {
                if (!prefix.equals(prefixes.next())) continue;
                return;
            }
        } else if (!namespace.equals(this.defaultNamespace.getNamespaceURI()) && this.getPrefix(namespace) == null) {
            return;
        }
        this.writeNamespace(prefix, namespace);
        this.setPrefix(prefix, namespace);
    }

    @Override
    public void writeQName(QName q) throws XMLStreamException {
        String prefix = q.getPrefix();
        if (prefix.length() > 0) {
            this.writeAndDeclareIfUndeclared(prefix, q.getNamespaceURI(), true);
        } else if (!q.getNamespaceURI().equals(this.defaultNamespace.getNamespaceURI())) {
            prefix = this.getUniquePrefix(q.getNamespaceURI(), true);
        }
        if (prefix.length() > 0) {
            this.writeCharacters(prefix);
            this.writeCharacters(":");
        }
        this.writeCharacters(q.getLocalPart());
    }

    @Override
    public String getQNameAsString(QName q) throws XMLStreamException {
        String prefix = q.getPrefix();
        if (prefix.length() > 0) {
            this.setPrefix(prefix, q.getNamespaceURI());
        } else {
            prefix = this.getUniquePrefix(q.getNamespaceURI(), true);
        }
        if (prefix.length() > 0) {
            return prefix + ":" + q.getLocalPart();
        }
        return q.getLocalPart();
    }

    @Override
    public void writeDomElement(Element element, boolean writeTag) throws XMLStreamException {
        if (writeTag) {
            String namespaceURI = element.getNamespaceURI();
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            this.writeStartElementWithAutoPrefix(namespaceURI, element.getLocalName());
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String prefix = "";
            String attributeNamespace = attribute.getNamespaceURI();
            if (attributeNamespace != null) {
                prefix = "http://www.w3.org/XML/1998/namespace".equals(attributeNamespace) ? "xml" : this.getUniquePrefix(attributeNamespace);
            }
            this.writeAttribute(prefix, attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getValue());
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child instanceof Element) {
                Element childElement = (Element)child;
                this.writeDomElement(childElement, true);
                continue;
            }
            if (child instanceof CDATASection) {
                CDATASection cdataSection = (CDATASection)child;
                this.writeCData(cdataSection.getData());
                continue;
            }
            if (child instanceof Text) {
                Text text = (Text)child;
                this.writeString(text.getData());
                continue;
            }
            if (child instanceof Comment) {
                Comment comment = (Comment)child;
                this.writeComment(comment.getData());
                continue;
            }
            if (!(child instanceof Attr) && !(child instanceof Document) && !(child instanceof DocumentFragment) && !(child instanceof DocumentType) && !(child instanceof Entity) && !(child instanceof EntityReference) && !(child instanceof Notation) && !(child instanceof ProcessingInstruction)) continue;
        }
        if (writeTag) {
            this.writeEndElement();
        }
    }

    @Override
    public void writeXsiType(String namespace, String local) throws XMLStreamException {
        String prefix = this.getUniquePrefix(namespace, true);
        String value = prefix.equals("") ? local : prefix + ":" + local;
        String xsiP = this.getPrefix(XSI_NS);
        if (xsiP == null) {
            xsiP = "xsi";
            this.writeNamespace("xsi", XSI_NS);
        }
        this.writeAttribute(xsiP, XSI_NS, "type", value);
    }

    @Override
    public String getUniquePrefix(String namespaceURI) throws XMLStreamException {
        return this.getUniquePrefix(namespaceURI, true);
    }

    @Override
    public void writeAsXmlList(Collection<Object> values) throws XMLStreamException {
        for (Object value : values) {
            this.writeCharacters(value.toString());
            this.writeCharacters(" ");
        }
    }

    @Override
    public void writeAsXmlList(Object[] values) throws XMLStreamException {
        for (Object value : values) {
            this.writeCharacters(value.toString());
            this.writeCharacters(" ");
        }
    }

    @Override
    public void writeAsXmlList(boolean[] values) throws XMLStreamException {
        for (boolean value : values) {
            this.writeBoolean(value);
            this.writeCharacters(" ");
        }
    }

    @Override
    public void writeAsXmlList(short[] values) throws XMLStreamException {
        for (short value : values) {
            this.writeShort(value);
            this.writeCharacters(" ");
        }
    }

    @Override
    public void writeAsXmlList(int[] values) throws XMLStreamException {
        for (int value : values) {
            this.writeInt(value);
            this.writeCharacters(" ");
        }
    }

    @Override
    public void writeAsXmlList(long[] values) throws XMLStreamException {
        for (long value : values) {
            this.writeLong(value);
            this.writeCharacters(" ");
        }
    }

    @Override
    public void writeAsXmlList(float[] values) throws XMLStreamException {
        for (float value : values) {
            this.writeFloat(value);
            this.writeCharacters(" ");
        }
    }

    @Override
    public void writeAsXmlList(double[] values) throws XMLStreamException {
        for (double value : values) {
            this.writeDouble(value);
            this.writeCharacters(" ");
        }
    }

    public String getUniquePrefix(String namespaceURI, boolean declare) throws XMLStreamException {
        if ("".equals(namespaceURI)) {
            return "";
        }
        if (namespaceURI.equals(this.defaultNamespace.getNamespaceURI())) {
            return "";
        }
        String prefix = this.getNamespaceContext().getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getUniquePrefix();
            if (declare) {
                this.setPrefix(prefix, namespaceURI);
                this.writeNamespace(prefix, namespaceURI);
            }
        }
        return prefix;
    }

    public String getUniquePrefix() {
        int n = 1;
        while (true) {
            String nsPrefix = "ns" + n;
            if (this.getNamespaceContext().getNamespaceURI(nsPrefix) == null) {
                return nsPrefix;
            }
            ++n;
        }
    }

    @Override
    public void writeString(String s) throws XMLStreamException {
        if (s == null) {
            return;
        }
        this.writeCharacters(s);
    }

    @Override
    public void writeBoolean(boolean b) throws XMLStreamException {
        this.writeCharacters(Boolean.toString(b));
    }

    @Override
    public void writeDouble(double b) throws XMLStreamException {
        this.writeCharacters(Double.toString(b));
    }

    @Override
    public void writeFloat(float b) throws XMLStreamException {
        this.writeCharacters(Float.toString(b));
    }

    @Override
    public void writeLong(long b) throws XMLStreamException {
        this.writeCharacters(Long.toString(b));
    }

    @Override
    public void writeShort(short b) throws XMLStreamException {
        this.writeCharacters(Short.toString(b));
    }

    @Override
    public void writeByte(byte b) throws XMLStreamException {
        this.writeCharacters(Byte.toString(b));
    }

    @Override
    public void writeInt(int i) throws XMLStreamException {
        this.writeCharacters(Integer.toString(i));
    }

    @Override
    public void writeStartElementWithAutoPrefix(String namespaceURI, String localName) throws XMLStreamException {
        String prefix = namespaceURI.equals(this.defaultNamespace.getNamespaceURI()) ? "" : this.getNamespaceContext().getPrefix(namespaceURI);
        boolean declareNs = false;
        if (prefix == null) {
            prefix = "";
            declareNs = true;
        }
        this.writeStartElement(prefix, localName, namespaceURI);
        if (declareNs) {
            this.writeDefaultNamespace(namespaceURI);
        }
    }

    @Override
    public void close() throws XMLStreamException {
        this.delegate.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.delegate.flush();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.delegate.getPrefix(uri);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.delegate.getProperty(name);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.delegate.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext arg0) throws XMLStreamException {
        this.delegate.setNamespaceContext(arg0);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.delegate.setPrefix(prefix, uri);
    }

    @Override
    public void writeAttribute(QName name, String value) throws XMLStreamException {
        String prefix = name.getPrefix();
        if (prefix.length() > 0) {
            this.writeAndDeclareIfUndeclared(prefix, name.getNamespaceURI(), true);
        } else if (!name.getNamespaceURI().equals(this.defaultNamespace.getNamespaceURI())) {
            prefix = this.getUniquePrefix(name.getNamespaceURI(), true);
        }
        this.delegate.writeAttribute(prefix, name.getNamespaceURI(), name.getLocalPart(), value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(localName, value);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.delegate.writeCData(data);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.delegate.writeCharacters(text, start, len);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.delegate.writeCharacters(text);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.delegate.writeComment(data);
    }

    @Override
    public void writeDefaultNamespace(String uri) throws XMLStreamException {
        this.defaultNamespace.setNamespaceURI(uri);
        this.delegate.writeDefaultNamespace(uri);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.delegate.writeDTD(dtd);
    }

    @Override
    public void writeEmptyElement(String prefix, String namespaceURI, String localName) throws XMLStreamException {
        this.delegate.writeEmptyElement(prefix, namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.delegate.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.delegate.writeEmptyElement(localName);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.delegate.writeEndDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.delegate.writeEndElement();
        this.defaultNamespace = this.defaultNamespace.getParent();
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.delegate.writeEntityRef(name);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.delegate.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(target);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.delegate.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.delegate.writeStartDocument(encoding, version);
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.delegate.writeStartDocument(version);
    }

    @Override
    public void writeStartElement(String prefix, String namespaceURI, String localName) throws XMLStreamException {
        this.defaultNamespace = new DefaultNamespace(this.defaultNamespace);
        this.delegate.writeStartElement(prefix, namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.defaultNamespace = new DefaultNamespace(this.defaultNamespace);
        this.delegate.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.defaultNamespace = new DefaultNamespace(this.defaultNamespace);
        this.delegate.writeStartElement(localName);
    }

    private static class DefaultNamespace {
        private final DefaultNamespace parent;
        private String namespaceURI;

        private DefaultNamespace() {
            this.parent = null;
        }

        private DefaultNamespace(DefaultNamespace parent) {
            if (parent == null) {
                throw new NullPointerException("parent is null");
            }
            this.parent = parent;
        }

        public DefaultNamespace getParent() {
            if (this.parent == null) {
                throw new IllegalAccessError("parent is null");
            }
            return this.parent;
        }

        public String getNamespaceURI() {
            if (this.namespaceURI != null) {
                return this.namespaceURI;
            }
            if (this.parent == null) {
                return null;
            }
            return this.parent.getNamespaceURI();
        }

        public void setNamespaceURI(String namespaceURI) {
            if (this.namespaceURI != null) {
                throw new IllegalStateException("Default namespace is alreayd set to " + this.namespaceURI);
            }
            this.namespaceURI = namespaceURI;
        }
    }
}

