/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.support;

import java.util.ArrayList;
import java.util.Collection;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.mule.api.MuleContext;
import org.mule.module.management.support.JmxRegistrationContext;
import org.mule.module.management.support.JmxSupport;
import org.mule.util.StringUtils;

public abstract class AbstractJmxSupport
implements JmxSupport {
    protected String resolveDomainClash(String domain) {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers.isEmpty()) {
            throw new IllegalStateException("MBeanServer is not available.");
        }
        MBeanServer server = (MBeanServer)servers.get(0);
        Collection registeredDomains = this.getDomains(server);
        int counter = 1;
        if (registeredDomains.contains(domain)) {
            domain = domain + "." + counter;
        }
        while (registeredDomains.contains(domain)) {
            domain = domain.substring(0, domain.lastIndexOf(".") + 1) + ++counter;
        }
        return domain;
    }

    protected abstract Collection getDomains(MBeanServer var1);

    @Override
    public String getDomainName(MuleContext context) {
        return this.getDomainName(context, true);
    }

    @Override
    public String getDomainName(MuleContext context, boolean resolveClash) {
        String domain = "Mule";
        String instanceId = StringUtils.defaultString((String)context.getConfiguration().getId());
        if (instanceId.length() > 0) {
            domain = domain + "." + instanceId;
        }
        JmxRegistrationContext ctx = JmxRegistrationContext.getCurrent(context);
        String resolvedDomain = ctx.getResolvedDomain();
        if (resolveClash && StringUtils.isBlank((String)resolvedDomain)) {
            domain = this.resolveDomainClash(domain);
            ctx.setResolvedDomain(domain);
        }
        return domain;
    }
}

