/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.uri;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.mule.module.apikit.uri.Matchable;
import org.mule.module.apikit.uri.TokenBase;
import org.mule.module.apikit.uri.URICoder;
import org.mule.module.apikit.uri.Variable;

public class TokenOperatorPS
extends TokenBase
implements Matchable {
    private Operator _operator;
    private List<Variable> _vars;
    private Pattern _pattern;

    public TokenOperatorPS(Operator op, Variable var) throws NullPointerException {
        super(TokenOperatorPS.toExpression(op, var));
        if (op == null || var == null) {
            throw new NullPointerException("The operator must have a value");
        }
        this._operator = op;
        this._vars = new ArrayList<Variable>(1);
        this._vars.add(var);
        this._pattern = op.pattern(this._vars);
    }

    public Operator operator() {
        return this._operator;
    }

    @Override
    public boolean isResolvable() {
        return this._operator.isResolvable(this._vars);
    }

    @Override
    public boolean resolve(String expanded, Map<Variable, Object> values) {
        if (this.isResolvable()) {
            this._operator.resolve(this._vars, expanded, values);
            return true;
        }
        return false;
    }

    @Override
    public boolean match(String part) {
        return this._pattern.matcher(part).matches();
    }

    @Override
    public Pattern pattern() {
        return this._pattern;
    }

    private static String toExpression(Operator op, Variable var) {
        return "{" + op.character() + var.name() + '}';
    }

    public static enum Operator {
        URI_INSERT('+'){

            @Override
            boolean resolve(List<Variable> vars, String value, Map<Variable, Object> values) {
                if (vars.size() != 1) {
                    throw new UnsupportedOperationException("Operator + cannot be resolved with multiple variables.");
                }
                values.put(vars.get(0), URICoder.decode(value));
                return true;
            }

            @Override
            boolean isResolvable(List<Variable> vars) {
                return vars.size() == 1;
            }

            @Override
            Pattern pattern(List<Variable> vars) {
                return Pattern.compile("[^?#]*");
            }
        };

        private final char _c;

        private Operator(char c) {
            this._c = c;
        }

        public char character() {
            return this._c;
        }

        abstract boolean isResolvable(List<Variable> var1);

        abstract Pattern pattern(List<Variable> var1);

        abstract boolean resolve(List<Variable> var1, String var2, Map<Variable, Object> var3);
    }
}

