/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form.transformation;

import java.io.IOException;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.transformation.Multipart;
import org.mule.module.apikit.validation.body.form.transformation.MultipartEntityBuilder;
import org.mule.module.apikit.validation.body.form.transformation.MultipartFormDataBinaryParameter;
import org.mule.module.apikit.validation.body.form.transformation.MultipartWithDefaults;
import org.mule.runtime.api.metadata.MediaType;

public class MultipartEntityBuilderWithDefaults
extends MultipartEntityBuilder {
    private final org.apache.http.entity.mime.MultipartEntityBuilder entityBuilder;

    public MultipartEntityBuilderWithDefaults(String boundary, long sizeLimit) {
        super(boundary, sizeLimit);
        this.entityBuilder = org.apache.http.entity.mime.MultipartEntityBuilder.create().setBoundary(boundary);
    }

    @Override
    public void handleBinaryPart(MultipartStream multipartStream, Parameter parameter, String name, String contentType, String fileName, String headers) throws InvalidFormParameterException {
        try {
            byte[] buf = this.partToByteArray(multipartStream);
            if (parameter != null) {
                new MultipartFormDataBinaryParameter(buf.length, MediaType.parse((String)contentType)).validate(parameter);
            }
            this.addPart(name, buf, contentType, fileName, headers);
        }
        catch (IOException e) {
            throw new InvalidFormParameterException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidFormParameterException(e.getMessage());
        }
    }

    @Override
    public void addDefault(String key, String value) throws InvalidFormParameterException {
        StringBody stringBody = new StringBody(value, ContentType.DEFAULT_TEXT);
        FormBodyPart formBodyPart = FormBodyPartBuilder.create((String)key, (ContentBody)stringBody).build();
        this.entityBuilder.addPart(formBodyPart);
        this.handleFormBodyPart(formBodyPart);
    }

    @Override
    public Multipart getOutput() {
        return new MultipartWithDefaults(this.entityBuilder.build(), this.preamble, this.epilogue, this.contentLength);
    }

    @Override
    protected void addPart(String name, byte[] buf, String contentType, String fileName, String headers) throws InvalidFormParameterException {
        FormBodyPartBuilder formBodyPartBuilder = FormBodyPartBuilder.create((String)name, (ContentBody)new ByteArrayBody(buf, ContentType.parse((String)contentType), fileName));
        this.getHeaders(headers).forEach((arg_0, arg_1) -> ((FormBodyPartBuilder)formBodyPartBuilder).addField(arg_0, arg_1));
        FormBodyPart formBodyPart = formBodyPartBuilder.build();
        this.entityBuilder.addPart(formBodyPart);
        this.handleFormBodyPart(formBodyPart);
    }
}

