/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mule.module.apikit.utils.MuleVersionUtils;
import org.mule.runtime.core.api.config.MuleManifest;

public class MuleVersionUtilsTest {
    @Test
    public void newerVersionIsAtLeastTest() {
        Assert.assertTrue((boolean)this.isAtLeast("4.3.0", "4.2.0"));
    }

    @Test
    public void newerSnapshotVersionIsAtLeastTest() {
        Assert.assertTrue((boolean)this.isAtLeast("4.3.0-SNAPSHOT", "4.2.0"));
    }

    @Test
    public void olderVersionIsAtLeastTest() {
        Assert.assertFalse((boolean)this.isAtLeast("4.1.0", "4.2.0"));
    }

    @Test
    public void olderSnapshotVersionIsAtLeastTest() {
        Assert.assertFalse((boolean)this.isAtLeast("4.1.0-SNAPSHOT", "4.2.0"));
    }

    @Test
    public void sameVersionIsAtLeastTest() {
        Assert.assertTrue((boolean)this.isAtLeast("4.2.0", "4.2.0"));
    }

    @Test
    public void snapshotVersionIsAtLeastTest() {
        Assert.assertTrue((boolean)this.isAtLeast("4.2.0-SNAPSHOT", "4.2.0"));
    }

    @Test
    public void hotFixVersionIsAtLeastTest() {
        Assert.assertTrue((boolean)this.isAtLeast("4.2.0-hf1", "4.2.0"));
    }

    @Test
    public void hotFixWithDateSuffixVersionIsAtLeastTest() {
        Assert.assertTrue((boolean)this.isAtLeast("4.2.0-20200525", "4.2.0"));
    }

    @Test
    public void releaseCandidateVersionIsAtLeastTest() {
        Assert.assertTrue((boolean)this.isAtLeast("4.2.0-rc1", "4.2.0"));
    }

    @Test
    public void invalidVersionIsAtLeastTest() {
        Assert.assertFalse((boolean)this.isAtLeast("4.2.0", "a.b.3"));
    }

    @Test
    public void blankVersionIsAtLeastTest() {
        Assert.assertFalse((boolean)this.isAtLeast("4.2.0", " "));
    }

    @Test
    public void nullVersionIsAtLeastTest() {
        Assert.assertFalse((boolean)this.isAtLeast("4.2.0", null));
    }

    private Boolean isAtLeast(String productVersion, String version) {
        try (MockedStatic mockedManifest = Mockito.mockStatic(MuleManifest.class);){
            mockedManifest.when(MuleManifest::getProductVersion).thenReturn((Object)productVersion);
            Boolean bl = MuleVersionUtils.isAtLeast((String)version);
            return bl;
        }
    }
}

