/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.io.IOException;
import java.util.HashSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.apikit.api.RamlHandler;
import org.mule.module.apikit.api.RoutingTable;
import org.mule.module.apikit.api.uri.URIPattern;
import org.mule.module.apikit.api.uri.URIResolver;
import org.mule.module.apikit.uri.URIResolveResult;
import org.mule.runtime.core.api.MuleContext;

public class RoutingTableTestCase {
    private static RamlHandler ramlHandler;
    private static MuleContext muleContext;

    @BeforeClass
    public static void beforeAll() throws IOException {
        muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)muleContext.getExecutionClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        ramlHandler = new RamlHandler("unit/routing-table-sample.raml", true, muleContext.getErrorTypeRepository());
    }

    @Test
    public void testResourceFlattenedTree() {
        RoutingTable routingTable = new RoutingTable(ramlHandler.getApi());
        Assert.assertThat((Object)routingTable.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new URIPattern[]{new URIPattern("/single-resource"), new URIPattern("/api/sub-resource"), new URIPattern("/api/sub-resource-types")}));
    }

    @Test
    public void emptyParametersAreMatchedButNotResolved() {
        URIPattern pattern = new URIPattern("/api/{parameter}/list");
        Assert.assertTrue((boolean)pattern.match("/api//list"));
        URIResolver resolver = new URIResolver("/api//list");
        Assert.assertEquals((Object)URIResolveResult.Status.ERROR, (Object)resolver.resolve(pattern).getStatus());
    }

    @Test
    public void URIWithTrailingForwardSlashAreMatchedAndResolvedCorrectly() {
        URIPattern pattern1 = new URIPattern("/api/hello/");
        URIPattern pattern2 = new URIPattern("/");
        URIPattern pattern3 = new URIPattern("/{param}");
        URIPattern pattern4 = new URIPattern("/api/hello/{param}");
        URIPattern pattern5 = new URIPattern("/api/hello/{param}/all");
        URIPattern pattern6 = new URIPattern("/api/hello");
        URIPattern pattern7 = new URIPattern("/{param}/");
        HashSet<URIPattern> patterns = new HashSet<URIPattern>();
        patterns.add(pattern1);
        patterns.add(pattern2);
        patterns.add(pattern3);
        patterns.add(pattern4);
        patterns.add(pattern5);
        patterns.add(pattern6);
        patterns.add(pattern7);
        URIResolver resolver1 = new URIResolver("/api/hello/");
        URIPattern bestPattern1 = resolver1.find(patterns, URIResolver.MatchRule.BEST_MATCH);
        Assert.assertEquals((Object)URIResolveResult.Status.RESOLVED, (Object)resolver1.resolve(bestPattern1).getStatus());
        Assert.assertEquals((Object)pattern1, (Object)bestPattern1);
        URIResolver resolver2 = new URIResolver("/");
        URIPattern bestPattern2 = resolver2.find(patterns, URIResolver.MatchRule.BEST_MATCH);
        Assert.assertEquals((Object)URIResolveResult.Status.RESOLVED, (Object)resolver2.resolve(bestPattern2).getStatus());
        Assert.assertEquals((Object)pattern2, (Object)bestPattern2);
        URIResolver resolver3 = new URIResolver("/api");
        URIPattern bestPattern3 = resolver3.find(patterns, URIResolver.MatchRule.BEST_MATCH);
        Assert.assertEquals((Object)URIResolveResult.Status.RESOLVED, (Object)resolver3.resolve(bestPattern3).getStatus());
        Assert.assertEquals((Object)pattern3, (Object)bestPattern3);
        URIResolver resolver7 = new URIResolver("/api/");
        URIPattern bestPattern7 = resolver7.find(patterns, URIResolver.MatchRule.BEST_MATCH);
        Assert.assertEquals((Object)URIResolveResult.Status.RESOLVED, (Object)resolver7.resolve(bestPattern7).getStatus());
        Assert.assertEquals((Object)pattern7, (Object)bestPattern7);
    }

    @Test
    public void URIWithTrailingForwardSlashAreNotMatched() {
        HashSet<URIPattern> patterns = new HashSet<URIPattern>();
        patterns.add(new URIPattern("/api/hello/{param}"));
        patterns.add(new URIPattern("/api/hello/{param}/all"));
        patterns.add(new URIPattern("/api/hello"));
        patterns.add(new URIPattern("/api/"));
        URIResolver resolver1 = new URIResolver("/api/hello/");
        Assert.assertNull((Object)resolver1.find(patterns, URIResolver.MatchRule.BEST_MATCH));
        URIResolver resolver3 = new URIResolver("/api");
        Assert.assertNull((Object)resolver3.find(patterns, URIResolver.MatchRule.BEST_MATCH));
        patterns.add(new URIPattern("/{param}"));
        URIResolver resolver2 = new URIResolver("/");
        Assert.assertNull((Object)resolver2.find(patterns, URIResolver.MatchRule.BEST_MATCH));
    }

    @Test
    public void getResourceByPattern() {
        RoutingTable routingTable = new RoutingTable(ramlHandler.getApi());
        Assert.assertNotNull((Object)routingTable.getResource(new URIPattern("/single-resource")));
        Assert.assertNotNull((Object)routingTable.getResource(new URIPattern("/api/sub-resource")));
    }

    @Test
    public void getResourceByString() {
        RoutingTable routingTable = new RoutingTable(ramlHandler.getApi());
        Assert.assertNotNull((Object)routingTable.getResource("/single-resource"));
        Assert.assertNotNull((Object)routingTable.getResource("/api/sub-resource"));
    }
}

