/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.console;

import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.apikit.api.RamlHandler;
import org.mule.module.apikit.api.UrlUtils;
import org.mule.parser.service.ParserMode;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.core.api.MuleContext;

public class BaseUriReplacementTestCase {
    private static final String FULL_DOMAIN = "fullDomain";
    private static MuleContext muleContext;

    @BeforeClass
    public static void beforeAll() {
        muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)muleContext.getExecutionClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
    }

    @Test
    public void baseUriReplacementTest() throws Exception {
        ErrorTypeRepository errorRepo = muleContext.getErrorTypeRepository();
        RamlHandler ramlHandler = new RamlHandler(null, "unit/console/simple-with-baseuri10.raml", false, errorRepo, ParserMode.AUTO);
        Assert.assertEquals((Object)"http://localhost:8081/api", (Object)ramlHandler.getBaseUriReplacement("http://localhost:8081/api"));
        Assert.assertEquals((Object)"http://localhost:8081/api", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081/api"));
        System.setProperty(FULL_DOMAIN, "pepe.cloudhub.io");
        Assert.assertEquals((Object)"http://localhost:8081/api", (Object)ramlHandler.getBaseUriReplacement("http://localhost:8081/api"));
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/api", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081/api"));
        System.setProperty(FULL_DOMAIN, "http://pepe.cloudhub.io");
        Assert.assertEquals((Object)"http://localhost:8081/api", (Object)ramlHandler.getBaseUriReplacement("http://localhost:8081/api"));
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/api", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081/api"));
        System.setProperty(FULL_DOMAIN, "http://pepe.cloudhub.io/");
        Assert.assertEquals((Object)"http://localhost:8081/api", (Object)ramlHandler.getBaseUriReplacement("http://localhost:8081/api"));
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/api", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081/api"));
        System.setProperty(FULL_DOMAIN, "pepe.cloudhub.io/");
        Assert.assertEquals((Object)"http://localhost:8081/api", (Object)ramlHandler.getBaseUriReplacement("http://localhost:8081/api"));
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/api", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081/api"));
        System.setProperty(FULL_DOMAIN, "pepe.cloudhub.io");
        Assert.assertEquals((Object)"http://localhost:8081/api/", (Object)ramlHandler.getBaseUriReplacement("http://localhost:8081/api/"));
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/api/", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081/api/"));
        System.setProperty(FULL_DOMAIN, "http://pepe.cloudhub.io");
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/api/", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081/api/"));
        System.setProperty(FULL_DOMAIN, "http://pepe.cloudhub.io/");
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/api/", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081/api/"));
        System.setProperty(FULL_DOMAIN, "pepe.cloudhub.io/");
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/api/", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081/api/"));
        System.setProperty(FULL_DOMAIN, "pepe.cloudhub.io");
        Assert.assertEquals((Object)"http://localhost:8081/", (Object)ramlHandler.getBaseUriReplacement("http://localhost:8081/"));
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081/"));
        System.setProperty(FULL_DOMAIN, "http://pepe.cloudhub.io");
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081/"));
        System.setProperty(FULL_DOMAIN, "http://pepe.cloudhub.io/");
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081/"));
        System.setProperty(FULL_DOMAIN, "pepe.cloudhub.io/");
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081/"));
        System.setProperty(FULL_DOMAIN, "pepe.cloudhub.io");
        Assert.assertEquals((Object)"http://localhost:8081", (Object)ramlHandler.getBaseUriReplacement("http://localhost:8081"));
        Assert.assertEquals((Object)"http://pepe.cloudhub.io", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081"));
        System.setProperty(FULL_DOMAIN, "http://pepe.cloudhub.io");
        Assert.assertEquals((Object)"http://pepe.cloudhub.io", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081"));
        System.setProperty(FULL_DOMAIN, "http://pepe.cloudhub.io/");
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081"));
        System.setProperty(FULL_DOMAIN, "pepe.cloudhub.io/");
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081"));
        System.setProperty(FULL_DOMAIN, "pepe.cloudhub.io/api");
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/api", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081"));
        System.setProperty(FULL_DOMAIN, "http://pepe.cloudhub.io/api");
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/api", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081"));
        System.setProperty(FULL_DOMAIN, "http://pepe.cloudhub.io/api");
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/api", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081"));
        System.setProperty(FULL_DOMAIN, "pepe.cloudhub.io/api");
        Assert.assertEquals((Object)"http://pepe.cloudhub.io/api", (Object)ramlHandler.getBaseUriReplacement("http://0.0.0.0:8081"));
    }

    @Test
    public void consoleUriReplacementTest() {
        Assert.assertEquals((Object)"http://localhost:8081/console", (Object)UrlUtils.getBaseUriReplacement((String)"http://localhost:8081/console"));
        Assert.assertEquals((Object)"http://localhost:8081/console/", (Object)UrlUtils.getBaseUriReplacement((String)"http://localhost:8081/console/"));
        System.setProperty(FULL_DOMAIN, "http://aamura.cloudhub.io/api");
        Assert.assertEquals((Object)"http://aamura.cloudhub.io/api/console", (Object)UrlUtils.getBaseUriReplacement((String)"http://0.0.0.0:8081/console"));
        Assert.assertEquals((Object)"http://aamura.cloudhub.io/api/console/", (Object)UrlUtils.getBaseUriReplacement((String)"http://0.0.0.0:8081/console/"));
        System.setProperty(FULL_DOMAIN, "http://aamura.cloudhub.io/api/");
        Assert.assertEquals((Object)"http://aamura.cloudhub.io/api/console", (Object)UrlUtils.getBaseUriReplacement((String)"http://0.0.0.0:8081/console"));
        Assert.assertEquals((Object)"http://aamura.cloudhub.io/api/console/", (Object)UrlUtils.getBaseUriReplacement((String)"http://0.0.0.0:8081/console/"));
        System.setProperty(FULL_DOMAIN, "https://aamura.cloudhub.io/api");
        Assert.assertEquals((Object)"https://aamura.cloudhub.io/api/console", (Object)UrlUtils.getBaseUriReplacement((String)"http://0.0.0.0:8081/console"));
        Assert.assertEquals((Object)"https://aamura.cloudhub.io/api/console/", (Object)UrlUtils.getBaseUriReplacement((String)"http://0.0.0.0:8081/console/"));
        System.setProperty(FULL_DOMAIN, "https://aamura.cloudhub.io/api/");
        Assert.assertEquals((Object)"https://aamura.cloudhub.io/api/console", (Object)UrlUtils.getBaseUriReplacement((String)"http://0.0.0.0:8081/console"));
        Assert.assertEquals((Object)"https://aamura.cloudhub.io/api/console/", (Object)UrlUtils.getBaseUriReplacement((String)"http://0.0.0.0:8081/console/"));
        System.setProperty(FULL_DOMAIN, "https://aamura.cloudhub.io/api/v1");
        Assert.assertEquals((Object)"https://aamura.cloudhub.io/api/v1/console", (Object)UrlUtils.getBaseUriReplacement((String)"http://0.0.0.0:8081/console"));
        Assert.assertEquals((Object)"https://aamura.cloudhub.io/api/v1/console/", (Object)UrlUtils.getBaseUriReplacement((String)"http://0.0.0.0:8081/console/"));
        System.setProperty(FULL_DOMAIN, "aamura.cloudhub.io/api/v1");
        Assert.assertEquals((Object)"https://aamura.cloudhub.io/api/v1/console", (Object)UrlUtils.getBaseUriReplacement((String)"https://0.0.0.0:8081/console"));
        Assert.assertEquals((Object)"https://aamura.cloudhub.io/api/v1/console/", (Object)UrlUtils.getBaseUriReplacement((String)"https://0.0.0.0:8081/console/"));
        Assert.assertEquals((Object)"http://aamura.cloudhub.io/api/v1/console", (Object)UrlUtils.getBaseUriReplacement((String)"http://0.0.0.0:8081/console"));
        Assert.assertEquals((Object)"http://aamura.cloudhub.io/api/v1/console/", (Object)UrlUtils.getBaseUriReplacement((String)"http://0.0.0.0:8081/console/"));
    }

    @Test
    public void withoutSystemProperty() {
        Assert.assertEquals((Object)"http://localhost:48518/api/", (Object)UrlUtils.getBaseUriReplacement((String)"http://0.0.0.0:48518/api/"));
        Assert.assertEquals((Object)"http://localhost:48518/api/", (Object)UrlUtils.getBaseUriReplacement((String)"http://localhost:48518/api/"));
        Assert.assertNull((Object)UrlUtils.getBaseUriReplacement(null));
    }

    @Test
    public void replaceHostWithIncomingRequestHost() {
        Assert.assertEquals((Object)"http://localhost:48518/api", (Object)UrlUtils.replaceHostInURL((String)"http://0.0.0.0:48518/api", (String)"http://localhost:48518"));
        Assert.assertEquals((Object)"http://localhost:48518/api/", (Object)UrlUtils.replaceHostInURL((String)"http://0.0.0.0:48518/api/", (String)"http://localhost:48518"));
        Assert.assertEquals((Object)"http://localhost:48518/api/", (Object)UrlUtils.replaceHostInURL((String)"http://0.0.0.0:48518/api/", (String)"localhost:48518"));
        Assert.assertEquals((Object)"https://127.0.0.1:48518/api/", (Object)UrlUtils.replaceHostInURL((String)"https://0.0.0.0:48518/api/", (String)"https://127.0.0.1:48518"));
        Assert.assertEquals((Object)"http://192.168.0.196:48518/api/", (Object)UrlUtils.replaceHostInURL((String)"http://0.0.0.0:48518/api/", (String)"http://192.168.0.196:48518"));
        Assert.assertEquals((Object)"https://192.168.0.196:48518/api/", (Object)UrlUtils.replaceHostInURL((String)"https://0.0.0.0:48518/api/", (String)"https://192.168.0.196:48518"));
        Assert.assertEquals((Object)"https://192.168.0.196:48518/api/", (Object)UrlUtils.replaceHostInURL((String)"https://0.0.0.0:48518/api/", (String)"192.168.0.196:48518"));
    }

    @Test
    public void replaceHostWithSystemProperty() {
        System.setProperty(FULL_DOMAIN, "aamura.cloudhub.io/v1");
        Assert.assertEquals((Object)"https://aamura.cloudhub.io/v1/api/", (Object)UrlUtils.replaceHostInURL((String)"https://0.0.0.0:48518/api/", (String)"192.168.0.196:48518"));
        System.setProperty(FULL_DOMAIN, "https://aamura.cloudhub.io/v1");
        Assert.assertEquals((Object)"https://aamura.cloudhub.io/v1/api/", (Object)UrlUtils.replaceHostInURL((String)"https://0.0.0.0:48518/api/", (String)"192.168.0.196:48518"));
    }

    @After
    public void after() {
        System.clearProperty(FULL_DOMAIN);
    }
}

