/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.deserializing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.module.apikit.api.deserializing.ArrayHeaderDelimiter;
import org.mule.module.apikit.deserializing.ArrayHeaderAttributeDeserializer;
import org.mule.module.apikit.deserializing.AttributeDeserializer;
import org.mule.module.apikit.deserializing.DeserializerTestBuilder;
import org.mule.module.apikit.deserializing.DummyAttributeDeserializer;

@RunWith(value=Parameterized.class)
public class AttributeDeserializerTest {
    protected static final String TWO_LEVEL_OBJECT = "{\"color\": \"RED\", \"manufacturer\": {\"brand\": \"Ferrari\"}, \"reseller\": {\"name\": \"YourCar\"}}";
    protected static final String ESCAPED_TWO_LEVEL_OBJECT = "{\\\"color\\\": \\\"RED\\\", \\\"manufacturer\\\": {\\\"brand\\\": \\\"Ferrari\\\"}, \\\"reseller\\\": {\\\"name\\\": \\\"YourCar\\\"}}";
    protected static final String TWO_LEVEL_OBJECT_WITH_LINE_FEEDS = "{\n  \"color\": \"RED\",\n  \"manufacturer\": {\n    \"brand\": \"Ferrari\"\n  }\n  \"reseller\": {\n    \"name\": \"YourCar\"\n  }\n}";
    protected static final String TWO_LEVEL_OBJECT_BETWEEN_QUOTES = "\"{\\\"color\\\": \\\"RED\\\", \\\"manufacturer\\\": {\\\"brand\\\": \\\"Ferrari\\\"}, \\\"reseller\\\": {\\\"name\\\": \\\"YourCar\\\"}}\"";
    @Parameterized.Parameter
    public ArrayHeaderDelimiter arrayHeaderDelimiter;
    @Parameterized.Parameter(value=1)
    public AttributeDeserializer deserializer;
    protected List<String> listOfArrayHeaderValues;
    protected String delimiter;

    @Parameterized.Parameters(name="Delimiter = {0} - {1}")
    public static Iterable<Object[]> data() throws Exception {
        ArrayHeaderDelimiter comma = ArrayHeaderDelimiter.COMMA;
        return Arrays.asList({comma, new ArrayHeaderAttributeDeserializer(comma)}, {comma, new DummyAttributeDeserializer()});
    }

    @Before
    public void init() {
        this.delimiter = this.arrayHeaderDelimiter.getDelimiterValue();
        this.listOfArrayHeaderValues = new ArrayList<String>();
    }

    @Test
    public void deserializeEmptyArrayHeader() {
        List result = this.deserializer.deserializeListOfValues(this.listOfArrayHeaderValues);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void blankValuesAsEmptyStringInArrayHeaders() {
        String value = "   ";
        String expected = "";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(expected).on(ArrayHeaderAttributeDeserializer.class).assertValues(expected);
        value = this.delimiter;
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("", "");
        value = this.delimiter + this.delimiter;
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("", "", "");
        value = this.delimiter + " ";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("", "");
        value = "\"\"" + this.delimiter + "\"  \"";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("", "  ");
    }

    @Test
    public void testSingleValueBetweenEnclosingQuotes() {
        String expected = "This is a unique value";
        String value = "\"" + expected + "\"";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(expected).on(ArrayHeaderAttributeDeserializer.class).assertValues(expected);
    }

    @Test
    public void testValueWithDelimitersBetweenEnclosingQuotes() {
        String expected = "This " + this.delimiter + " is a unique" + this.delimiter + " value";
        String value = "\"" + expected + "\"";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(expected).on(ArrayHeaderAttributeDeserializer.class).assertValues(expected);
    }

    @Test
    public void allowEscapedDoubleQuotesInsideDoubleQuotesInArrayHeaders() {
        String value = "\"This is a \\\"string\\\" with \\\"quotes\\\" inside it\"";
        String expected = "This is a \"string\" with \"quotes\" inside it";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(expected).on(ArrayHeaderAttributeDeserializer.class).assertValues(expected);
        value = "\"commas, between, quotes\\\"" + this.delimiter + "\\\"semicolon; between; quotes\"";
        expected = "commas, between, quotes\"" + this.delimiter + "\"semicolon; between; quotes";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(expected).on(ArrayHeaderAttributeDeserializer.class).assertValues(expected);
    }

    @Test
    public void deserializeObjectBetweenQuotes() {
        String value = TWO_LEVEL_OBJECT_BETWEEN_QUOTES;
        String expected = TWO_LEVEL_OBJECT;
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(expected).on(ArrayHeaderAttributeDeserializer.class).assertValues(expected);
    }

    @Test
    public void deserializeUnquotedObject() {
        String value;
        String expected = value = TWO_LEVEL_OBJECT;
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(expected).on(ArrayHeaderAttributeDeserializer.class).assertValues(expected);
    }

    @Test
    public void lineFeedOutsideQuotesIsIgnored() {
        String value = "\"This is one result\"\n" + this.delimiter + "\"This is in a different line and should not be in result\"";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("This is one result", "This is in a different line and should not be in result");
    }

    @Test
    public void lineFeedBetweenQuotesIsIncludedInResult() {
        String value = "\"This is one result\n with two lines\"" + this.delimiter + "\"This is\n another one\"";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("This is one result\n with two lines", "This is\n another one");
    }

    @Test
    public void lineFeedOutsideCurlyBracesIsIgnored() {
        String value = "{\"key\": \"value1\"}\n" + this.delimiter + "{\"key\": \"value2\"}";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("{\"key\": \"value1\"}", "{\"key\": \"value2\"}");
    }

    @Test
    public void lineFeedBetweenCurlyBracesIsIncludedInResult() {
        String value = TWO_LEVEL_OBJECT_WITH_LINE_FEEDS + this.delimiter + TWO_LEVEL_OBJECT_WITH_LINE_FEEDS;
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues(TWO_LEVEL_OBJECT_WITH_LINE_FEEDS, TWO_LEVEL_OBJECT_WITH_LINE_FEEDS);
    }

    @Test
    public void carriageReturnOutsideQuotesIsIgnored() {
        String value = "\"This is one result\"\r" + this.delimiter + "\"This is another one\"";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("This is one result", "This is another one");
    }

    @Test
    public void carriageReturnBetweenQuotesIsIncludedInResult() {
        String value = "\"This is one result\r with carriage\r returns\"" + this.delimiter + "\"This is\r another one\"";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("This is one result\r with carriage\r returns", "This is\r another one");
    }

    @Test
    public void carriageReturnBetweenCurlyBracesIsIncludedInResult() {
        String value = "{\"key\":\r \"value1\"}" + this.delimiter + "{\"key\":\r \"value2\"}";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("{\"key\":\r \"value1\"}", "{\"key\":\r \"value2\"}");
    }

    @Test
    public void deserializeValidObjectArrayHeaders() {
        String value = "{\"type\": \"username\", \"value\": \"testvalue\"}" + this.delimiter + "{\"type\": \"password\", \"value\": \"testvalue; second\"}";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("{\"type\": \"username\", \"value\": \"testvalue\"}", "{\"type\": \"password\", \"value\": \"testvalue; second\"}");
        value = "{\"type\": \"fullname\", \"value\": \"Jhon Doe\"}";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("{\"type\": \"fullname\", \"value\": \"Jhon Doe\"}");
        value = TWO_LEVEL_OBJECT + this.delimiter + TWO_LEVEL_OBJECT;
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues(TWO_LEVEL_OBJECT, TWO_LEVEL_OBJECT);
        value = TWO_LEVEL_OBJECT_WITH_LINE_FEEDS + this.delimiter + TWO_LEVEL_OBJECT_WITH_LINE_FEEDS;
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues(TWO_LEVEL_OBJECT_WITH_LINE_FEEDS, TWO_LEVEL_OBJECT_WITH_LINE_FEEDS);
        value = "\"{\\\"color\\\": \\\"RED\\\", \\\"manufacturer\\\": {\\\"brand\\\": \\\"Ferrari\\\"}, \\\"reseller\\\": {\\\"name\\\": \\\"YourCar\\\"}}" + this.delimiter + ESCAPED_TWO_LEVEL_OBJECT + "\"";
        String expected = TWO_LEVEL_OBJECT + this.delimiter + TWO_LEVEL_OBJECT;
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(expected).on(ArrayHeaderAttributeDeserializer.class).assertValues(expected);
        value = TWO_LEVEL_OBJECT_BETWEEN_QUOTES + this.delimiter + TWO_LEVEL_OBJECT_BETWEEN_QUOTES;
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues(TWO_LEVEL_OBJECT, TWO_LEVEL_OBJECT);
    }

    @Test
    public void deserializeValidArrayHeaders() {
        String value = "123" + this.delimiter + "456" + this.delimiter + "789";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("123", "456", "789");
        value = "1.213" + this.delimiter + "456" + this.delimiter + "\"7,123.213\"";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("1.213", "456", "7,123.213");
        value = "first" + this.delimiter + "second" + this.delimiter + "third";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("first", "second", "third");
        value = "\"commas, between, quotes\"" + this.delimiter + "\"semicolon; between; quotes\"";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("commas, between, quotes", "semicolon; between; quotes");
        value = "1985-04-12T23:20:50.52Z" + this.delimiter + "\"1996-12-19T16:39:57-08:00\"" + this.delimiter + "1937-01-01T12:00:27.87+00:20";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("1985-04-12T23:20:50.52Z", "1996-12-19T16:39:57-08:00", "1937-01-01T12:00:27.87+00:20");
        value = "\"texto" + this.delimiter + "t\\\"ext\\\"o" + this.delimiter + "t{ext}o" + this.delimiter + "{}texto" + this.delimiter + "texto{}" + this.delimiter + "\\\"texto\\\"{}" + this.delimiter + "{}\\\"texto\\\"\"";
        String expected = "texto" + this.delimiter + "t\"ext\"o" + this.delimiter + "t{ext}o" + this.delimiter + "{}texto" + this.delimiter + "texto{}" + this.delimiter + "\"texto\"{}" + this.delimiter + "{}\"texto\"";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(expected).on(ArrayHeaderAttributeDeserializer.class).assertValues(expected);
        value = "[{\"test\": 1},{\"test\": \"I have \\\"quotes\\\" inside\"}]";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues(value);
    }

    @Test
    public void deserializeMalformedObjectArrayHeaders() {
        String value = "{";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues(value);
        value = "[";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues(value);
        value = "[{}}";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues(value);
        value = "{[]]";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues(value);
        value = "{\"username\"}" + this.delimiter + "{\"testvalue: first\"}" + this.delimiter + "{testvalue: second}";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("{\"username\"}", "{\"testvalue: first\"}", "{testvalue: second}");
        value = "{\"type\": \"username\"{" + this.delimiter + "\"testvalue: second\"}";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues(value);
        value = "{\"type\": \"username\"}}" + this.delimiter + "{}   } ";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("{\"type\": \"username\"}}", "{}   }");
        value = "{\"type\": }\"username\"" + this.delimiter + "\"testvalue: second\"}";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("{\"type\": }\"username\"", "\"testvalue: second\"}");
        value = "{{{{ }}";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues(value);
        value = "{{ }}}}";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues(value);
        value = "{{{{ " + this.delimiter + "}}";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues(value);
        value = "asd\"{{{\"asd}}}";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues(value);
        value = "asd\\\"{{{\\\"asd}}}";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues(value);
        value = "\"\\{\\{\"";
        String expected = "\\{\\{";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(expected).on(ArrayHeaderAttributeDeserializer.class).assertValues(expected);
        value = "texto" + this.delimiter + "t\"ext\"o" + this.delimiter + "t{ext}o" + this.delimiter + "{}texto" + this.delimiter + "texto{}" + this.delimiter + "\"texto\"{}" + this.delimiter + "{}\"texto\"" + this.delimiter + "\"te\\\"x\\\"to\"{}" + this.delimiter + "{}\"te\\\"x\\\"to\"";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues("texto", "t\"ext\"o", "t{ext}o", "{}texto", "texto{}", "\"texto\"{}", "{}\"texto\"", "\"te\\\"x\\\"to\"{}", "{}\"te\\\"x\\\"to\"");
        value = "[{\"test\": 1},{\"test\": 2}";
        DeserializerTestBuilder.when().deserializer(this.deserializer).headerValue(value).then().on(DummyAttributeDeserializer.class).assertValues(value).on(ArrayHeaderAttributeDeserializer.class).assertValues(value);
    }
}

