/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.deserializing;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.mule.module.apikit.deserializing.AttributeDeserializer;

public class DeserializerTestBuilder {
    private List<String> listOfArrayHeaderValues = new ArrayList<String>();
    private AttributeDeserializer deserializer;
    private List<String> resultValues = new ArrayList<String>();
    private Class deserializerClazz;

    public static DeserializerTestBuilder when() {
        return new DeserializerTestBuilder();
    }

    public DeserializerTestBuilder deserializer(AttributeDeserializer deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public DeserializerTestBuilder headerValue(String value) {
        this.listOfArrayHeaderValues.add(value);
        return this;
    }

    public DeserializerTestBuilder then() {
        this.resultValues = this.deserializer.deserializeListOfValues(this.listOfArrayHeaderValues);
        return this;
    }

    public DeserializerTestBuilder on(Class<? extends AttributeDeserializer> deserializerClazz) {
        this.deserializerClazz = deserializerClazz;
        return this;
    }

    public DeserializerTestBuilder assertValues(String ... expected) {
        if (!this.deserializerClazz.equals(this.deserializer.getClass())) {
            return this;
        }
        if (this.resultValues.size() < expected.length) {
            Assert.fail((String)"Number of results are lower than expected");
        } else if (this.resultValues.size() > expected.length) {
            Assert.fail((String)"Number of results are greater than expected");
        }
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)this.resultValues.get(i));
        }
        return this;
    }
}

