/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.deserializing;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.apikit.deserializing.MimeType;

public class MimeTypeTest {
    @Test
    public void canDeserializeASimpleMime() throws MimeType.MimeTypeParseException {
        Assert.assertEquals((Object)new MimeType("text", "plain", MimeTypeTest.list(new MimeType.Parameter[0])), (Object)MimeType.from((String)"text/plain"));
    }

    @Test
    public void canDeserializeAMimeWithParameters() throws MimeType.MimeTypeParseException {
        MimeType expected = new MimeType("text", "plain", MimeTypeTest.list(new MimeType.Parameter("param1", "value1")));
        Assert.assertEquals((Object)expected, (Object)MimeType.from((String)"text/plain; param1=value1"));
    }

    @Test
    public void canDeserializeAMimeWithMultipleParameters() throws MimeType.MimeTypeParseException {
        MimeType expected = new MimeType("text", "plain", MimeTypeTest.list(new MimeType.Parameter("param1", "value1"), new MimeType.Parameter("param2", "value2")));
        Assert.assertEquals((Object)expected, (Object)MimeType.from((String)"text/plain; param1=value1; param2=value2"));
    }

    @Test
    public void canDeserializeAMimeWithQuoteDelimitedParameterValues() throws MimeType.MimeTypeParseException {
        MimeType expected = new MimeType("text", "plain", MimeTypeTest.list(new MimeType.Parameter("param1", "value 1"), new MimeType.Parameter("param2", "value 2")));
        Assert.assertEquals((Object)expected, (Object)MimeType.from((String)"text/plain; param1=\"value 1\"; param2=\"value 2\""));
    }

    @Test
    public void supportsMalformedTypesWithoutSubtype() throws MimeType.MimeTypeParseException {
        Assert.assertEquals((Object)new MimeType("text", "*", MimeTypeTest.list(new MimeType.Parameter[0])), (Object)MimeType.from((String)"text"));
    }

    @Test
    public void supportsParametersOnMalformedTypesWithoutSubtype() throws MimeType.MimeTypeParseException {
        MimeType expected = new MimeType("text", "*", MimeTypeTest.list(new MimeType.Parameter("param1", "value1")));
        Assert.assertEquals((Object)expected, (Object)MimeType.from((String)"text; param1=value1"));
    }

    @Test
    public void ignoresUnimportantSpaces() throws MimeType.MimeTypeParseException {
        Assert.assertEquals((Object)MimeType.from((String)"  image  /  png  ;  hasCat  = \"true\""), (Object)MimeType.from((String)"image/png; hasCat=true"));
    }

    @Test
    public void supportsRepeatedParameters() throws MimeType.MimeTypeParseException {
        MimeType expected = new MimeType("text", "plain", MimeTypeTest.list(new MimeType.Parameter("param", "value1"), new MimeType.Parameter("param", "value2")));
        Assert.assertEquals((Object)expected, (Object)MimeType.from((String)"text/plain; param=value1; param=value2"));
    }

    @Test
    public void ignoresEscapedQuotesInsideQuotes() throws MimeType.MimeTypeParseException {
        MimeType expected = new MimeType("text", "plain", MimeTypeTest.list(new MimeType.Parameter("param", "value \"1\"")));
        Assert.assertEquals((Object)expected, (Object)MimeType.from((String)"text/plain; param=\"value \\\"1\\\"\""));
    }

    @Test
    public void failsIfAdditionalTextIsAtTheEndOfAValidMime() {
        Assert.assertThrows(MimeType.MimeTypeParseException.class, () -> MimeType.from((String)"text/plain error"));
        Assert.assertThrows(MimeType.MimeTypeParseException.class, () -> MimeType.from((String)"text/plain; param=value other text"));
        Assert.assertThrows(MimeType.MimeTypeParseException.class, () -> MimeType.from((String)"text/plain; param=\"the value\" other text"));
        Assert.assertThrows(MimeType.MimeTypeParseException.class, () -> MimeType.from((String)"text/plain; ="));
        Assert.assertThrows(MimeType.MimeTypeParseException.class, () -> MimeType.from((String)"text/plain; =value"));
        Assert.assertThrows(MimeType.MimeTypeParseException.class, () -> MimeType.from((String)"text/plain; =value"));
    }

    @Test
    public void failsIfTextIsMissing() {
        Assert.assertThrows(MimeType.MimeTypeParseException.class, () -> MimeType.from((String)"text/"));
        Assert.assertThrows(MimeType.MimeTypeParseException.class, () -> MimeType.from((String)"text/plain;"));
        Assert.assertThrows(MimeType.MimeTypeParseException.class, () -> MimeType.from((String)"text/plain; param"));
        Assert.assertThrows(MimeType.MimeTypeParseException.class, () -> MimeType.from((String)"text/plain; param="));
        Assert.assertThrows(MimeType.MimeTypeParseException.class, () -> MimeType.from((String)"text/plain; param=value;"));
    }

    @Test
    public void failsOnUnexpectedCodepoints() {
        Assert.assertThrows(MimeType.MimeTypeParseException.class, () -> MimeType.from((String)"text/plain; a=a ; b;b"));
        Assert.assertThrows(MimeType.MimeTypeParseException.class, () -> MimeType.from((String)"text/plain; a=a , b=b"));
        Assert.assertThrows(MimeType.MimeTypeParseException.class, () -> MimeType.from((String)"text ^ plain; a=a ; b=b"));
    }

    @Test
    public void canParseAMimeList() throws MimeType.MimeTypeParseException {
        List<MimeType> mimes = MimeTypeTest.list(new MimeType("text", "plain", MimeTypeTest.list(new MimeType.Parameter[0])), new MimeType("text", "colored", MimeTypeTest.list(new MimeType.Parameter("lang", "es"))), new MimeType("image", "png", MimeTypeTest.list(new MimeType.Parameter("size", "small"), new MimeType.Parameter("cute", "yes yes"))));
        Assert.assertEquals(mimes, (Object)MimeType.listFrom((String)"text/plain, text/colored; lang=es, image/png; size=small; cute=\"yes yes\"", (char)','));
    }

    @Test
    public void gettersCanGet() {
        MimeType mime = new MimeType("text", "plain", MimeTypeTest.list(new MimeType.Parameter("charset", "utf8")));
        Assert.assertEquals((Object)"text", (Object)mime.getType());
        Assert.assertEquals((Object)"plain", (Object)mime.getSubtype());
        Assert.assertEquals((long)1L, (long)mime.getParameters().size());
        Assert.assertEquals((Object)"charset", (Object)((MimeType.Parameter)mime.getParameters().get(0)).getAttribute());
        Assert.assertEquals((Object)"utf8", (Object)((MimeType.Parameter)mime.getParameters().get(0)).getValue());
    }

    @Test
    public void parametersKnowWhenToEscapeThemselves() {
        MimeType.Parameter param = new MimeType.Parameter("attr", "a \"value\"");
        Assert.assertEquals((Object)"attr=\"a \\\"value\\\"\"", (Object)param.toString());
    }

    @Test
    public void parametersKnowWhenQuotesAreNeeded() {
        MimeType.Parameter param = new MimeType.Parameter("attr", "value");
        Assert.assertEquals((Object)"attr=value", (Object)param.toString());
    }

    @Test
    public void mimesHaveTheirCommonStringRepresentations() throws MimeType.MimeTypeParseException {
        Assert.assertEquals((Object)"text/plain", (Object)MimeType.from((String)"text/plain").toString());
        Assert.assertEquals((Object)"text/plain; param=value", (Object)MimeType.from((String)"text/plain; param=value").toString());
        Assert.assertEquals((Object)"text/plain; param=value; anotherParam=anotherValue", (Object)MimeType.from((String)"text/plain; param=value; anotherParam=anotherValue").toString());
    }

    static <T> List<T> list(T ... args) {
        return Arrays.asList(args);
    }
}

