/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.helpers;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.module.apikit.exception.UnsupportedMediaTypeException;
import org.mule.module.apikit.helpers.AttributesHelper;

public class AttributesHelperTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void correctContentType() throws UnsupportedMediaTypeException {
        String mediaType = AttributesHelper.getMediaType((String)"application/json");
        Assert.assertEquals((Object)mediaType, (Object)"application/json");
    }

    @Test
    public void contentTypeWithSuffixAfterSlash() throws UnsupportedMediaTypeException {
        String mediaType = AttributesHelper.getMediaType((String)"application/incorrectContentType");
        Assert.assertEquals((Object)mediaType, (Object)"application/incorrectcontenttype");
    }

    @Test
    public void invalidContentTypeWithoutSuffixAfterSlash() throws UnsupportedMediaTypeException {
        this.expectedException.expect(UnsupportedMediaTypeException.class);
        this.expectedException.expectMessage("MediaType cannot be parsed: application/");
        AttributesHelper.getMediaType((String)"application/");
    }

    @Test
    public void invalidContentTypeWithoutSuffix() throws UnsupportedMediaTypeException {
        this.expectedException.expect(UnsupportedMediaTypeException.class);
        this.expectedException.expectMessage("MediaType cannot be parsed: application");
        AttributesHelper.getMediaType((String)"application");
    }

    @Test
    public void invalidContentTypeWEmpty() throws UnsupportedMediaTypeException {
        this.expectedException.expect(UnsupportedMediaTypeException.class);
        this.expectedException.expectMessage("MediaType cannot be parsed: ");
        AttributesHelper.getMediaType((String)"");
    }

    @Test
    public void invalidContentTypeNull() throws UnsupportedMediaTypeException {
        this.expectedException.expect(UnsupportedMediaTypeException.class);
        this.expectedException.expectMessage("MediaType is null");
        AttributesHelper.getMediaType(null);
    }
}

