/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.uri;

import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.apikit.uri.TokenOperatorDX;
import org.mule.module.apikit.uri.URITemplateSyntaxException;

public class TokenOperatorDXTestCase {
    @Test(expected=URITemplateSyntaxException.class)
    public void parseInvalidExpression() {
        TokenOperatorDX.parse((String)"a");
    }

    @Test
    public void queryParameter() {
        TokenOperatorDX tokenOperator = TokenOperatorDX.parse((String)"{?x,y}");
        Assert.assertThat((Object)tokenOperator.operator(), (Matcher)IsEqual.equalTo((Object)TokenOperatorDX.Operator.QUERY_PARAMETER));
        Assert.assertThat((Object)tokenOperator.isResolvable(), (Matcher)IsEqual.equalTo((Object)true));
    }

    @Test
    public void pathParameter() {
        TokenOperatorDX tokenOperator = TokenOperatorDX.parse((String)"{;x,y,empty}");
        Assert.assertThat((Object)tokenOperator.operator(), (Matcher)IsEqual.equalTo((Object)TokenOperatorDX.Operator.PATH_PARAMETER));
        Assert.assertThat((Object)tokenOperator.isResolvable(), (Matcher)IsEqual.equalTo((Object)true));
    }

    @Test
    public void pathSegment() {
        TokenOperatorDX tokenOperator = TokenOperatorDX.parse((String)"{/list,x}");
        Assert.assertThat((Object)tokenOperator.operator(), (Matcher)IsEqual.equalTo((Object)TokenOperatorDX.Operator.PATH_SEGMENT));
        Assert.assertThat((Object)tokenOperator.isResolvable(), (Matcher)IsEqual.equalTo((Object)true));
    }

    @Test
    public void uriInsert() {
        TokenOperatorDX tokenOperator = TokenOperatorDX.parse((String)"{+test}");
        Assert.assertThat((Object)tokenOperator.operator(), (Matcher)IsEqual.equalTo((Object)TokenOperatorDX.Operator.URI_INSERT));
        Assert.assertThat((Object)tokenOperator.isResolvable(), (Matcher)IsEqual.equalTo((Object)true));
    }

    @Test
    public void substitution() {
        TokenOperatorDX tokenOperator = TokenOperatorDX.parse((String)"test");
        Assert.assertThat((Object)tokenOperator.operator(), (Matcher)IsEqual.equalTo((Object)TokenOperatorDX.Operator.SUBSTITUTION));
        Assert.assertThat((Object)tokenOperator.isResolvable(), (Matcher)IsEqual.equalTo((Object)true));
    }
}

