/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.api.validation.ValidRequest;
import org.mule.module.apikit.exception.NotAcceptableException;
import org.mule.module.apikit.helpers.PayloadHelper;
import org.mule.module.apikit.validation.AbstractRequestValidatorTestCase;
import org.mule.runtime.api.util.MultiMap;

public class HeaderParamsRequestValidator
extends AbstractRequestValidatorTestCase {
    private void validateRequestForAcceptHeader(String acceptHeaderValue) throws MuleRestException {
        this.validateRequestForAcceptHeader(acceptHeaderValue, "/testMimeTypes");
    }

    private void validateRequestForAcceptHeader(String acceptHeaderValue, String relativePath) throws MuleRestException {
        MultiMap headers = new MultiMap();
        headers.put((Object)"Content-Type", (Object)"application/json");
        headers.put((Object)"Accept", (Object)acceptHeaderValue);
        this.testRestRequestValidatorBuilder.withApiLocation("unit/validation/mime-types-api.raml").withRelativePath(relativePath).withMethod("POST").withHeaders((MultiMap<String, String>)headers).withBody((InputStream)PayloadHelper.makePayloadRepeatable((Object)IOUtils.toInputStream((String)"{\"message\":\"All Ok\"}", (Charset)Charset.defaultCharset()))).build().validateRequest();
    }

    @Test
    public void nullSubTypeThrowsNotAcceptableException() throws MuleRestException {
        this.expectedException.expect(NotAcceptableException.class);
        this.validateRequestForAcceptHeader("application/");
    }

    @Test
    public void successWithNullSubTypeWoSlash() throws MuleRestException {
        this.validateRequestForAcceptHeader("application");
    }

    @Test
    public void nullTypeAndSubTypeThrowsNotAcceptableException() throws MuleRestException {
        this.expectedException.expect(NotAcceptableException.class);
        this.validateRequestForAcceptHeader("/");
    }

    @Test
    public void nullTypeThrowsNotAcceptableException() throws MuleRestException {
        this.expectedException.expect(NotAcceptableException.class);
        this.validateRequestForAcceptHeader("/json");
    }

    @Test
    public void invalidTypeThrowsNotAcceptableException() throws MuleRestException {
        this.expectedException.expect(NotAcceptableException.class);
        this.validateRequestForAcceptHeader("application/xml");
    }

    @Test
    public void successWithValidAcceptHeaderValue() throws MuleRestException {
        this.validateRequestForAcceptHeader("application/json");
    }

    @Test
    public void successWithValidAcceptHeaderValueWildcardAccept() throws MuleRestException {
        this.validateRequestForAcceptHeader("application/json", "/testMimeTypesWildcard");
    }

    @Test
    public void successWithValidAcceptWildcardHeaderValueWildcardAccept() throws MuleRestException {
        this.validateRequestForAcceptHeader("*/*", "/testMimeTypesWildcard");
    }

    @Test
    public void successWithNullSubTypeWoSlashWildcardAccept() throws MuleRestException {
        this.validateRequestForAcceptHeader("application", "/testMimeTypesWildcard");
    }

    @Test
    public void successWithValidHeaderNameCaseInsensitivity() throws MuleRestException {
        MultiMap headers = new MultiMap();
        headers.put((Object)"camelcasearray", (Object)"arrayValue");
        headers.put((Object)"camelcasestring", (Object)"stringValue");
        headers.put((Object)"smallcasearray", (Object)"arrayValue");
        headers.put((Object)"smallcasestring", (Object)"stringValue");
        MultiMap validatedHeaders = this.validateRequestForArrayTypeHeader((MultiMap<String, String>)headers).getAttributes().getHeaders();
        Assert.assertEquals((long)validatedHeaders.size(), (long)4L);
        Assert.assertTrue((boolean)validatedHeaders.containsKey((Object)"camelcasearray"));
        Assert.assertTrue((boolean)validatedHeaders.containsKey((Object)"camelcasestring"));
        Assert.assertTrue((boolean)validatedHeaders.containsKey((Object)"smallcasearray"));
        Assert.assertTrue((boolean)validatedHeaders.containsKey((Object)"smallcasestring"));
        Assert.assertTrue((boolean)validatedHeaders.containsKey((Object)"camelCaseArray"));
        Assert.assertTrue((boolean)validatedHeaders.containsKey((Object)"Smallcasestring"));
        Assert.assertTrue((boolean)validatedHeaders.containsKey((Object)"smallcaseArray"));
    }

    private ValidRequest validateRequestForArrayTypeHeader(MultiMap<String, String> headers) throws MuleRestException {
        return this.testRestRequestValidatorBuilder.withApiLocation("unit/validation/header-types-api.raml").withRelativePath("/headerTypes").withMethod("GET").withHeaders(headers).withBody((InputStream)PayloadHelper.makePayloadRepeatable((Object)IOUtils.toInputStream((String)"{\"message\":\"All Ok\"}", (Charset)Charset.defaultCharset()))).build().validateRequest();
    }
}

