/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.util.Collections;
import org.junit.Test;
import org.mule.module.apikit.api.exception.InvalidQueryStringException;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.validation.AbstractRequestValidatorTestCase;
import org.mule.runtime.api.util.MultiMap;

public class QueryStringRequestValidator
extends AbstractRequestValidatorTestCase {
    @Test
    public void validQueryString() throws MuleRestException {
        MultiMap queryParams = new MultiMap();
        queryParams.put((Object)"start", (Object)"2");
        queryParams.put((Object)"lat", (Object)"12");
        queryParams.put((Object)"long", (Object)"13");
        this.testRestRequestValidatorBuilder.withApiLocation("unit/query-string/api.raml").withMethod("GET").withRelativePath("/locations").withQueryParams((MultiMap<String, String>)queryParams).withQueryString("start=2&lat=12&long=13").build().validateRequest();
    }

    @Test
    public void invalidQueryString() {
        MultiMap queryParams = new MultiMap();
        queryParams.put((Object)"start", (Object)"5");
        this.testRestRequestValidatorBuilder.withApiLocation("unit/query-string/api.raml").withMethod("GET").withRelativePath("/locations").withQueryParams((MultiMap<String, String>)queryParams).withQueryString("start=5").build().assertThrows(InvalidQueryStringException.class, "Invalid value for query string");
    }

    @Test
    public void notNullableParameterQueryString() {
        MultiMap queryParams = new MultiMap();
        queryParams.put((Object)"start", Collections.singleton(null));
        this.testRestRequestValidatorBuilder.withApiLocation("unit/query-string/api.raml").withMethod("GET").withRelativePath("/locations").withQueryParams((MultiMap<String, String>)queryParams).withQueryString("start").build().assertThrows(InvalidQueryStringException.class, "Invalid value for query string");
    }

    @Test
    public void nullableParameterQueryString() throws MuleRestException {
        MultiMap queryParams = new MultiMap();
        queryParams.put((Object)"nullableString", Collections.singleton(null));
        this.testRestRequestValidatorBuilder.withApiLocation("unit/query-string/api.raml").withMethod("GET").withRelativePath("/unionQueryString").withQueryParams((MultiMap<String, String>)queryParams).withQueryString("nullableString").build().validateRequest();
    }

    @Test
    public void validQueryStringWithInvalidYAMLValue() throws MuleRestException {
        MultiMap queryParams = new MultiMap();
        queryParams.put((Object)"code", (Object)"*validC*de*");
        queryParams.put((Object)"codes", (Object)"validCode");
        queryParams.put((Object)"codes", (Object)"*validC*de*");
        this.testRestRequestValidatorBuilder.withApiLocation("unit/query-string/special-chars-api.raml").withMethod("GET").withRelativePath("/query-string-validation").withQueryParams((MultiMap<String, String>)queryParams).withQueryString("code=*validC*de*&codes=validCode&codes=*validC*de*").build().validateRequest();
    }

    @Test
    public void validQueryStringWithInvalidUnionYAMLValue() throws MuleRestException {
        MultiMap queryParams = new MultiMap();
        queryParams.put((Object)"code", (Object)"*validC*de*");
        queryParams.put((Object)"unioncode", (Object)"*validC*de*");
        this.testRestRequestValidatorBuilder.withApiLocation("unit/query-string/special-chars-api.raml").withMethod("GET").withRelativePath("/query-string-validation").withQueryParams((MultiMap<String, String>)queryParams).withQueryString("code=*validC*de*&unioncode=*validC*de*").build().validateRequest();
    }

    @Test
    public void invalidQueryStringExceedingLengthWithInvalidYAMLValue() {
        MultiMap queryParams = new MultiMap();
        queryParams.put((Object)"code", (Object)"*invalidC*deLength*");
        this.testRestRequestValidatorBuilder.withApiLocation("unit/query-string/special-chars-api.raml").withMethod("GET").withRelativePath("/query-string-validation").withQueryParams((MultiMap<String, String>)queryParams).withQueryString("code=*invalidC*deLength*").build().assertThrows(InvalidQueryStringException.class, "Invalid value for query string");
    }
}

