/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.apikit.api.exception.InvalidUriParameterException;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.api.validation.ValidRequest;
import org.mule.module.apikit.helpers.PayloadHelper;
import org.mule.module.apikit.validation.AbstractRequestValidatorTestCase;
import org.mule.parser.service.ParserMode;
import org.mule.runtime.api.util.MultiMap;

public class UriParametersOverridingTestCase
extends AbstractRequestValidatorTestCase {
    private static final String RAML08_API_LOCATION = "unit/uri-parameters/raml08/api.raml";
    private static final String RAML10_API_LOCATION = "unit/uri-parameters/raml10/api.raml";
    private static final String OAS20_API_LOCATION = "unit/uri-parameters/oas20/api.yaml";
    private static final String OAS30_API_LOCATION = "unit/uri-parameters/oas30/api.yaml";

    @Test
    public void noUriParamsOverridden() throws MuleRestException {
        this.testRestRequestValidatorBuilder.withRelativePath("/noUriParamsOverridden").withMethod("GET");
        this.validateAllAPIs();
    }

    @Test
    public void noUriParamsOverriddenButRequired() throws MuleRestException {
        this.testRestRequestValidatorBuilder.withRelativePath("/noUriParamsButRequired/testValue").withMethod("GET");
        this.validateRAMLAPIs();
    }

    @Test
    public void templateUriParamsInResource() throws MuleRestException {
        this.testRestRequestValidatorBuilder.withRelativePath("/templateUriParamsInResource/resource").withMethod("GET");
        this.validateAllAPIs();
    }

    @Test
    public void templateUriParamsInResourceInvalidValue() throws MuleRestException {
        this.testRestRequestValidatorBuilder.withRelativePath("/templateUriParamsInResource/invalidValue").withMethod("GET");
        this.validateAllAPIsFail();
    }

    @Test
    public void validateGetWhenTemplateUriParamsInMethods() throws MuleRestException {
        this.testRestRequestValidatorBuilder.withRelativePath("/templateUriParamsInMethods/method-get").withMethod("GET");
        this.validateOASAPIs();
    }

    @Test
    public void templateUriParamsInMethodsInvalidValue() throws MuleRestException {
        this.testRestRequestValidatorBuilder.withRelativePath("/templateUriParamsInMethods/invalidValue").withMethod("GET");
        this.validateOASAPIsFail();
    }

    @Test
    public void validatePutWhenTemplateUriParamsInMethods() throws MuleRestException {
        MultiMap headers = new MultiMap();
        headers.put((Object)"Content-Type", (Object)"application/json");
        this.testRestRequestValidatorBuilder.withRelativePath("/templateUriParamsInMethods/method-put").withMethod("PUT").withHeaders((MultiMap<String, String>)headers).withBody((InputStream)PayloadHelper.makePayloadRepeatable((Object)IOUtils.toInputStream((String)"testValue", (Charset)Charset.defaultCharset())));
        this.validateOASAPIs();
    }

    @Test
    public void templateUriParamsInResourceAndMethods() throws MuleRestException {
        this.testRestRequestValidatorBuilder.withRelativePath("/templateUriParamsInResourceAndMethods/method-get").withMethod("GET");
        this.validateOASAPIs();
    }

    @Test
    public void templateUriParamsInResourceAndMethodsInvalidValue() throws MuleRestException {
        this.testRestRequestValidatorBuilder.withRelativePath("/templateUriParamsInResourceAndMethods/invalidValue").withMethod("GET");
        this.validateOASAPIsFail();
    }

    @Test
    public void validateGetInTemplateUriParamsInResourceOverriddenInMethodPutOnly() throws MuleRestException {
        this.testRestRequestValidatorBuilder.withRelativePath("/templateUriParamsInResourceOverriddenInOneMethod/resource").withMethod("GET");
        this.validateOASAPIs();
    }

    @Test
    public void templateUriParamsInResourceOverriddenInMethodPutOnlyInvalidValue() throws MuleRestException {
        this.testRestRequestValidatorBuilder.withRelativePath("/templateUriParamsInResourceOverriddenInOneMethod/method-get").withMethod("GET");
        this.validateOASAPIsFail();
    }

    @Test
    public void validatePutInTemplateUriParamsInResourceOverriddenInMethodPutOnly() throws MuleRestException {
        MultiMap headers = new MultiMap();
        headers.put((Object)"Content-Type", (Object)"application/json");
        this.testRestRequestValidatorBuilder.withRelativePath("/templateUriParamsInResourceOverriddenInOneMethod/method-put").withMethod("PUT").withHeaders((MultiMap<String, String>)headers).withBody((InputStream)PayloadHelper.makePayloadRepeatable((Object)IOUtils.toInputStream((String)"testValue", (Charset)Charset.defaultCharset())));
        this.validateOASAPIs();
    }

    private ValidRequest validateRequest(String apiLocation) throws MuleRestException {
        return this.testRestRequestValidatorBuilder.withApiLocation(apiLocation).build().validateRequest();
    }

    private void validateRequestFails(String apiLocation) throws MuleRestException {
        try {
            this.validateRequest(apiLocation);
            Assert.fail();
        }
        catch (InvalidUriParameterException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Invalid value"), (Matcher)CoreMatchers.containsString((String)" for uri parameter testParam")));
        }
    }

    public void validateRAMLAPIs() throws MuleRestException {
        this.validateRequest(RAML08_API_LOCATION);
        this.validateRequest(RAML10_API_LOCATION);
    }

    public void validateRAMLAPIsFail() throws MuleRestException {
        this.validateRequestFails(RAML08_API_LOCATION);
        this.validateRequestFails(RAML10_API_LOCATION);
    }

    public void validateOASAPIs() throws MuleRestException {
        if (!ParserMode.RAML.equals((Object)this.parser)) {
            this.validateRequest(OAS20_API_LOCATION);
            this.validateRequest(OAS30_API_LOCATION);
        }
    }

    public void validateOASAPIsFail() throws MuleRestException {
        if (!ParserMode.RAML.equals((Object)this.parser)) {
            this.validateRequestFails(OAS20_API_LOCATION);
            this.validateRequestFails(OAS30_API_LOCATION);
        }
    }

    private void validateAllAPIs() throws MuleRestException {
        this.validateRAMLAPIs();
        this.validateOASAPIs();
    }

    private void validateAllAPIsFail() throws MuleRestException {
        this.validateRAMLAPIsFail();
        this.validateOASAPIsFail();
    }
}

