/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.StreamUtils;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.input.stream.RewindableInputStream;
import org.mule.module.apikit.validation.body.form.MultipartFormValidator;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;

public class MultipartFormValidatorTest {
    private static final String MULTIPART_SIZE_LIMIT_PROP_NAME = "apikit.multipart.size.limit";
    public static final String BOUNDARY = "test";
    public static final String PREAMBLE = "This is the preamble.  It is to be ignored, though it \r\n     is a handy place for mail composers to include an \r\n     explanatory note to non-MIME compliant readers.\r\n";
    public static final String MULTIPART_BODY = "--test\r\nContent-Transfer-encoding: 8bit\r\nContent-type: text/plain; charset=ISO-8859-1\r\nContent-Disposition: form-data; name=\"file\" filename=\"fileName\"\r\n\r\nhello world\r\n--test\r\ncontent-Disposition: form-data; name=\"part1\"\r\nCustom-Header: customValue; customAttribute=customAttrValue\r\nContent-Transfer-Encoding: 8bit\r\ncontent-Type: text/plain; charset=ISO-8859-1\r\n\r\nhello world\r\n--test--\r\n";
    public static final String MULTIPART_BODY_WITH_DEFAULT = "--test\r\nContent-Transfer-encoding: 8bit\r\nContent-type: text/plain; charset=ISO-8859-1\r\nContent-Disposition: form-data; name=\"file\" filename=\"fileName\"\r\n\r\nhello world\r\n--test\r\ncontent-Disposition: form-data; name=\"part1\"\r\nCustom-Header: customValue; customAttribute=customAttrValue\r\nContent-Transfer-Encoding: 8bit\r\ncontent-Type: text/plain; charset=ISO-8859-1\r\n\r\nhello world\r\n--test\r\nContent-Disposition: form-data; name=\"part2\"\r\nContent-Type: text/plain; charset=ISO-8859-1\r\nContent-Transfer-Encoding: 8bit\r\n\r\ntest\r\n--test--\r\n";
    private static final String EPILOGUE = "This is the epilogue.  It is also to be ignored.\r\n";
    private static final String FULL_MULTIPART = "This is the preamble.  It is to be ignored, though it \r\n     is a handy place for mail composers to include an \r\n     explanatory note to non-MIME compliant readers.\r\n--test\r\nContent-Transfer-encoding: 8bit\r\nContent-type: text/plain; charset=ISO-8859-1\r\nContent-Disposition: form-data; name=\"file\" filename=\"fileName\"\r\n\r\nhello world\r\n--test\r\ncontent-Disposition: form-data; name=\"part1\"\r\nCustom-Header: customValue; customAttribute=customAttrValue\r\nContent-Transfer-Encoding: 8bit\r\ncontent-Type: text/plain; charset=ISO-8859-1\r\n\r\nhello world\r\n--test--\r\nThis is the epilogue.  It is also to be ignored.\r\n";
    private static final String FULL_MULTIPART_WITH_DEFAULTS = "This is the preamble.  It is to be ignored, though it \r\n     is a handy place for mail composers to include an \r\n     explanatory note to non-MIME compliant readers.\r\n--test\r\nContent-Transfer-encoding: 8bit\r\nContent-type: text/plain; charset=ISO-8859-1\r\nContent-Disposition: form-data; name=\"file\" filename=\"fileName\"\r\n\r\nhello world\r\n--test\r\ncontent-Disposition: form-data; name=\"part1\"\r\nCustom-Header: customValue; customAttribute=customAttrValue\r\nContent-Transfer-Encoding: 8bit\r\ncontent-Type: text/plain; charset=ISO-8859-1\r\n\r\nhello world\r\n--test\r\nContent-Disposition: form-data; name=\"part2\"\r\nContent-Type: text/plain; charset=ISO-8859-1\r\nContent-Transfer-Encoding: 8bit\r\n\r\ntest\r\n--test--\r\nThis is the epilogue.  It is also to be ignored.\r\n";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @After
    public void after() {
        System.clearProperty(MULTIPART_SIZE_LIMIT_PROP_NAME);
    }

    @Test
    public void validateCursor() throws Exception {
        this.validateTypedValue(this.getTypedValue(FULL_MULTIPART), Collections.emptyMap(), FULL_MULTIPART);
        this.validateTypedValue(this.getTypedValue(MULTIPART_BODY), Collections.emptyMap(), MULTIPART_BODY);
    }

    @Test
    public void validateInputStream() throws Exception {
        this.validateTypedValue(this.getTypedValue(new RewindableInputStream((InputStream)new ByteArrayInputStream(FULL_MULTIPART.getBytes()))), Collections.emptyMap(), FULL_MULTIPART);
        this.validateTypedValue(this.getTypedValue(new RewindableInputStream((InputStream)new ByteArrayInputStream(MULTIPART_BODY.getBytes()))), Collections.emptyMap(), MULTIPART_BODY);
    }

    @Test
    public void validateDefaultParameters() throws Exception {
        Map<String, List<Parameter>> formParameters = this.mockFormParameters(true, BOUNDARY);
        this.validateTypedValue(this.getTypedValue(this.getCursorStreamProvider(FULL_MULTIPART)), formParameters, FULL_MULTIPART_WITH_DEFAULTS);
        this.validateTypedValue(this.getTypedValue(this.getCursorStreamProvider(MULTIPART_BODY)), formParameters, MULTIPART_BODY_WITH_DEFAULT);
        this.validateTypedValue(this.getTypedValue(new RewindableInputStream((InputStream)new ByteArrayInputStream(FULL_MULTIPART.getBytes()))), formParameters, FULL_MULTIPART_WITH_DEFAULTS);
        this.validateTypedValue(this.getTypedValue(new RewindableInputStream((InputStream)new ByteArrayInputStream(MULTIPART_BODY.getBytes()))), formParameters, MULTIPART_BODY_WITH_DEFAULT);
    }

    @Test
    public void validateRequiredParameters() throws Exception {
        Map<String, List<Parameter>> formParameters = this.mockFormParameters(false, null);
        this.validateTypedValue(this.getTypedValue(new RewindableInputStream((InputStream)new ByteArrayInputStream(FULL_MULTIPART.getBytes()))), formParameters, FULL_MULTIPART);
        this.validateTypedValue(this.getTypedValue(new RewindableInputStream((InputStream)new ByteArrayInputStream(MULTIPART_BODY.getBytes()))), formParameters, MULTIPART_BODY);
    }

    @Test
    public void validateMissingRequiredParameters() throws Exception {
        this.expectedException.expect(InvalidFormParameterException.class);
        this.expectedException.expectMessage(CoreMatchers.equalTo((Object)"Required form parameter part2 not specified"));
        Map<String, List<Parameter>> formParameters = this.mockFormParameters(true, null);
        this.validateTypedValue(this.getTypedValue(new RewindableInputStream((InputStream)new ByteArrayInputStream(FULL_MULTIPART.getBytes()))), formParameters, FULL_MULTIPART);
        this.validateTypedValue(this.getTypedValue(new RewindableInputStream((InputStream)new ByteArrayInputStream(MULTIPART_BODY.getBytes()))), formParameters, MULTIPART_BODY);
    }

    @Test
    public void validateMissingRequiredParametersWithDefault() throws Exception {
        Map<String, List<Parameter>> formParameters = this.mockFormParameters(true, BOUNDARY);
        this.validateTypedValue(this.getTypedValue(new RewindableInputStream((InputStream)new ByteArrayInputStream(FULL_MULTIPART.getBytes()))), formParameters, FULL_MULTIPART_WITH_DEFAULTS);
        this.validateTypedValue(this.getTypedValue(new RewindableInputStream((InputStream)new ByteArrayInputStream(MULTIPART_BODY.getBytes()))), formParameters, MULTIPART_BODY_WITH_DEFAULT);
    }

    @Test
    public void sizeLimitExceededTest() throws Exception {
        this.expectedException.expect(InvalidFormParameterException.class);
        this.expectedException.expectMessage(CoreMatchers.equalTo((Object)"Multipart content exceeded the maximum size supported"));
        System.setProperty(MULTIPART_SIZE_LIMIT_PROP_NAME, "250");
        this.validateTypedValue(this.getTypedValue(this.getCursorStreamProvider(FULL_MULTIPART)), Collections.emptyMap(), FULL_MULTIPART);
    }

    public void validateTypedValue(TypedValue typedValue, Map<String, List<Parameter>> formParameters, String expectedPayload) throws Exception {
        MultipartFormValidator multipartFormValidator = new MultipartFormValidator(formParameters);
        TypedValue validatedTypedValue = multipartFormValidator.validate(typedValue);
        long length = validatedTypedValue.getByteLength().orElse(0L);
        InputStream validatedInputStream = StreamUtils.unwrapCursorStream((Object)TypedValue.unwrap((Object)validatedTypedValue));
        Assert.assertEquals((Object)expectedPayload, (Object)IOUtils.toString((InputStream)validatedInputStream));
        Assert.assertEquals((long)expectedPayload.getBytes().length, (long)length);
    }

    private TypedValue getTypedValue(Object value) {
        DataType dataType = MultipartFormValidatorTest.getDataType();
        return new TypedValue(value, dataType);
    }

    private TypedValue getTypedValue(String value) {
        DataType dataType = MultipartFormValidatorTest.getDataType();
        return new TypedValue((Object)this.getCursorStreamProvider(value), dataType, MultipartFormValidatorTest.getOptionalLong(value));
    }

    private static DataType getDataType() {
        return DataType.builder((DataType)DataType.INPUT_STREAM).mediaType(MediaType.parse((String)"multipart/form-data; boundary=\"test\"")).build();
    }

    private static OptionalLong getOptionalLong(String value) {
        return OptionalLong.of(Integer.valueOf(value.length()).longValue());
    }

    private CursorStreamProvider getCursorStreamProvider(final String multipartContent) {
        return new CursorStreamProvider(){

            public CursorStream openCursor() {
                return new CursorStream(){
                    private final InputStream content;
                    {
                        this.content = new ByteArrayInputStream(multipartContent.getBytes());
                    }

                    public int read() throws IOException {
                        return this.content.read();
                    }

                    public long getPosition() {
                        return 0L;
                    }

                    public void seek(long position) {
                    }

                    public void release() {
                    }

                    public boolean isReleased() {
                        return false;
                    }

                    public CursorProvider getProvider() {
                        return null;
                    }
                };
            }

            public void close() {
            }

            public void releaseResources() {
            }

            public boolean isClosed() {
                return false;
            }
        };
    }

    private Map<String, List<Parameter>> mockFormParameters(boolean allRequired, String defaultValue) {
        Parameter part1 = (Parameter)Mockito.mock(Parameter.class);
        Parameter part2 = (Parameter)Mockito.mock(Parameter.class);
        Mockito.when((Object)part1.getFileProperties()).thenReturn(Optional.empty());
        Mockito.when((Object)part2.getFileProperties()).thenReturn(Optional.empty());
        Mockito.when((Object)part1.isRequired()).thenReturn((Object)true);
        Mockito.when((Object)part2.isRequired()).thenReturn((Object)allRequired);
        Mockito.when((Object)part2.getDefaultValues()).thenReturn(defaultValue != null ? Collections.singletonList(defaultValue) : Collections.emptyList());
        Mockito.when((Object)part1.validate(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)part2.validate(ArgumentMatchers.anyString())).thenReturn((Object)true);
        HashMap<String, List<Parameter>> formParameters = new HashMap<String, List<Parameter>>();
        formParameters.put("part1", Collections.singletonList(part1));
        formParameters.put("part2", Collections.singletonList(part2));
        return formParameters;
    }
}

