/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.uri;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.module.apikit.uri.Token;
import org.mule.module.apikit.uri.TokenFactory;
import org.mule.module.apikit.uri.TokenLiteral;
import org.mule.module.apikit.uri.URITemplateSyntaxException;

public class URITemplate {
    private static final Pattern EXPANSION_PATTERN = Pattern.compile("\\{[^}]*}");
    private final String _template;
    private final List<Token> _tokens;

    public URITemplate(String template) throws IllegalArgumentException {
        if (template == null) {
            throw new NullPointerException("Cannot create a URI template with a null template");
        }
        this._tokens = URITemplate.digest(template);
        this._template = template;
    }

    public static List<Token> digest(String template) throws URITemplateSyntaxException {
        return URITemplate.digest(template, TokenFactory.getInstance());
    }

    public static List<Token> digest(String template, TokenFactory factory) throws URITemplateSyntaxException {
        String text;
        ArrayList<Token> tokens = new ArrayList<Token>();
        Matcher m = EXPANSION_PATTERN.matcher(template);
        int start = 0;
        while (m.find()) {
            if (m.start() > start) {
                text = template.substring(start, m.start());
                tokens.add(new TokenLiteral(text));
            }
            String exp = m.group();
            tokens.add(factory.newToken(exp));
            start = m.end();
        }
        if (start < template.length()) {
            text = template.substring(start, template.length());
            if (text.endsWith("*")) {
                tokens.add(new TokenLiteral(text.substring(0, text.length() - 1)));
                tokens.add(factory.newToken("*"));
            } else {
                tokens.add(new TokenLiteral(text));
            }
        }
        return tokens;
    }

    public List<Token> tokens() {
        return this._tokens;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        URITemplate t = (URITemplate)o;
        return this._template == t._template || this._template != null && this._template.equals(t._template);
    }

    public int hashCode() {
        return 127 * this._template.hashCode() + this._template.hashCode();
    }

    public String toString() {
        return this._template;
    }
}

