/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.uri;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.module.apikit.uri.URICoder;

public class URICoderTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void encodeCorrectEncodedURI() {
        MatcherAssert.assertThat((Object)URICoder.encodeRequestPath((String)"api/uri-param/AA%2F11%2F000000%2A70/test"), (Matcher)IsEqual.equalTo((Object)"api/uri-param/AA%2F11%2F000000%2A70/test"));
    }

    @Test
    public void encodeNotEncodedRequestPath() {
        MatcherAssert.assertThat((Object)URICoder.encodeRequestPath((String)"api/uri-param/AA:11 000000 70/test"), (Matcher)IsEqual.equalTo((Object)"api/uri-param/AA%3A11%20000000%2070/test"));
    }

    @Test
    public void halfEncodingIsIncorrect() {
        this.expectedException.expectMessage("Request path contains special characters not encoded");
        URICoder.encodeRequestPath((String)"api/uri-param/AA11%20*70/test");
    }

    @Test
    public void colonInEncodedIsCorrect() {
        MatcherAssert.assertThat((Object)URICoder.encodeRequestPath((String)"api/uri-param/AA:11%2070/test"), (Matcher)IsEqual.equalTo((Object)"api/uri-param/AA:11%2070/test"));
    }

    @Test
    public void encodedColonIsCorrect() {
        MatcherAssert.assertThat((Object)URICoder.encodeRequestPath((String)"api/uri-param/AA%3A11%2070/test"), (Matcher)IsEqual.equalTo((Object)"api/uri-param/AA%3A11%2070/test"));
    }

    @Test
    public void encodeRequestPathWithoutReservedChars() {
        MatcherAssert.assertThat((Object)URICoder.encodeRequestPath((String)"api/uri-param/AA00000070/test"), (Matcher)IsEqual.equalTo((Object)"api/uri-param/AA00000070/test"));
    }
}

