/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.apikit.api.RoutingTable;
import org.mule.module.apikit.api.exception.MethodNotAllowedException;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.api.uri.URIPattern;
import org.mule.module.apikit.validation.AbstractRequestValidatorTestCase;

public class MethodNotAllowedTestCase
extends AbstractRequestValidatorTestCase {
    @Test
    public void throwMethodNotAllowedExceptionTest() throws MuleRestException {
        this.expectedException.expect(MethodNotAllowedException.class);
        this.expectedException.expectMessage(CoreMatchers.equalTo((Object)"HTTP Method post not allowed for : /path/{version}/job/{jobId}"));
        this.testRestRequestValidatorBuilder.withApiLocation("unit/validation/api-with-version.raml").withRelativePath("/path/1.0/job/123").withMethod("POST").build().validateRequest();
    }

    @Test
    public void validRequestTest() throws Exception {
        this.testRestRequestValidatorBuilder.withApiLocation("unit/validation/api-resources.raml").withRelativePath("/test/something").withMethod("GET").build().validateRequest();
        this.testRestRequestValidatorBuilder.withApiLocation("unit/validation/api-resources.raml").withRelativePath("/test/something/else").withMethod("PUT").build().validateRequest();
    }

    @Test
    public void validRoutingTableTest() {
        RoutingTable routingTable = this.testRestRequestValidatorBuilder.withApiLocation("unit/validation/api-resources.raml").withRelativePath("/test/something").withMethod("GET").build().getRoutingTable();
        Assert.assertNotNull((Object)routingTable);
        Assert.assertEquals((long)2L, (long)routingTable.keySet().size());
        Assert.assertTrue((boolean)routingTable.keySet().contains(new URIPattern("/test/{resourceZ}")));
    }
}

